/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.EnclosedInStringPropertiesCopier;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenameField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RenameField> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RenameField.getter(RenameField::name)).setter(RenameField.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(RenameField.getter(RenameField::inputs)).setter(RenameField.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourcePath").getter(RenameField.getter(RenameField::sourcePath)).setter(RenameField.setter(Builder::sourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetPath").getter(RenameField.getter(RenameField::targetPath)).setter(RenameField.setter(Builder::targetPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, SOURCE_PATH_FIELD, TARGET_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Inputs", INPUTS_FIELD);
            this.put("SourcePath", SOURCE_PATH_FIELD);
            this.put("TargetPath", TARGET_PATH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final List<String> sourcePath;
    private final List<String> targetPath;

    private RenameField(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.sourcePath = builder.sourcePath;
        this.targetPath = builder.targetPath;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final boolean hasSourcePath() {
        return this.sourcePath != null && !(this.sourcePath instanceof SdkAutoConstructList);
    }

    public final List<String> sourcePath() {
        return this.sourcePath;
    }

    public final boolean hasTargetPath() {
        return this.targetPath != null && !(this.targetPath instanceof SdkAutoConstructList);
    }

    public final List<String> targetPath() {
        return this.targetPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourcePath() ? this.sourcePath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetPath() ? this.targetPath() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenameField)) {
            return false;
        }
        RenameField other = (RenameField)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasSourcePath() == other.hasSourcePath() && Objects.equals(this.sourcePath(), other.sourcePath()) && this.hasTargetPath() == other.hasTargetPath() && Objects.equals(this.targetPath(), other.targetPath());
    }

    public final String toString() {
        return ToString.builder((String)"RenameField").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("SourcePath", this.hasSourcePath() ? this.sourcePath() : null).add("TargetPath", this.hasTargetPath() ? this.targetPath() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "SourcePath": {
                return Optional.ofNullable(clazz.cast(this.sourcePath()));
            }
            case "TargetPath": {
                return Optional.ofNullable(clazz.cast(this.targetPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RenameField, T> g) {
        return obj -> g.apply((RenameField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<String> sourcePath = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetPath = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RenameField model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.sourcePath(model.sourcePath);
            this.targetPath(model.targetPath);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final Collection<String> getSourcePath() {
            if (this.sourcePath instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourcePath;
        }

        public final void setSourcePath(Collection<String> sourcePath) {
            this.sourcePath = EnclosedInStringPropertiesCopier.copy(sourcePath);
        }

        @Override
        public final Builder sourcePath(Collection<String> sourcePath) {
            this.sourcePath = EnclosedInStringPropertiesCopier.copy(sourcePath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePath(String ... sourcePath) {
            this.sourcePath(Arrays.asList(sourcePath));
            return this;
        }

        public final Collection<String> getTargetPath() {
            if (this.targetPath instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetPath;
        }

        public final void setTargetPath(Collection<String> targetPath) {
            this.targetPath = EnclosedInStringPropertiesCopier.copy(targetPath);
        }

        @Override
        public final Builder targetPath(Collection<String> targetPath) {
            this.targetPath = EnclosedInStringPropertiesCopier.copy(targetPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetPath(String ... targetPath) {
            this.targetPath(Arrays.asList(targetPath));
            return this;
        }

        public RenameField build() {
            return new RenameField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RenameField> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder sourcePath(Collection<String> var1);

        public Builder sourcePath(String ... var1);

        public Builder targetPath(Collection<String> var1);

        public Builder targetPath(String ... var1);
    }
}

