/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ClassifierNameListCopier;
import software.amazon.awssdk.services.glue.model.CrawlerState;
import software.amazon.awssdk.services.glue.model.CrawlerTargets;
import software.amazon.awssdk.services.glue.model.LakeFormationConfiguration;
import software.amazon.awssdk.services.glue.model.LastCrawlInfo;
import software.amazon.awssdk.services.glue.model.LineageConfiguration;
import software.amazon.awssdk.services.glue.model.RecrawlPolicy;
import software.amazon.awssdk.services.glue.model.Schedule;
import software.amazon.awssdk.services.glue.model.SchemaChangePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Crawler
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Crawler> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Crawler.getter(Crawler::name)).setter(Crawler.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(Crawler.getter(Crawler::role)).setter(Crawler.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<CrawlerTargets> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Targets").getter(Crawler.getter(Crawler::targets)).setter(Crawler.setter(Builder::targets)).constructor(CrawlerTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(Crawler.getter(Crawler::databaseName)).setter(Crawler.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Crawler.getter(Crawler::description)).setter(Crawler.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> CLASSIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Classifiers").getter(Crawler.getter(Crawler::classifiers)).setter(Crawler.setter(Builder::classifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecrawlPolicy> RECRAWL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecrawlPolicy").getter(Crawler.getter(Crawler::recrawlPolicy)).setter(Crawler.setter(Builder::recrawlPolicy)).constructor(RecrawlPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecrawlPolicy").build()}).build();
    private static final SdkField<SchemaChangePolicy> SCHEMA_CHANGE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaChangePolicy").getter(Crawler.getter(Crawler::schemaChangePolicy)).setter(Crawler.setter(Builder::schemaChangePolicy)).constructor(SchemaChangePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChangePolicy").build()}).build();
    private static final SdkField<LineageConfiguration> LINEAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LineageConfiguration").getter(Crawler.getter(Crawler::lineageConfiguration)).setter(Crawler.setter(Builder::lineageConfiguration)).constructor(LineageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageConfiguration").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Crawler.getter(Crawler::stateAsString)).setter(Crawler.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> TABLE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TablePrefix").getter(Crawler.getter(Crawler::tablePrefix)).setter(Crawler.setter(Builder::tablePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePrefix").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(Crawler.getter(Crawler::schedule)).setter(Crawler.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<Long> CRAWL_ELAPSED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CrawlElapsedTime").getter(Crawler.getter(Crawler::crawlElapsedTime)).setter(Crawler.setter(Builder::crawlElapsedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlElapsedTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Crawler.getter(Crawler::creationTime)).setter(Crawler.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(Crawler.getter(Crawler::lastUpdated)).setter(Crawler.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<LastCrawlInfo> LAST_CRAWL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastCrawl").getter(Crawler.getter(Crawler::lastCrawl)).setter(Crawler.setter(Builder::lastCrawl)).constructor(LastCrawlInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCrawl").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(Crawler.getter(Crawler::version)).setter(Crawler.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Configuration").getter(Crawler.getter(Crawler::configuration)).setter(Crawler.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> CRAWLER_SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrawlerSecurityConfiguration").getter(Crawler.getter(Crawler::crawlerSecurityConfiguration)).setter(Crawler.setter(Builder::crawlerSecurityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerSecurityConfiguration").build()}).build();
    private static final SdkField<LakeFormationConfiguration> LAKE_FORMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LakeFormationConfiguration").getter(Crawler.getter(Crawler::lakeFormationConfiguration)).setter(Crawler.setter(Builder::lakeFormationConfiguration)).constructor(LakeFormationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_FIELD, TARGETS_FIELD, DATABASE_NAME_FIELD, DESCRIPTION_FIELD, CLASSIFIERS_FIELD, RECRAWL_POLICY_FIELD, SCHEMA_CHANGE_POLICY_FIELD, LINEAGE_CONFIGURATION_FIELD, STATE_FIELD, TABLE_PREFIX_FIELD, SCHEDULE_FIELD, CRAWL_ELAPSED_TIME_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, LAST_CRAWL_FIELD, VERSION_FIELD, CONFIGURATION_FIELD, CRAWLER_SECURITY_CONFIGURATION_FIELD, LAKE_FORMATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Role", ROLE_FIELD);
            this.put("Targets", TARGETS_FIELD);
            this.put("DatabaseName", DATABASE_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Classifiers", CLASSIFIERS_FIELD);
            this.put("RecrawlPolicy", RECRAWL_POLICY_FIELD);
            this.put("SchemaChangePolicy", SCHEMA_CHANGE_POLICY_FIELD);
            this.put("LineageConfiguration", LINEAGE_CONFIGURATION_FIELD);
            this.put("State", STATE_FIELD);
            this.put("TablePrefix", TABLE_PREFIX_FIELD);
            this.put("Schedule", SCHEDULE_FIELD);
            this.put("CrawlElapsedTime", CRAWL_ELAPSED_TIME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastUpdated", LAST_UPDATED_FIELD);
            this.put("LastCrawl", LAST_CRAWL_FIELD);
            this.put("Version", VERSION_FIELD);
            this.put("Configuration", CONFIGURATION_FIELD);
            this.put("CrawlerSecurityConfiguration", CRAWLER_SECURITY_CONFIGURATION_FIELD);
            this.put("LakeFormationConfiguration", LAKE_FORMATION_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String role;
    private final CrawlerTargets targets;
    private final String databaseName;
    private final String description;
    private final List<String> classifiers;
    private final RecrawlPolicy recrawlPolicy;
    private final SchemaChangePolicy schemaChangePolicy;
    private final LineageConfiguration lineageConfiguration;
    private final String state;
    private final String tablePrefix;
    private final Schedule schedule;
    private final Long crawlElapsedTime;
    private final Instant creationTime;
    private final Instant lastUpdated;
    private final LastCrawlInfo lastCrawl;
    private final Long version;
    private final String configuration;
    private final String crawlerSecurityConfiguration;
    private final LakeFormationConfiguration lakeFormationConfiguration;

    private Crawler(BuilderImpl builder) {
        this.name = builder.name;
        this.role = builder.role;
        this.targets = builder.targets;
        this.databaseName = builder.databaseName;
        this.description = builder.description;
        this.classifiers = builder.classifiers;
        this.recrawlPolicy = builder.recrawlPolicy;
        this.schemaChangePolicy = builder.schemaChangePolicy;
        this.lineageConfiguration = builder.lineageConfiguration;
        this.state = builder.state;
        this.tablePrefix = builder.tablePrefix;
        this.schedule = builder.schedule;
        this.crawlElapsedTime = builder.crawlElapsedTime;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.lastCrawl = builder.lastCrawl;
        this.version = builder.version;
        this.configuration = builder.configuration;
        this.crawlerSecurityConfiguration = builder.crawlerSecurityConfiguration;
        this.lakeFormationConfiguration = builder.lakeFormationConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String role() {
        return this.role;
    }

    public final CrawlerTargets targets() {
        return this.targets;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasClassifiers() {
        return this.classifiers != null && !(this.classifiers instanceof SdkAutoConstructList);
    }

    public final List<String> classifiers() {
        return this.classifiers;
    }

    public final RecrawlPolicy recrawlPolicy() {
        return this.recrawlPolicy;
    }

    public final SchemaChangePolicy schemaChangePolicy() {
        return this.schemaChangePolicy;
    }

    public final LineageConfiguration lineageConfiguration() {
        return this.lineageConfiguration;
    }

    public final CrawlerState state() {
        return CrawlerState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String tablePrefix() {
        return this.tablePrefix;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final Long crawlElapsedTime() {
        return this.crawlElapsedTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final LastCrawlInfo lastCrawl() {
        return this.lastCrawl;
    }

    public final Long version() {
        return this.version;
    }

    public final String configuration() {
        return this.configuration;
    }

    public final String crawlerSecurityConfiguration() {
        return this.crawlerSecurityConfiguration;
    }

    public final LakeFormationConfiguration lakeFormationConfiguration() {
        return this.lakeFormationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClassifiers() ? this.classifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recrawlPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaChangePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlElapsedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCrawl());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerSecurityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakeFormationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Crawler)) {
            return false;
        }
        Crawler other = (Crawler)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.description(), other.description()) && this.hasClassifiers() == other.hasClassifiers() && Objects.equals(this.classifiers(), other.classifiers()) && Objects.equals(this.recrawlPolicy(), other.recrawlPolicy()) && Objects.equals(this.schemaChangePolicy(), other.schemaChangePolicy()) && Objects.equals(this.lineageConfiguration(), other.lineageConfiguration()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.tablePrefix(), other.tablePrefix()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.crawlElapsedTime(), other.crawlElapsedTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.lastCrawl(), other.lastCrawl()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.crawlerSecurityConfiguration(), other.crawlerSecurityConfiguration()) && Objects.equals(this.lakeFormationConfiguration(), other.lakeFormationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Crawler").add("Name", (Object)this.name()).add("Role", (Object)this.role()).add("Targets", (Object)this.targets()).add("DatabaseName", (Object)this.databaseName()).add("Description", (Object)this.description()).add("Classifiers", this.hasClassifiers() ? this.classifiers() : null).add("RecrawlPolicy", (Object)this.recrawlPolicy()).add("SchemaChangePolicy", (Object)this.schemaChangePolicy()).add("LineageConfiguration", (Object)this.lineageConfiguration()).add("State", (Object)this.stateAsString()).add("TablePrefix", (Object)this.tablePrefix()).add("Schedule", (Object)this.schedule()).add("CrawlElapsedTime", (Object)this.crawlElapsedTime()).add("CreationTime", (Object)this.creationTime()).add("LastUpdated", (Object)this.lastUpdated()).add("LastCrawl", (Object)this.lastCrawl()).add("Version", (Object)this.version()).add("Configuration", (Object)this.configuration()).add("CrawlerSecurityConfiguration", (Object)this.crawlerSecurityConfiguration()).add("LakeFormationConfiguration", (Object)this.lakeFormationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Classifiers": {
                return Optional.ofNullable(clazz.cast(this.classifiers()));
            }
            case "RecrawlPolicy": {
                return Optional.ofNullable(clazz.cast(this.recrawlPolicy()));
            }
            case "SchemaChangePolicy": {
                return Optional.ofNullable(clazz.cast(this.schemaChangePolicy()));
            }
            case "LineageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lineageConfiguration()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "TablePrefix": {
                return Optional.ofNullable(clazz.cast(this.tablePrefix()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "CrawlElapsedTime": {
                return Optional.ofNullable(clazz.cast(this.crawlElapsedTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "LastCrawl": {
                return Optional.ofNullable(clazz.cast(this.lastCrawl()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "CrawlerSecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.crawlerSecurityConfiguration()));
            }
            case "LakeFormationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lakeFormationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Crawler, T> g) {
        return obj -> g.apply((Crawler)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String role;
        private CrawlerTargets targets;
        private String databaseName;
        private String description;
        private List<String> classifiers = DefaultSdkAutoConstructList.getInstance();
        private RecrawlPolicy recrawlPolicy;
        private SchemaChangePolicy schemaChangePolicy;
        private LineageConfiguration lineageConfiguration;
        private String state;
        private String tablePrefix;
        private Schedule schedule;
        private Long crawlElapsedTime;
        private Instant creationTime;
        private Instant lastUpdated;
        private LastCrawlInfo lastCrawl;
        private Long version;
        private String configuration;
        private String crawlerSecurityConfiguration;
        private LakeFormationConfiguration lakeFormationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Crawler model) {
            this.name(model.name);
            this.role(model.role);
            this.targets(model.targets);
            this.databaseName(model.databaseName);
            this.description(model.description);
            this.classifiers(model.classifiers);
            this.recrawlPolicy(model.recrawlPolicy);
            this.schemaChangePolicy(model.schemaChangePolicy);
            this.lineageConfiguration(model.lineageConfiguration);
            this.state(model.state);
            this.tablePrefix(model.tablePrefix);
            this.schedule(model.schedule);
            this.crawlElapsedTime(model.crawlElapsedTime);
            this.creationTime(model.creationTime);
            this.lastUpdated(model.lastUpdated);
            this.lastCrawl(model.lastCrawl);
            this.version(model.version);
            this.configuration(model.configuration);
            this.crawlerSecurityConfiguration(model.crawlerSecurityConfiguration);
            this.lakeFormationConfiguration(model.lakeFormationConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final CrawlerTargets.Builder getTargets() {
            return this.targets != null ? this.targets.toBuilder() : null;
        }

        public final void setTargets(CrawlerTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        @Override
        public final Builder targets(CrawlerTargets targets) {
            this.targets = targets;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getClassifiers() {
            if (this.classifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.classifiers;
        }

        public final void setClassifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
        }

        @Override
        public final Builder classifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifiers(String ... classifiers) {
            this.classifiers(Arrays.asList(classifiers));
            return this;
        }

        public final RecrawlPolicy.Builder getRecrawlPolicy() {
            return this.recrawlPolicy != null ? this.recrawlPolicy.toBuilder() : null;
        }

        public final void setRecrawlPolicy(RecrawlPolicy.BuilderImpl recrawlPolicy) {
            this.recrawlPolicy = recrawlPolicy != null ? recrawlPolicy.build() : null;
        }

        @Override
        public final Builder recrawlPolicy(RecrawlPolicy recrawlPolicy) {
            this.recrawlPolicy = recrawlPolicy;
            return this;
        }

        public final SchemaChangePolicy.Builder getSchemaChangePolicy() {
            return this.schemaChangePolicy != null ? this.schemaChangePolicy.toBuilder() : null;
        }

        public final void setSchemaChangePolicy(SchemaChangePolicy.BuilderImpl schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy != null ? schemaChangePolicy.build() : null;
        }

        @Override
        public final Builder schemaChangePolicy(SchemaChangePolicy schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        public final LineageConfiguration.Builder getLineageConfiguration() {
            return this.lineageConfiguration != null ? this.lineageConfiguration.toBuilder() : null;
        }

        public final void setLineageConfiguration(LineageConfiguration.BuilderImpl lineageConfiguration) {
            this.lineageConfiguration = lineageConfiguration != null ? lineageConfiguration.build() : null;
        }

        @Override
        public final Builder lineageConfiguration(LineageConfiguration lineageConfiguration) {
            this.lineageConfiguration = lineageConfiguration;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CrawlerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getTablePrefix() {
            return this.tablePrefix;
        }

        public final void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        @Override
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Long getCrawlElapsedTime() {
            return this.crawlElapsedTime;
        }

        public final void setCrawlElapsedTime(Long crawlElapsedTime) {
            this.crawlElapsedTime = crawlElapsedTime;
        }

        @Override
        public final Builder crawlElapsedTime(Long crawlElapsedTime) {
            this.crawlElapsedTime = crawlElapsedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final LastCrawlInfo.Builder getLastCrawl() {
            return this.lastCrawl != null ? this.lastCrawl.toBuilder() : null;
        }

        public final void setLastCrawl(LastCrawlInfo.BuilderImpl lastCrawl) {
            this.lastCrawl = lastCrawl != null ? lastCrawl.build() : null;
        }

        @Override
        public final Builder lastCrawl(LastCrawlInfo lastCrawl) {
            this.lastCrawl = lastCrawl;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getCrawlerSecurityConfiguration() {
            return this.crawlerSecurityConfiguration;
        }

        public final void setCrawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
            this.crawlerSecurityConfiguration = crawlerSecurityConfiguration;
        }

        @Override
        public final Builder crawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
            this.crawlerSecurityConfiguration = crawlerSecurityConfiguration;
            return this;
        }

        public final LakeFormationConfiguration.Builder getLakeFormationConfiguration() {
            return this.lakeFormationConfiguration != null ? this.lakeFormationConfiguration.toBuilder() : null;
        }

        public final void setLakeFormationConfiguration(LakeFormationConfiguration.BuilderImpl lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration != null ? lakeFormationConfiguration.build() : null;
        }

        @Override
        public final Builder lakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration;
            return this;
        }

        public Crawler build() {
            return new Crawler(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Crawler> {
        public Builder name(String var1);

        public Builder role(String var1);

        public Builder targets(CrawlerTargets var1);

        default public Builder targets(Consumer<CrawlerTargets.Builder> targets) {
            return this.targets((CrawlerTargets)((CrawlerTargets.Builder)CrawlerTargets.builder().applyMutation(targets)).build());
        }

        public Builder databaseName(String var1);

        public Builder description(String var1);

        public Builder classifiers(Collection<String> var1);

        public Builder classifiers(String ... var1);

        public Builder recrawlPolicy(RecrawlPolicy var1);

        default public Builder recrawlPolicy(Consumer<RecrawlPolicy.Builder> recrawlPolicy) {
            return this.recrawlPolicy((RecrawlPolicy)((RecrawlPolicy.Builder)RecrawlPolicy.builder().applyMutation(recrawlPolicy)).build());
        }

        public Builder schemaChangePolicy(SchemaChangePolicy var1);

        default public Builder schemaChangePolicy(Consumer<SchemaChangePolicy.Builder> schemaChangePolicy) {
            return this.schemaChangePolicy((SchemaChangePolicy)((SchemaChangePolicy.Builder)SchemaChangePolicy.builder().applyMutation(schemaChangePolicy)).build());
        }

        public Builder lineageConfiguration(LineageConfiguration var1);

        default public Builder lineageConfiguration(Consumer<LineageConfiguration.Builder> lineageConfiguration) {
            return this.lineageConfiguration((LineageConfiguration)((LineageConfiguration.Builder)LineageConfiguration.builder().applyMutation(lineageConfiguration)).build());
        }

        public Builder state(String var1);

        public Builder state(CrawlerState var1);

        public Builder tablePrefix(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder crawlElapsedTime(Long var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder lastCrawl(LastCrawlInfo var1);

        default public Builder lastCrawl(Consumer<LastCrawlInfo.Builder> lastCrawl) {
            return this.lastCrawl((LastCrawlInfo)((LastCrawlInfo.Builder)LastCrawlInfo.builder().applyMutation(lastCrawl)).build());
        }

        public Builder version(Long var1);

        public Builder configuration(String var1);

        public Builder crawlerSecurityConfiguration(String var1);

        public Builder lakeFormationConfiguration(LakeFormationConfiguration var1);

        default public Builder lakeFormationConfiguration(Consumer<LakeFormationConfiguration.Builder> lakeFormationConfiguration) {
            return this.lakeFormationConfiguration((LakeFormationConfiguration)((LakeFormationConfiguration.Builder)LakeFormationConfiguration.builder().applyMutation(lakeFormationConfiguration)).build());
        }
    }
}

