/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueSchema;
import software.amazon.awssdk.services.glue.model.GlueSchemasCopier;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.services.glue.model.TransformConfigParameter;
import software.amazon.awssdk.services.glue.model.TransformConfigParameterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamicTransform
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamicTransform> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DynamicTransform.getter(DynamicTransform::name)).setter(DynamicTransform.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TRANSFORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformName").getter(DynamicTransform.getter(DynamicTransform::transformName)).setter(DynamicTransform.setter(Builder::transformName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformName").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(DynamicTransform.getter(DynamicTransform::inputs)).setter(DynamicTransform.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TransformConfigParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(DynamicTransform.getter(DynamicTransform::parameters)).setter(DynamicTransform.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransformConfigParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(DynamicTransform.getter(DynamicTransform::functionName)).setter(DynamicTransform.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(DynamicTransform.getter(DynamicTransform::path)).setter(DynamicTransform.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(DynamicTransform.getter(DynamicTransform::version)).setter(DynamicTransform.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputSchemas").getter(DynamicTransform.getter(DynamicTransform::outputSchemas)).setter(DynamicTransform.setter(Builder::outputSchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlueSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TRANSFORM_NAME_FIELD, INPUTS_FIELD, PARAMETERS_FIELD, FUNCTION_NAME_FIELD, PATH_FIELD, VERSION_FIELD, OUTPUT_SCHEMAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("TransformName", TRANSFORM_NAME_FIELD);
            this.put("Inputs", INPUTS_FIELD);
            this.put("Parameters", PARAMETERS_FIELD);
            this.put("FunctionName", FUNCTION_NAME_FIELD);
            this.put("Path", PATH_FIELD);
            this.put("Version", VERSION_FIELD);
            this.put("OutputSchemas", OUTPUT_SCHEMAS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String transformName;
    private final List<String> inputs;
    private final List<TransformConfigParameter> parameters;
    private final String functionName;
    private final String path;
    private final String version;
    private final List<GlueSchema> outputSchemas;

    private DynamicTransform(BuilderImpl builder) {
        this.name = builder.name;
        this.transformName = builder.transformName;
        this.inputs = builder.inputs;
        this.parameters = builder.parameters;
        this.functionName = builder.functionName;
        this.path = builder.path;
        this.version = builder.version;
        this.outputSchemas = builder.outputSchemas;
    }

    public final String name() {
        return this.name;
    }

    public final String transformName() {
        return this.transformName;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<TransformConfigParameter> parameters() {
        return this.parameters;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String path() {
        return this.path;
    }

    public final String version() {
        return this.version;
    }

    public final boolean hasOutputSchemas() {
        return this.outputSchemas != null && !(this.outputSchemas instanceof SdkAutoConstructList);
    }

    public final List<GlueSchema> outputSchemas() {
        return this.outputSchemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSchemas() ? this.outputSchemas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicTransform)) {
            return false;
        }
        DynamicTransform other = (DynamicTransform)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.transformName(), other.transformName()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.version(), other.version()) && this.hasOutputSchemas() == other.hasOutputSchemas() && Objects.equals(this.outputSchemas(), other.outputSchemas());
    }

    public final String toString() {
        return ToString.builder((String)"DynamicTransform").add("Name", (Object)this.name()).add("TransformName", (Object)this.transformName()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Parameters", this.hasParameters() ? this.parameters() : null).add("FunctionName", (Object)this.functionName()).add("Path", (Object)this.path()).add("Version", (Object)this.version()).add("OutputSchemas", this.hasOutputSchemas() ? this.outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TransformName": {
                return Optional.ofNullable(clazz.cast(this.transformName()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "OutputSchemas": {
                return Optional.ofNullable(clazz.cast(this.outputSchemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DynamicTransform, T> g) {
        return obj -> g.apply((DynamicTransform)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String transformName;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<TransformConfigParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private String functionName;
        private String path;
        private String version;
        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicTransform model) {
            this.name(model.name);
            this.transformName(model.transformName);
            this.inputs(model.inputs);
            this.parameters(model.parameters);
            this.functionName(model.functionName);
            this.path(model.path);
            this.version(model.version);
            this.outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTransformName() {
            return this.transformName;
        }

        public final void setTransformName(String transformName) {
            this.transformName = transformName;
        }

        @Override
        public final Builder transformName(String transformName) {
            this.transformName = transformName;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final List<TransformConfigParameter.Builder> getParameters() {
            List<TransformConfigParameter.Builder> result = TransformConfigParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<TransformConfigParameter.BuilderImpl> parameters) {
            this.parameters = TransformConfigParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<TransformConfigParameter> parameters) {
            this.parameters = TransformConfigParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(TransformConfigParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<TransformConfigParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (TransformConfigParameter)((TransformConfigParameter.Builder)TransformConfigParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema ... outputSchemas) {
            this.outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder> ... outputSchemas) {
            this.outputSchemas(Stream.of(outputSchemas).map(c -> (GlueSchema)((GlueSchema.Builder)GlueSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DynamicTransform build() {
            return new DynamicTransform(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamicTransform> {
        public Builder name(String var1);

        public Builder transformName(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder parameters(Collection<TransformConfigParameter> var1);

        public Builder parameters(TransformConfigParameter ... var1);

        public Builder parameters(Consumer<TransformConfigParameter.Builder> ... var1);

        public Builder functionName(String var1);

        public Builder path(String var1);

        public Builder version(String var1);

        public Builder outputSchemas(Collection<GlueSchema> var1);

        public Builder outputSchemas(GlueSchema ... var1);

        public Builder outputSchemas(Consumer<GlueSchema.Builder> ... var1);
    }
}

