/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.AuditContext;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.PermissionType;
import software.amazon.awssdk.services.glue.model.PermissionTypeListCopier;
import software.amazon.awssdk.services.glue.model.QuerySessionContext;
import software.amazon.awssdk.services.glue.model.Segment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUnfilteredPartitionsMetadataRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetUnfilteredPartitionsMetadataRequest> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::region)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::catalogId)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::databaseName)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::tableName)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::expression)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<AuditContext> AUDIT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuditContext").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::auditContext)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::auditContext)).constructor(AuditContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditContext").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_PERMISSION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedPermissionTypes").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::supportedPermissionTypesAsStrings)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::supportedPermissionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPermissionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::nextToken)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Segment> SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Segment").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::segment)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::segment)).constructor(Segment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::maxResults)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<QuerySessionContext> QUERY_SESSION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QuerySessionContext").getter(GetUnfilteredPartitionsMetadataRequest.getter(GetUnfilteredPartitionsMetadataRequest::querySessionContext)).setter(GetUnfilteredPartitionsMetadataRequest.setter(Builder::querySessionContext)).constructor(QuerySessionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySessionContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, EXPRESSION_FIELD, AUDIT_CONTEXT_FIELD, SUPPORTED_PERMISSION_TYPES_FIELD, NEXT_TOKEN_FIELD, SEGMENT_FIELD, MAX_RESULTS_FIELD, QUERY_SESSION_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Region", REGION_FIELD);
            this.put("CatalogId", CATALOG_ID_FIELD);
            this.put("DatabaseName", DATABASE_NAME_FIELD);
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("Expression", EXPRESSION_FIELD);
            this.put("AuditContext", AUDIT_CONTEXT_FIELD);
            this.put("SupportedPermissionTypes", SUPPORTED_PERMISSION_TYPES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Segment", SEGMENT_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("QuerySessionContext", QUERY_SESSION_CONTEXT_FIELD);
        }
    });
    private final String region;
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final String expression;
    private final AuditContext auditContext;
    private final List<String> supportedPermissionTypes;
    private final String nextToken;
    private final Segment segment;
    private final Integer maxResults;
    private final QuerySessionContext querySessionContext;

    private GetUnfilteredPartitionsMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.region = builder.region;
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.expression = builder.expression;
        this.auditContext = builder.auditContext;
        this.supportedPermissionTypes = builder.supportedPermissionTypes;
        this.nextToken = builder.nextToken;
        this.segment = builder.segment;
        this.maxResults = builder.maxResults;
        this.querySessionContext = builder.querySessionContext;
    }

    public final String region() {
        return this.region;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String expression() {
        return this.expression;
    }

    public final AuditContext auditContext() {
        return this.auditContext;
    }

    public final List<PermissionType> supportedPermissionTypes() {
        return PermissionTypeListCopier.copyStringToEnum(this.supportedPermissionTypes);
    }

    public final boolean hasSupportedPermissionTypes() {
        return this.supportedPermissionTypes != null && !(this.supportedPermissionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedPermissionTypesAsStrings() {
        return this.supportedPermissionTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Segment segment() {
        return this.segment;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final QuerySessionContext querySessionContext() {
        return this.querySessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedPermissionTypes() ? this.supportedPermissionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.segment());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.querySessionContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredPartitionsMetadataRequest)) {
            return false;
        }
        GetUnfilteredPartitionsMetadataRequest other = (GetUnfilteredPartitionsMetadataRequest)((Object)obj);
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.auditContext(), other.auditContext()) && this.hasSupportedPermissionTypes() == other.hasSupportedPermissionTypes() && Objects.equals(this.supportedPermissionTypesAsStrings(), other.supportedPermissionTypesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.segment(), other.segment()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.querySessionContext(), other.querySessionContext());
    }

    public final String toString() {
        return ToString.builder((String)"GetUnfilteredPartitionsMetadataRequest").add("Region", (Object)this.region()).add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("Expression", (Object)this.expression()).add("AuditContext", (Object)this.auditContext()).add("SupportedPermissionTypes", this.hasSupportedPermissionTypes() ? this.supportedPermissionTypesAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("Segment", (Object)this.segment()).add("MaxResults", (Object)this.maxResults()).add("QuerySessionContext", (Object)this.querySessionContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "AuditContext": {
                return Optional.ofNullable(clazz.cast(this.auditContext()));
            }
            case "SupportedPermissionTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedPermissionTypesAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Segment": {
                return Optional.ofNullable(clazz.cast(this.segment()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "QuerySessionContext": {
                return Optional.ofNullable(clazz.cast(this.querySessionContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredPartitionsMetadataRequest, T> g) {
        return obj -> g.apply((GetUnfilteredPartitionsMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String region;
        private String catalogId;
        private String databaseName;
        private String tableName;
        private String expression;
        private AuditContext auditContext;
        private List<String> supportedPermissionTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Segment segment;
        private Integer maxResults;
        private QuerySessionContext querySessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredPartitionsMetadataRequest model) {
            super(model);
            this.region(model.region);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.expression(model.expression);
            this.auditContext(model.auditContext);
            this.supportedPermissionTypesWithStrings(model.supportedPermissionTypes);
            this.nextToken(model.nextToken);
            this.segment(model.segment);
            this.maxResults(model.maxResults);
            this.querySessionContext(model.querySessionContext);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final AuditContext.Builder getAuditContext() {
            return this.auditContext != null ? this.auditContext.toBuilder() : null;
        }

        public final void setAuditContext(AuditContext.BuilderImpl auditContext) {
            this.auditContext = auditContext != null ? auditContext.build() : null;
        }

        @Override
        public final Builder auditContext(AuditContext auditContext) {
            this.auditContext = auditContext;
            return this;
        }

        public final Collection<String> getSupportedPermissionTypes() {
            if (this.supportedPermissionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedPermissionTypes;
        }

        public final void setSupportedPermissionTypes(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
        }

        @Override
        public final Builder supportedPermissionTypesWithStrings(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypesWithStrings(String ... supportedPermissionTypes) {
            this.supportedPermissionTypesWithStrings(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        @Override
        public final Builder supportedPermissionTypes(Collection<PermissionType> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copyEnumToString(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypes(PermissionType ... supportedPermissionTypes) {
            this.supportedPermissionTypes(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Segment.Builder getSegment() {
            return this.segment != null ? this.segment.toBuilder() : null;
        }

        public final void setSegment(Segment.BuilderImpl segment) {
            this.segment = segment != null ? segment.build() : null;
        }

        @Override
        public final Builder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final QuerySessionContext.Builder getQuerySessionContext() {
            return this.querySessionContext != null ? this.querySessionContext.toBuilder() : null;
        }

        public final void setQuerySessionContext(QuerySessionContext.BuilderImpl querySessionContext) {
            this.querySessionContext = querySessionContext != null ? querySessionContext.build() : null;
        }

        @Override
        public final Builder querySessionContext(QuerySessionContext querySessionContext) {
            this.querySessionContext = querySessionContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUnfilteredPartitionsMetadataRequest build() {
            return new GetUnfilteredPartitionsMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUnfilteredPartitionsMetadataRequest> {
        public Builder region(String var1);

        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder expression(String var1);

        public Builder auditContext(AuditContext var1);

        default public Builder auditContext(Consumer<AuditContext.Builder> auditContext) {
            return this.auditContext((AuditContext)((AuditContext.Builder)AuditContext.builder().applyMutation(auditContext)).build());
        }

        public Builder supportedPermissionTypesWithStrings(Collection<String> var1);

        public Builder supportedPermissionTypesWithStrings(String ... var1);

        public Builder supportedPermissionTypes(Collection<PermissionType> var1);

        public Builder supportedPermissionTypes(PermissionType ... var1);

        public Builder nextToken(String var1);

        public Builder segment(Segment var1);

        default public Builder segment(Consumer<Segment.Builder> segment) {
            return this.segment((Segment)((Segment.Builder)Segment.builder().applyMutation(segment)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder querySessionContext(QuerySessionContext var1);

        default public Builder querySessionContext(Consumer<QuerySessionContext.Builder> querySessionContext) {
            return this.querySessionContext((QuerySessionContext)((QuerySessionContext.Builder)QuerySessionContext.builder().applyMutation(querySessionContext)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

