/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlueprintRunsResponse extends GlueResponse implements
        ToCopyableBuilder<GetBlueprintRunsResponse.Builder, GetBlueprintRunsResponse> {
    private static final SdkField<List<BlueprintRun>> BLUEPRINT_RUNS_FIELD = SdkField
            .<List<BlueprintRun>> builder(MarshallingType.LIST)
            .memberName("BlueprintRuns")
            .getter(getter(GetBlueprintRunsResponse::blueprintRuns))
            .setter(setter(Builder::blueprintRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlueprintRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlueprintRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetBlueprintRunsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_RUNS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BlueprintRun> blueprintRuns;

    private final String nextToken;

    private GetBlueprintRunsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprintRuns = builder.blueprintRuns;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlueprintRuns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlueprintRuns() {
        return blueprintRuns != null && !(blueprintRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of <code>BlueprintRun</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlueprintRuns} method.
     * </p>
     * 
     * @return Returns a list of <code>BlueprintRun</code> objects.
     */
    public final List<BlueprintRun> blueprintRuns() {
        return blueprintRuns;
    }

    /**
     * <p>
     * A continuation token, if not all blueprint runs have been returned.
     * </p>
     * 
     * @return A continuation token, if not all blueprint runs have been returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlueprintRuns() ? blueprintRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintRunsResponse)) {
            return false;
        }
        GetBlueprintRunsResponse other = (GetBlueprintRunsResponse) obj;
        return hasBlueprintRuns() == other.hasBlueprintRuns() && Objects.equals(blueprintRuns(), other.blueprintRuns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBlueprintRunsResponse").add("BlueprintRuns", hasBlueprintRuns() ? blueprintRuns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueprintRuns":
            return Optional.ofNullable(clazz.cast(blueprintRuns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlueprintRuns", BLUEPRINT_RUNS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBlueprintRunsResponse, T> g) {
        return obj -> g.apply((GetBlueprintRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBlueprintRunsResponse> {
        /**
         * <p>
         * Returns a list of <code>BlueprintRun</code> objects.
         * </p>
         * 
         * @param blueprintRuns
         *        Returns a list of <code>BlueprintRun</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintRuns(Collection<BlueprintRun> blueprintRuns);

        /**
         * <p>
         * Returns a list of <code>BlueprintRun</code> objects.
         * </p>
         * 
         * @param blueprintRuns
         *        Returns a list of <code>BlueprintRun</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintRuns(BlueprintRun... blueprintRuns);

        /**
         * <p>
         * Returns a list of <code>BlueprintRun</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.BlueprintRun.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.BlueprintRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.BlueprintRun.Builder#build()} is called immediately and its
         * result is passed to {@link #blueprintRuns(List<BlueprintRun>)}.
         * 
         * @param blueprintRuns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.BlueprintRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueprintRuns(java.util.Collection<BlueprintRun>)
         */
        Builder blueprintRuns(Consumer<BlueprintRun.Builder>... blueprintRuns);

        /**
         * <p>
         * A continuation token, if not all blueprint runs have been returned.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if not all blueprint runs have been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<BlueprintRun> blueprintRuns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintRunsResponse model) {
            super(model);
            blueprintRuns(model.blueprintRuns);
            nextToken(model.nextToken);
        }

        public final List<BlueprintRun.Builder> getBlueprintRuns() {
            List<BlueprintRun.Builder> result = BlueprintRunsCopier.copyToBuilder(this.blueprintRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprintRuns(Collection<BlueprintRun.BuilderImpl> blueprintRuns) {
            this.blueprintRuns = BlueprintRunsCopier.copyFromBuilder(blueprintRuns);
        }

        @Override
        public final Builder blueprintRuns(Collection<BlueprintRun> blueprintRuns) {
            this.blueprintRuns = BlueprintRunsCopier.copy(blueprintRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprintRuns(BlueprintRun... blueprintRuns) {
            blueprintRuns(Arrays.asList(blueprintRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprintRuns(Consumer<BlueprintRun.Builder>... blueprintRuns) {
            blueprintRuns(Stream.of(blueprintRuns).map(c -> BlueprintRun.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetBlueprintRunsResponse build() {
            return new GetBlueprintRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
