/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CatalogTablesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogTarget> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(CatalogTarget.getter(CatalogTarget::databaseName)).setter(CatalogTarget.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<List<String>> TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tables").getter(CatalogTarget.getter(CatalogTarget::tables)).setter(CatalogTarget.setter(Builder::tables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(CatalogTarget.getter(CatalogTarget::connectionName)).setter(CatalogTarget.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> EVENT_QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventQueueArn").getter(CatalogTarget.getter(CatalogTarget::eventQueueArn)).setter(CatalogTarget.setter(Builder::eventQueueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventQueueArn").build()}).build();
    private static final SdkField<String> DLQ_EVENT_QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DlqEventQueueArn").getter(CatalogTarget.getter(CatalogTarget::dlqEventQueueArn)).setter(CatalogTarget.setter(Builder::dlqEventQueueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlqEventQueueArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, TABLES_FIELD, CONNECTION_NAME_FIELD, EVENT_QUEUE_ARN_FIELD, DLQ_EVENT_QUEUE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CatalogTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final List<String> tables;
    private final String connectionName;
    private final String eventQueueArn;
    private final String dlqEventQueueArn;

    private CatalogTarget(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tables = builder.tables;
        this.connectionName = builder.connectionName;
        this.eventQueueArn = builder.eventQueueArn;
        this.dlqEventQueueArn = builder.dlqEventQueueArn;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final boolean hasTables() {
        return this.tables != null && !(this.tables instanceof SdkAutoConstructList);
    }

    public final List<String> tables() {
        return this.tables;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String eventQueueArn() {
        return this.eventQueueArn;
    }

    public final String dlqEventQueueArn() {
        return this.dlqEventQueueArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTables() ? this.tables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dlqEventQueueArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogTarget)) {
            return false;
        }
        CatalogTarget other = (CatalogTarget)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && this.hasTables() == other.hasTables() && Objects.equals(this.tables(), other.tables()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.eventQueueArn(), other.eventQueueArn()) && Objects.equals(this.dlqEventQueueArn(), other.dlqEventQueueArn());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogTarget").add("DatabaseName", (Object)this.databaseName()).add("Tables", this.hasTables() ? this.tables() : null).add("ConnectionName", (Object)this.connectionName()).add("EventQueueArn", (Object)this.eventQueueArn()).add("DlqEventQueueArn", (Object)this.dlqEventQueueArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Tables": {
                return Optional.ofNullable(clazz.cast(this.tables()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "EventQueueArn": {
                return Optional.ofNullable(clazz.cast(this.eventQueueArn()));
            }
            case "DlqEventQueueArn": {
                return Optional.ofNullable(clazz.cast(this.dlqEventQueueArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("Tables", TABLES_FIELD);
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("EventQueueArn", EVENT_QUEUE_ARN_FIELD);
        map.put("DlqEventQueueArn", DLQ_EVENT_QUEUE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CatalogTarget, T> g) {
        return obj -> g.apply((CatalogTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private List<String> tables = DefaultSdkAutoConstructList.getInstance();
        private String connectionName;
        private String eventQueueArn;
        private String dlqEventQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogTarget model) {
            this.databaseName(model.databaseName);
            this.tables(model.tables);
            this.connectionName(model.connectionName);
            this.eventQueueArn(model.eventQueueArn);
            this.dlqEventQueueArn(model.dlqEventQueueArn);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Collection<String> getTables() {
            if (this.tables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tables;
        }

        public final void setTables(Collection<String> tables) {
            this.tables = CatalogTablesListCopier.copy(tables);
        }

        @Override
        public final Builder tables(Collection<String> tables) {
            this.tables = CatalogTablesListCopier.copy(tables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(String ... tables) {
            this.tables(Arrays.asList(tables));
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getEventQueueArn() {
            return this.eventQueueArn;
        }

        public final void setEventQueueArn(String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
        }

        @Override
        public final Builder eventQueueArn(String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
            return this;
        }

        public final String getDlqEventQueueArn() {
            return this.dlqEventQueueArn;
        }

        public final void setDlqEventQueueArn(String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
        }

        @Override
        public final Builder dlqEventQueueArn(String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
            return this;
        }

        public CatalogTarget build() {
            return new CatalogTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogTarget> {
        public Builder databaseName(String var1);

        public Builder tables(Collection<String> var1);

        public Builder tables(String ... var1);

        public Builder connectionName(String var1);

        public Builder eventQueueArn(String var1);

        public Builder dlqEventQueueArn(String var1);
    }
}

