/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the authentication configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationConfiguration.Builder, AuthenticationConfiguration> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(AuthenticationConfiguration::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(AuthenticationConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<OAuth2Properties> O_AUTH2_PROPERTIES_FIELD = SdkField
            .<OAuth2Properties> builder(MarshallingType.SDK_POJO).memberName("OAuth2Properties")
            .getter(getter(AuthenticationConfiguration::oAuth2Properties)).setter(setter(Builder::oAuth2Properties))
            .constructor(OAuth2Properties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2Properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            SECRET_ARN_FIELD, O_AUTH2_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private final String secretArn;

    private final OAuth2Properties oAuth2Properties;

    private AuthenticationConfiguration(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.secretArn = builder.secretArn;
        this.oAuth2Properties = builder.oAuth2Properties;
    }

    /**
     * <p>
     * A structure containing the authentication configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return A structure containing the authentication configuration.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * A structure containing the authentication configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return A structure containing the authentication configuration.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The secret manager ARN to store credentials.
     * </p>
     * 
     * @return The secret manager ARN to store credentials.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The properties for OAuth2 authentication.
     * </p>
     * 
     * @return The properties for OAuth2 authentication.
     */
    public final OAuth2Properties oAuth2Properties() {
        return oAuth2Properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2Properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfiguration)) {
            return false;
        }
        AuthenticationConfiguration other = (AuthenticationConfiguration) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(secretArn(), other.secretArn()) && Objects.equals(oAuth2Properties(), other.oAuth2Properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationConfiguration").add("AuthenticationType", authenticationTypeAsString())
                .add("SecretArn", secretArn()).add("OAuth2Properties", oAuth2Properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "OAuth2Properties":
            return Optional.ofNullable(clazz.cast(oAuth2Properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("OAuth2Properties", O_AUTH2_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfiguration, T> g) {
        return obj -> g.apply((AuthenticationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationConfiguration> {
        /**
         * <p>
         * A structure containing the authentication configuration.
         * </p>
         * 
         * @param authenticationType
         *        A structure containing the authentication configuration.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * A structure containing the authentication configuration.
         * </p>
         * 
         * @param authenticationType
         *        A structure containing the authentication configuration.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The secret manager ARN to store credentials.
         * </p>
         * 
         * @param secretArn
         *        The secret manager ARN to store credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The properties for OAuth2 authentication.
         * </p>
         * 
         * @param oAuth2Properties
         *        The properties for OAuth2 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth2Properties(OAuth2Properties oAuth2Properties);

        /**
         * <p>
         * The properties for OAuth2 authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuth2Properties.Builder} avoiding the
         * need to create one manually via {@link OAuth2Properties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuth2Properties.Builder#build()} is called immediately and its
         * result is passed to {@link #oAuth2Properties(OAuth2Properties)}.
         * 
         * @param oAuth2Properties
         *        a consumer that will call methods on {@link OAuth2Properties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth2Properties(OAuth2Properties)
         */
        default Builder oAuth2Properties(Consumer<OAuth2Properties.Builder> oAuth2Properties) {
            return oAuth2Properties(OAuth2Properties.builder().applyMutation(oAuth2Properties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private String secretArn;

        private OAuth2Properties oAuth2Properties;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfiguration model) {
            authenticationType(model.authenticationType);
            secretArn(model.secretArn);
            oAuth2Properties(model.oAuth2Properties);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final OAuth2Properties.Builder getOAuth2Properties() {
            return oAuth2Properties != null ? oAuth2Properties.toBuilder() : null;
        }

        public final void setOAuth2Properties(OAuth2Properties.BuilderImpl oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties != null ? oAuth2Properties.build() : null;
        }

        @Override
        public final Builder oAuth2Properties(OAuth2Properties oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties;
            return this;
        }

        @Override
        public AuthenticationConfiguration build() {
            return new AuthenticationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
