/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information for a run of a crawler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrawlerHistory implements SdkPojo, Serializable, ToCopyableBuilder<CrawlerHistory.Builder, CrawlerHistory> {
    private static final SdkField<String> CRAWL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrawlId").getter(getter(CrawlerHistory::crawlId)).setter(setter(Builder::crawlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CrawlerHistory::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(CrawlerHistory::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(CrawlerHistory::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Summary")
            .getter(getter(CrawlerHistory::summary)).setter(setter(Builder::summary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(CrawlerHistory::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroup").getter(getter(CrawlerHistory::logGroup)).setter(setter(Builder::logGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()).build();

    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStream").getter(getter(CrawlerHistory::logStream)).setter(setter(Builder::logStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStream").build()).build();

    private static final SdkField<String> MESSAGE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessagePrefix").getter(getter(CrawlerHistory::messagePrefix)).setter(setter(Builder::messagePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagePrefix").build()).build();

    private static final SdkField<Double> DPU_HOUR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DPUHour").getter(getter(CrawlerHistory::dpuHour)).setter(setter(Builder::dpuHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPUHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWL_ID_FIELD, STATE_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, SUMMARY_FIELD, ERROR_MESSAGE_FIELD, LOG_GROUP_FIELD, LOG_STREAM_FIELD,
            MESSAGE_PREFIX_FIELD, DPU_HOUR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String crawlId;

    private final String state;

    private final Instant startTime;

    private final Instant endTime;

    private final String summary;

    private final String errorMessage;

    private final String logGroup;

    private final String logStream;

    private final String messagePrefix;

    private final Double dpuHour;

    private CrawlerHistory(BuilderImpl builder) {
        this.crawlId = builder.crawlId;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.summary = builder.summary;
        this.errorMessage = builder.errorMessage;
        this.logGroup = builder.logGroup;
        this.logStream = builder.logStream;
        this.messagePrefix = builder.messagePrefix;
        this.dpuHour = builder.dpuHour;
    }

    /**
     * <p>
     * A UUID identifier for each crawl.
     * </p>
     * 
     * @return A UUID identifier for each crawl.
     */
    public final String crawlId() {
        return crawlId;
    }

    /**
     * <p>
     * The state of the crawl.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CrawlerHistoryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the crawl.
     * @see CrawlerHistoryState
     */
    public final CrawlerHistoryState state() {
        return CrawlerHistoryState.fromValue(state);
    }

    /**
     * <p>
     * The state of the crawl.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CrawlerHistoryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the crawl.
     * @see CrawlerHistoryState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time on which the crawl started.
     * </p>
     * 
     * @return The date and time on which the crawl started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time on which the crawl ended.
     * </p>
     * 
     * @return The date and time on which the crawl ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A run summary for the specific crawl in JSON. Contains the catalog tables and partitions that were added,
     * updated, or deleted.
     * </p>
     * 
     * @return A run summary for the specific crawl in JSON. Contains the catalog tables and partitions that were added,
     *         updated, or deleted.
     */
    public final String summary() {
        return summary;
    }

    /**
     * <p>
     * If an error occurred, the error message associated with the crawl.
     * </p>
     * 
     * @return If an error occurred, the error message associated with the crawl.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The log group associated with the crawl.
     * </p>
     * 
     * @return The log group associated with the crawl.
     */
    public final String logGroup() {
        return logGroup;
    }

    /**
     * <p>
     * The log stream associated with the crawl.
     * </p>
     * 
     * @return The log stream associated with the crawl.
     */
    public final String logStream() {
        return logStream;
    }

    /**
     * <p>
     * The prefix for a CloudWatch message about this crawl.
     * </p>
     * 
     * @return The prefix for a CloudWatch message about this crawl.
     */
    public final String messagePrefix() {
        return messagePrefix;
    }

    /**
     * <p>
     * The number of data processing units (DPU) used in hours for the crawl.
     * </p>
     * 
     * @return The number of data processing units (DPU) used in hours for the crawl.
     */
    public final Double dpuHour() {
        return dpuHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crawlId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(logStream());
        hashCode = 31 * hashCode + Objects.hashCode(messagePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(dpuHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerHistory)) {
            return false;
        }
        CrawlerHistory other = (CrawlerHistory) obj;
        return Objects.equals(crawlId(), other.crawlId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(summary(), other.summary()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(logGroup(), other.logGroup()) && Objects.equals(logStream(), other.logStream())
                && Objects.equals(messagePrefix(), other.messagePrefix()) && Objects.equals(dpuHour(), other.dpuHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrawlerHistory").add("CrawlId", crawlId()).add("State", stateAsString())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("Summary", summary())
                .add("ErrorMessage", errorMessage()).add("LogGroup", logGroup()).add("LogStream", logStream())
                .add("MessagePrefix", messagePrefix()).add("DPUHour", dpuHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlId":
            return Optional.ofNullable(clazz.cast(crawlId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "LogGroup":
            return Optional.ofNullable(clazz.cast(logGroup()));
        case "LogStream":
            return Optional.ofNullable(clazz.cast(logStream()));
        case "MessagePrefix":
            return Optional.ofNullable(clazz.cast(messagePrefix()));
        case "DPUHour":
            return Optional.ofNullable(clazz.cast(dpuHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CrawlId", CRAWL_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("LogGroup", LOG_GROUP_FIELD);
        map.put("LogStream", LOG_STREAM_FIELD);
        map.put("MessagePrefix", MESSAGE_PREFIX_FIELD);
        map.put("DPUHour", DPU_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrawlerHistory, T> g) {
        return obj -> g.apply((CrawlerHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrawlerHistory> {
        /**
         * <p>
         * A UUID identifier for each crawl.
         * </p>
         * 
         * @param crawlId
         *        A UUID identifier for each crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlId(String crawlId);

        /**
         * <p>
         * The state of the crawl.
         * </p>
         * 
         * @param state
         *        The state of the crawl.
         * @see CrawlerHistoryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlerHistoryState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the crawl.
         * </p>
         * 
         * @param state
         *        The state of the crawl.
         * @see CrawlerHistoryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlerHistoryState
         */
        Builder state(CrawlerHistoryState state);

        /**
         * <p>
         * The date and time on which the crawl started.
         * </p>
         * 
         * @param startTime
         *        The date and time on which the crawl started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time on which the crawl ended.
         * </p>
         * 
         * @param endTime
         *        The date and time on which the crawl ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A run summary for the specific crawl in JSON. Contains the catalog tables and partitions that were added,
         * updated, or deleted.
         * </p>
         * 
         * @param summary
         *        A run summary for the specific crawl in JSON. Contains the catalog tables and partitions that were
         *        added, updated, or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(String summary);

        /**
         * <p>
         * If an error occurred, the error message associated with the crawl.
         * </p>
         * 
         * @param errorMessage
         *        If an error occurred, the error message associated with the crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The log group associated with the crawl.
         * </p>
         * 
         * @param logGroup
         *        The log group associated with the crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroup(String logGroup);

        /**
         * <p>
         * The log stream associated with the crawl.
         * </p>
         * 
         * @param logStream
         *        The log stream associated with the crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStream(String logStream);

        /**
         * <p>
         * The prefix for a CloudWatch message about this crawl.
         * </p>
         * 
         * @param messagePrefix
         *        The prefix for a CloudWatch message about this crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messagePrefix(String messagePrefix);

        /**
         * <p>
         * The number of data processing units (DPU) used in hours for the crawl.
         * </p>
         * 
         * @param dpuHour
         *        The number of data processing units (DPU) used in hours for the crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpuHour(Double dpuHour);
    }

    static final class BuilderImpl implements Builder {
        private String crawlId;

        private String state;

        private Instant startTime;

        private Instant endTime;

        private String summary;

        private String errorMessage;

        private String logGroup;

        private String logStream;

        private String messagePrefix;

        private Double dpuHour;

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlerHistory model) {
            crawlId(model.crawlId);
            state(model.state);
            startTime(model.startTime);
            endTime(model.endTime);
            summary(model.summary);
            errorMessage(model.errorMessage);
            logGroup(model.logGroup);
            logStream(model.logStream);
            messagePrefix(model.messagePrefix);
            dpuHour(model.dpuHour);
        }

        public final String getCrawlId() {
            return crawlId;
        }

        public final void setCrawlId(String crawlId) {
            this.crawlId = crawlId;
        }

        @Override
        public final Builder crawlId(String crawlId) {
            this.crawlId = crawlId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CrawlerHistoryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getSummary() {
            return summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getLogGroup() {
            return logGroup;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final String getLogStream() {
            return logStream;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final String getMessagePrefix() {
            return messagePrefix;
        }

        public final void setMessagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
        }

        @Override
        public final Builder messagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
            return this;
        }

        public final Double getDpuHour() {
            return dpuHour;
        }

        public final void setDpuHour(Double dpuHour) {
            this.dpuHour = dpuHour;
        }

        @Override
        public final Builder dpuHour(Double dpuHour) {
            this.dpuHour = dpuHour;
            return this;
        }

        @Override
        public CrawlerHistory build() {
            return new CrawlerHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
