/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing details for representations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewDefinition implements SdkPojo, Serializable, ToCopyableBuilder<ViewDefinition.Builder, ViewDefinition> {
    private static final SdkField<Boolean> IS_PROTECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsProtected").getter(getter(ViewDefinition::isProtected)).setter(setter(Builder::isProtected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsProtected").build()).build();

    private static final SdkField<String> DEFINER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Definer")
            .getter(getter(ViewDefinition::definer)).setter(setter(Builder::definer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definer").build()).build();

    private static final SdkField<List<String>> SUB_OBJECTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubObjects")
            .getter(getter(ViewDefinition::subObjects))
            .setter(setter(Builder::subObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubObjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ViewRepresentation>> REPRESENTATIONS_FIELD = SdkField
            .<List<ViewRepresentation>> builder(MarshallingType.LIST)
            .memberName("Representations")
            .getter(getter(ViewDefinition::representations))
            .setter(setter(Builder::representations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Representations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ViewRepresentation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ViewRepresentation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PROTECTED_FIELD,
            DEFINER_FIELD, SUB_OBJECTS_FIELD, REPRESENTATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isProtected;

    private final String definer;

    private final List<String> subObjects;

    private final List<ViewRepresentation> representations;

    private ViewDefinition(BuilderImpl builder) {
        this.isProtected = builder.isProtected;
        this.definer = builder.definer;
        this.subObjects = builder.subObjects;
        this.representations = builder.representations;
    }

    /**
     * <p>
     * You can set this flag as true to instruct the engine not to push user-provided operations into the logical plan
     * of the view during query planning. However, setting this flag does not guarantee that the engine will comply.
     * Refer to the engine's documentation to understand the guarantees provided, if any.
     * </p>
     * 
     * @return You can set this flag as true to instruct the engine not to push user-provided operations into the
     *         logical plan of the view during query planning. However, setting this flag does not guarantee that the
     *         engine will comply. Refer to the engine's documentation to understand the guarantees provided, if any.
     */
    public final Boolean isProtected() {
        return isProtected;
    }

    /**
     * <p>
     * The definer of a view in SQL.
     * </p>
     * 
     * @return The definer of a view in SQL.
     */
    public final String definer() {
        return definer;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubObjects property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubObjects() {
        return subObjects != null && !(subObjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of table Amazon Resource Names (ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubObjects} method.
     * </p>
     * 
     * @return A list of table Amazon Resource Names (ARNs).
     */
    public final List<String> subObjects() {
        return subObjects;
    }

    /**
     * For responses, this returns true if the service returned a value for the Representations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepresentations() {
        return representations != null && !(representations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of representations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepresentations} method.
     * </p>
     * 
     * @return A list of representations.
     */
    public final List<ViewRepresentation> representations() {
        return representations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isProtected());
        hashCode = 31 * hashCode + Objects.hashCode(definer());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubObjects() ? subObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRepresentations() ? representations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewDefinition)) {
            return false;
        }
        ViewDefinition other = (ViewDefinition) obj;
        return Objects.equals(isProtected(), other.isProtected()) && Objects.equals(definer(), other.definer())
                && hasSubObjects() == other.hasSubObjects() && Objects.equals(subObjects(), other.subObjects())
                && hasRepresentations() == other.hasRepresentations()
                && Objects.equals(representations(), other.representations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewDefinition").add("IsProtected", isProtected()).add("Definer", definer())
                .add("SubObjects", hasSubObjects() ? subObjects() : null)
                .add("Representations", hasRepresentations() ? representations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsProtected":
            return Optional.ofNullable(clazz.cast(isProtected()));
        case "Definer":
            return Optional.ofNullable(clazz.cast(definer()));
        case "SubObjects":
            return Optional.ofNullable(clazz.cast(subObjects()));
        case "Representations":
            return Optional.ofNullable(clazz.cast(representations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IsProtected", IS_PROTECTED_FIELD);
        map.put("Definer", DEFINER_FIELD);
        map.put("SubObjects", SUB_OBJECTS_FIELD);
        map.put("Representations", REPRESENTATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewDefinition, T> g) {
        return obj -> g.apply((ViewDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewDefinition> {
        /**
         * <p>
         * You can set this flag as true to instruct the engine not to push user-provided operations into the logical
         * plan of the view during query planning. However, setting this flag does not guarantee that the engine will
         * comply. Refer to the engine's documentation to understand the guarantees provided, if any.
         * </p>
         * 
         * @param isProtected
         *        You can set this flag as true to instruct the engine not to push user-provided operations into the
         *        logical plan of the view during query planning. However, setting this flag does not guarantee that the
         *        engine will comply. Refer to the engine's documentation to understand the guarantees provided, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isProtected(Boolean isProtected);

        /**
         * <p>
         * The definer of a view in SQL.
         * </p>
         * 
         * @param definer
         *        The definer of a view in SQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definer(String definer);

        /**
         * <p>
         * A list of table Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param subObjects
         *        A list of table Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subObjects(Collection<String> subObjects);

        /**
         * <p>
         * A list of table Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param subObjects
         *        A list of table Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subObjects(String... subObjects);

        /**
         * <p>
         * A list of representations.
         * </p>
         * 
         * @param representations
         *        A list of representations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder representations(Collection<ViewRepresentation> representations);

        /**
         * <p>
         * A list of representations.
         * </p>
         * 
         * @param representations
         *        A list of representations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder representations(ViewRepresentation... representations);

        /**
         * <p>
         * A list of representations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.ViewRepresentation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.ViewRepresentation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.ViewRepresentation.Builder#build()} is called immediately
         * and its result is passed to {@link #representations(List<ViewRepresentation>)}.
         * 
         * @param representations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.ViewRepresentation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #representations(java.util.Collection<ViewRepresentation>)
         */
        Builder representations(Consumer<ViewRepresentation.Builder>... representations);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isProtected;

        private String definer;

        private List<String> subObjects = DefaultSdkAutoConstructList.getInstance();

        private List<ViewRepresentation> representations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ViewDefinition model) {
            isProtected(model.isProtected);
            definer(model.definer);
            subObjects(model.subObjects);
            representations(model.representations);
        }

        public final Boolean getIsProtected() {
            return isProtected;
        }

        public final void setIsProtected(Boolean isProtected) {
            this.isProtected = isProtected;
        }

        @Override
        public final Builder isProtected(Boolean isProtected) {
            this.isProtected = isProtected;
            return this;
        }

        public final String getDefiner() {
            return definer;
        }

        public final void setDefiner(String definer) {
            this.definer = definer;
        }

        @Override
        public final Builder definer(String definer) {
            this.definer = definer;
            return this;
        }

        public final Collection<String> getSubObjects() {
            if (subObjects instanceof SdkAutoConstructList) {
                return null;
            }
            return subObjects;
        }

        public final void setSubObjects(Collection<String> subObjects) {
            this.subObjects = ViewSubObjectsListCopier.copy(subObjects);
        }

        @Override
        public final Builder subObjects(Collection<String> subObjects) {
            this.subObjects = ViewSubObjectsListCopier.copy(subObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subObjects(String... subObjects) {
            subObjects(Arrays.asList(subObjects));
            return this;
        }

        public final List<ViewRepresentation.Builder> getRepresentations() {
            List<ViewRepresentation.Builder> result = ViewRepresentationListCopier.copyToBuilder(this.representations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepresentations(Collection<ViewRepresentation.BuilderImpl> representations) {
            this.representations = ViewRepresentationListCopier.copyFromBuilder(representations);
        }

        @Override
        public final Builder representations(Collection<ViewRepresentation> representations) {
            this.representations = ViewRepresentationListCopier.copy(representations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder representations(ViewRepresentation... representations) {
            representations(Arrays.asList(representations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder representations(Consumer<ViewRepresentation.Builder>... representations) {
            representations(Stream.of(representations).map(c -> ViewRepresentation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ViewDefinition build() {
            return new ViewDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
