/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlueprintRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetBlueprintRunRequest> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueprintName").getter(GetBlueprintRunRequest.getter(GetBlueprintRunRequest::blueprintName)).setter(GetBlueprintRunRequest.setter(Builder::blueprintName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintName").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(GetBlueprintRunRequest.getter(GetBlueprintRunRequest::runId)).setter(GetBlueprintRunRequest.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD, RUN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBlueprintRunRequest.memberNameToFieldInitializer();
    private final String blueprintName;
    private final String runId;

    private GetBlueprintRunRequest(BuilderImpl builder) {
        super(builder);
        this.blueprintName = builder.blueprintName;
        this.runId = builder.runId;
    }

    public final String blueprintName() {
        return this.blueprintName;
    }

    public final String runId() {
        return this.runId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintRunRequest)) {
            return false;
        }
        GetBlueprintRunRequest other = (GetBlueprintRunRequest)((Object)obj);
        return Objects.equals(this.blueprintName(), other.blueprintName()) && Objects.equals(this.runId(), other.runId());
    }

    public final String toString() {
        return ToString.builder((String)"GetBlueprintRunRequest").add("BlueprintName", (Object)this.blueprintName()).add("RunId", (Object)this.runId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlueprintName": {
                return Optional.ofNullable(clazz.cast(this.blueprintName()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BlueprintName", BLUEPRINT_NAME_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBlueprintRunRequest, T> g) {
        return obj -> g.apply((GetBlueprintRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String blueprintName;
        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintRunRequest model) {
            super(model);
            this.blueprintName(model.blueprintName);
            this.runId(model.runId);
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlueprintRunRequest build() {
            return new GetBlueprintRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlueprintRunRequest> {
        public Builder blueprintName(String var1);

        public Builder runId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

