/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.InclusionAnnotationValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatapointInclusionAnnotation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatapointInclusionAnnotation> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(DatapointInclusionAnnotation.getter(DatapointInclusionAnnotation::profileId)).setter(DatapointInclusionAnnotation.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> STATISTIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatisticId").getter(DatapointInclusionAnnotation.getter(DatapointInclusionAnnotation::statisticId)).setter(DatapointInclusionAnnotation.setter(Builder::statisticId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticId").build()}).build();
    private static final SdkField<String> INCLUSION_ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InclusionAnnotation").getter(DatapointInclusionAnnotation.getter(DatapointInclusionAnnotation::inclusionAnnotationAsString)).setter(DatapointInclusionAnnotation.setter(Builder::inclusionAnnotation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, STATISTIC_ID_FIELD, INCLUSION_ANNOTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatapointInclusionAnnotation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String profileId;
    private final String statisticId;
    private final String inclusionAnnotation;

    private DatapointInclusionAnnotation(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.statisticId = builder.statisticId;
        this.inclusionAnnotation = builder.inclusionAnnotation;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String statisticId() {
        return this.statisticId;
    }

    public final InclusionAnnotationValue inclusionAnnotation() {
        return InclusionAnnotationValue.fromValue(this.inclusionAnnotation);
    }

    public final String inclusionAnnotationAsString() {
        return this.inclusionAnnotation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionAnnotationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatapointInclusionAnnotation)) {
            return false;
        }
        DatapointInclusionAnnotation other = (DatapointInclusionAnnotation)obj;
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.statisticId(), other.statisticId()) && Objects.equals(this.inclusionAnnotationAsString(), other.inclusionAnnotationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DatapointInclusionAnnotation").add("ProfileId", (Object)this.profileId()).add("StatisticId", (Object)this.statisticId()).add("InclusionAnnotation", (Object)this.inclusionAnnotationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "StatisticId": {
                return Optional.ofNullable(clazz.cast(this.statisticId()));
            }
            case "InclusionAnnotation": {
                return Optional.ofNullable(clazz.cast(this.inclusionAnnotationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("StatisticId", STATISTIC_ID_FIELD);
        map.put("InclusionAnnotation", INCLUSION_ANNOTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatapointInclusionAnnotation, T> g) {
        return obj -> g.apply((DatapointInclusionAnnotation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileId;
        private String statisticId;
        private String inclusionAnnotation;

        private BuilderImpl() {
        }

        private BuilderImpl(DatapointInclusionAnnotation model) {
            this.profileId(model.profileId);
            this.statisticId(model.statisticId);
            this.inclusionAnnotation(model.inclusionAnnotation);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getStatisticId() {
            return this.statisticId;
        }

        public final void setStatisticId(String statisticId) {
            this.statisticId = statisticId;
        }

        @Override
        public final Builder statisticId(String statisticId) {
            this.statisticId = statisticId;
            return this;
        }

        public final String getInclusionAnnotation() {
            return this.inclusionAnnotation;
        }

        public final void setInclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
        }

        @Override
        public final Builder inclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
            return this;
        }

        @Override
        public final Builder inclusionAnnotation(InclusionAnnotationValue inclusionAnnotation) {
            this.inclusionAnnotation(inclusionAnnotation == null ? null : inclusionAnnotation.toString());
            return this;
        }

        public DatapointInclusionAnnotation build() {
            return new DatapointInclusionAnnotation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatapointInclusionAnnotation> {
        public Builder profileId(String var1);

        public Builder statisticId(String var1);

        public Builder inclusionAnnotation(String var1);

        public Builder inclusionAnnotation(InclusionAnnotationValue var1);
    }
}

