/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CrawlerHistoryState {
    RUNNING("RUNNING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CrawlerHistoryState> VALUE_MAP;
    private final String value;

    private CrawlerHistoryState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CrawlerHistoryState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CrawlerHistoryState> knownValues() {
        EnumSet<CrawlerHistoryState> knownValues = EnumSet.allOf(CrawlerHistoryState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CrawlerHistoryState.class, CrawlerHistoryState::toString);
    }
}

