/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data quality metric value according to the analysis of historical data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityMetricValues implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityMetricValues.Builder, DataQualityMetricValues> {
    private static final SdkField<Double> ACTUAL_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ActualValue").getter(getter(DataQualityMetricValues::actualValue)).setter(setter(Builder::actualValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()).build();

    private static final SdkField<Double> EXPECTED_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ExpectedValue").getter(getter(DataQualityMetricValues::expectedValue))
            .setter(setter(Builder::expectedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedValue").build()).build();

    private static final SdkField<Double> LOWER_LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LowerLimit").getter(getter(DataQualityMetricValues::lowerLimit)).setter(setter(Builder::lowerLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerLimit").build()).build();

    private static final SdkField<Double> UPPER_LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UpperLimit").getter(getter(DataQualityMetricValues::upperLimit)).setter(setter(Builder::upperLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_VALUE_FIELD,
            EXPECTED_VALUE_FIELD, LOWER_LIMIT_FIELD, UPPER_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double actualValue;

    private final Double expectedValue;

    private final Double lowerLimit;

    private final Double upperLimit;

    private DataQualityMetricValues(BuilderImpl builder) {
        this.actualValue = builder.actualValue;
        this.expectedValue = builder.expectedValue;
        this.lowerLimit = builder.lowerLimit;
        this.upperLimit = builder.upperLimit;
    }

    /**
     * <p>
     * The actual value of the data quality metric.
     * </p>
     * 
     * @return The actual value of the data quality metric.
     */
    public final Double actualValue() {
        return actualValue;
    }

    /**
     * <p>
     * The expected value of the data quality metric according to the analysis of historical data.
     * </p>
     * 
     * @return The expected value of the data quality metric according to the analysis of historical data.
     */
    public final Double expectedValue() {
        return expectedValue;
    }

    /**
     * <p>
     * The lower limit of the data quality metric value according to the analysis of historical data.
     * </p>
     * 
     * @return The lower limit of the data quality metric value according to the analysis of historical data.
     */
    public final Double lowerLimit() {
        return lowerLimit;
    }

    /**
     * <p>
     * The upper limit of the data quality metric value according to the analysis of historical data.
     * </p>
     * 
     * @return The upper limit of the data quality metric value according to the analysis of historical data.
     */
    public final Double upperLimit() {
        return upperLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(expectedValue());
        hashCode = 31 * hashCode + Objects.hashCode(lowerLimit());
        hashCode = 31 * hashCode + Objects.hashCode(upperLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityMetricValues)) {
            return false;
        }
        DataQualityMetricValues other = (DataQualityMetricValues) obj;
        return Objects.equals(actualValue(), other.actualValue()) && Objects.equals(expectedValue(), other.expectedValue())
                && Objects.equals(lowerLimit(), other.lowerLimit()) && Objects.equals(upperLimit(), other.upperLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityMetricValues").add("ActualValue", actualValue())
                .add("ExpectedValue", expectedValue()).add("LowerLimit", lowerLimit()).add("UpperLimit", upperLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActualValue":
            return Optional.ofNullable(clazz.cast(actualValue()));
        case "ExpectedValue":
            return Optional.ofNullable(clazz.cast(expectedValue()));
        case "LowerLimit":
            return Optional.ofNullable(clazz.cast(lowerLimit()));
        case "UpperLimit":
            return Optional.ofNullable(clazz.cast(upperLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActualValue", ACTUAL_VALUE_FIELD);
        map.put("ExpectedValue", EXPECTED_VALUE_FIELD);
        map.put("LowerLimit", LOWER_LIMIT_FIELD);
        map.put("UpperLimit", UPPER_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityMetricValues, T> g) {
        return obj -> g.apply((DataQualityMetricValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityMetricValues> {
        /**
         * <p>
         * The actual value of the data quality metric.
         * </p>
         * 
         * @param actualValue
         *        The actual value of the data quality metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualValue(Double actualValue);

        /**
         * <p>
         * The expected value of the data quality metric according to the analysis of historical data.
         * </p>
         * 
         * @param expectedValue
         *        The expected value of the data quality metric according to the analysis of historical data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedValue(Double expectedValue);

        /**
         * <p>
         * The lower limit of the data quality metric value according to the analysis of historical data.
         * </p>
         * 
         * @param lowerLimit
         *        The lower limit of the data quality metric value according to the analysis of historical data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerLimit(Double lowerLimit);

        /**
         * <p>
         * The upper limit of the data quality metric value according to the analysis of historical data.
         * </p>
         * 
         * @param upperLimit
         *        The upper limit of the data quality metric value according to the analysis of historical data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperLimit(Double upperLimit);
    }

    static final class BuilderImpl implements Builder {
        private Double actualValue;

        private Double expectedValue;

        private Double lowerLimit;

        private Double upperLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityMetricValues model) {
            actualValue(model.actualValue);
            expectedValue(model.expectedValue);
            lowerLimit(model.lowerLimit);
            upperLimit(model.upperLimit);
        }

        public final Double getActualValue() {
            return actualValue;
        }

        public final void setActualValue(Double actualValue) {
            this.actualValue = actualValue;
        }

        @Override
        public final Builder actualValue(Double actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final Double getExpectedValue() {
            return expectedValue;
        }

        public final void setExpectedValue(Double expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public final Builder expectedValue(Double expectedValue) {
            this.expectedValue = expectedValue;
            return this;
        }

        public final Double getLowerLimit() {
            return lowerLimit;
        }

        public final void setLowerLimit(Double lowerLimit) {
            this.lowerLimit = lowerLimit;
        }

        @Override
        public final Builder lowerLimit(Double lowerLimit) {
            this.lowerLimit = lowerLimit;
            return this;
        }

        public final Double getUpperLimit() {
            return upperLimit;
        }

        public final void setUpperLimit(Double upperLimit) {
            this.upperLimit = upperLimit;
        }

        @Override
        public final Builder upperLimit(Double upperLimit) {
            this.upperLimit = upperLimit;
            return this;
        }

        @Override
        public DataQualityMetricValues build() {
            return new DataQualityMetricValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
