/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataCatalogEncryptionSettingsResponse extends GlueResponse implements
        ToCopyableBuilder<GetDataCatalogEncryptionSettingsResponse.Builder, GetDataCatalogEncryptionSettingsResponse> {
    private static final SdkField<DataCatalogEncryptionSettings> DATA_CATALOG_ENCRYPTION_SETTINGS_FIELD = SdkField
            .<DataCatalogEncryptionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("DataCatalogEncryptionSettings")
            .getter(getter(GetDataCatalogEncryptionSettingsResponse::dataCatalogEncryptionSettings))
            .setter(setter(Builder::dataCatalogEncryptionSettings))
            .constructor(DataCatalogEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogEncryptionSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DATA_CATALOG_ENCRYPTION_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataCatalogEncryptionSettings dataCatalogEncryptionSettings;

    private GetDataCatalogEncryptionSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.dataCatalogEncryptionSettings = builder.dataCatalogEncryptionSettings;
    }

    /**
     * <p>
     * The requested security configuration.
     * </p>
     * 
     * @return The requested security configuration.
     */
    public final DataCatalogEncryptionSettings dataCatalogEncryptionSettings() {
        return dataCatalogEncryptionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataCatalogEncryptionSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataCatalogEncryptionSettingsResponse)) {
            return false;
        }
        GetDataCatalogEncryptionSettingsResponse other = (GetDataCatalogEncryptionSettingsResponse) obj;
        return Objects.equals(dataCatalogEncryptionSettings(), other.dataCatalogEncryptionSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataCatalogEncryptionSettingsResponse")
                .add("DataCatalogEncryptionSettings", dataCatalogEncryptionSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataCatalogEncryptionSettings":
            return Optional.ofNullable(clazz.cast(dataCatalogEncryptionSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataCatalogEncryptionSettings", DATA_CATALOG_ENCRYPTION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataCatalogEncryptionSettingsResponse, T> g) {
        return obj -> g.apply((GetDataCatalogEncryptionSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataCatalogEncryptionSettingsResponse> {
        /**
         * <p>
         * The requested security configuration.
         * </p>
         * 
         * @param dataCatalogEncryptionSettings
         *        The requested security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCatalogEncryptionSettings(DataCatalogEncryptionSettings dataCatalogEncryptionSettings);

        /**
         * <p>
         * The requested security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataCatalogEncryptionSettings.Builder}
         * avoiding the need to create one manually via {@link DataCatalogEncryptionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataCatalogEncryptionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #dataCatalogEncryptionSettings(DataCatalogEncryptionSettings)}.
         * 
         * @param dataCatalogEncryptionSettings
         *        a consumer that will call methods on {@link DataCatalogEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCatalogEncryptionSettings(DataCatalogEncryptionSettings)
         */
        default Builder dataCatalogEncryptionSettings(
                Consumer<DataCatalogEncryptionSettings.Builder> dataCatalogEncryptionSettings) {
            return dataCatalogEncryptionSettings(DataCatalogEncryptionSettings.builder()
                    .applyMutation(dataCatalogEncryptionSettings).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private DataCatalogEncryptionSettings dataCatalogEncryptionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataCatalogEncryptionSettingsResponse model) {
            super(model);
            dataCatalogEncryptionSettings(model.dataCatalogEncryptionSettings);
        }

        public final DataCatalogEncryptionSettings.Builder getDataCatalogEncryptionSettings() {
            return dataCatalogEncryptionSettings != null ? dataCatalogEncryptionSettings.toBuilder() : null;
        }

        public final void setDataCatalogEncryptionSettings(DataCatalogEncryptionSettings.BuilderImpl dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings != null ? dataCatalogEncryptionSettings.build()
                    : null;
        }

        @Override
        public final Builder dataCatalogEncryptionSettings(DataCatalogEncryptionSettings dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings;
            return this;
        }

        @Override
        public GetDataCatalogEncryptionSettingsResponse build() {
            return new GetDataCatalogEncryptionSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
