/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcePolicyResponse extends GlueResponse implements
        ToCopyableBuilder<GetResourcePolicyResponse.Builder, GetResourcePolicyResponse> {
    private static final SdkField<String> POLICY_IN_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyInJson").getter(getter(GetResourcePolicyResponse::policyInJson))
            .setter(setter(Builder::policyInJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInJson").build()).build();

    private static final SdkField<String> POLICY_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyHash").getter(getter(GetResourcePolicyResponse::policyHash)).setter(setter(Builder::policyHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyHash").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(GetResourcePolicyResponse::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime").getter(getter(GetResourcePolicyResponse::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_IN_JSON_FIELD,
            POLICY_HASH_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyInJson;

    private final String policyHash;

    private final Instant createTime;

    private final Instant updateTime;

    private GetResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyInJson = builder.policyInJson;
        this.policyHash = builder.policyHash;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * Contains the requested policy document, in JSON format.
     * </p>
     * 
     * @return Contains the requested policy document, in JSON format.
     */
    public final String policyInJson() {
        return policyInJson;
    }

    /**
     * <p>
     * Contains the hash value associated with this policy.
     * </p>
     * 
     * @return Contains the hash value associated with this policy.
     */
    public final String policyHash() {
        return policyHash;
    }

    /**
     * <p>
     * The date and time at which the policy was created.
     * </p>
     * 
     * @return The date and time at which the policy was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The date and time at which the policy was last updated.
     * </p>
     * 
     * @return The date and time at which the policy was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyInJson());
        hashCode = 31 * hashCode + Objects.hashCode(policyHash());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePolicyResponse)) {
            return false;
        }
        GetResourcePolicyResponse other = (GetResourcePolicyResponse) obj;
        return Objects.equals(policyInJson(), other.policyInJson()) && Objects.equals(policyHash(), other.policyHash())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcePolicyResponse").add("PolicyInJson", policyInJson()).add("PolicyHash", policyHash())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyInJson":
            return Optional.ofNullable(clazz.cast(policyInJson()));
        case "PolicyHash":
            return Optional.ofNullable(clazz.cast(policyHash()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyInJson", POLICY_IN_JSON_FIELD);
        map.put("PolicyHash", POLICY_HASH_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePolicyResponse, T> g) {
        return obj -> g.apply((GetResourcePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourcePolicyResponse> {
        /**
         * <p>
         * Contains the requested policy document, in JSON format.
         * </p>
         * 
         * @param policyInJson
         *        Contains the requested policy document, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyInJson(String policyInJson);

        /**
         * <p>
         * Contains the hash value associated with this policy.
         * </p>
         * 
         * @param policyHash
         *        Contains the hash value associated with this policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyHash(String policyHash);

        /**
         * <p>
         * The date and time at which the policy was created.
         * </p>
         * 
         * @param createTime
         *        The date and time at which the policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The date and time at which the policy was last updated.
         * </p>
         * 
         * @param updateTime
         *        The date and time at which the policy was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String policyInJson;

        private String policyHash;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePolicyResponse model) {
            super(model);
            policyInJson(model.policyInJson);
            policyHash(model.policyHash);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getPolicyInJson() {
            return policyInJson;
        }

        public final void setPolicyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
        }

        @Override
        public final Builder policyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
            return this;
        }

        public final String getPolicyHash() {
            return policyHash;
        }

        public final void setPolicyHash(String policyHash) {
            this.policyHash = policyHash;
        }

        @Override
        public final Builder policyHash(String policyHash) {
            this.policyHash = policyHash;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetResourcePolicyResponse build() {
            return new GetResourcePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
