/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Apache Hudi data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HudiTarget implements SdkPojo, Serializable, ToCopyableBuilder<HudiTarget.Builder, HudiTarget> {
    private static final SdkField<List<String>> PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Paths")
            .getter(getter(HudiTarget::paths))
            .setter(setter(Builder::paths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Paths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(HudiTarget::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<List<String>> EXCLUSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Exclusions")
            .getter(getter(HudiTarget::exclusions))
            .setter(setter(Builder::exclusions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAXIMUM_TRAVERSAL_DEPTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumTraversalDepth").getter(getter(HudiTarget::maximumTraversalDepth))
            .setter(setter(Builder::maximumTraversalDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumTraversalDepth").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATHS_FIELD,
            CONNECTION_NAME_FIELD, EXCLUSIONS_FIELD, MAXIMUM_TRAVERSAL_DEPTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> paths;

    private final String connectionName;

    private final List<String> exclusions;

    private final Integer maximumTraversalDepth;

    private HudiTarget(BuilderImpl builder) {
        this.paths = builder.paths;
        this.connectionName = builder.connectionName;
        this.exclusions = builder.exclusions;
        this.maximumTraversalDepth = builder.maximumTraversalDepth;
    }

    /**
     * For responses, this returns true if the service returned a value for the Paths property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPaths() {
        return paths != null && !(paths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon S3 location strings for Hudi, each indicating the root folder with which the metadata files
     * for a Hudi table resides. The Hudi folder may be located in a child folder of the root folder.
     * </p>
     * <p>
     * The crawler will scan all folders underneath a path for a Hudi folder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPaths} method.
     * </p>
     * 
     * @return An array of Amazon S3 location strings for Hudi, each indicating the root folder with which the metadata
     *         files for a Hudi table resides. The Hudi folder may be located in a child folder of the root folder.</p>
     *         <p>
     *         The crawler will scan all folders underneath a path for a Hudi folder.
     */
    public final List<String> paths() {
        return paths;
    }

    /**
     * <p>
     * The name of the connection to use to connect to the Hudi target. If your Hudi files are stored in buckets that
     * require VPC authorization, you can set their connection properties here.
     * </p>
     * 
     * @return The name of the connection to use to connect to the Hudi target. If your Hudi files are stored in buckets
     *         that require VPC authorization, you can set their connection properties here.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Exclusions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExclusions() {
        return exclusions != null && !(exclusions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of glob patterns used to exclude from the crawl. For more information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusions} method.
     * </p>
     * 
     * @return A list of glob patterns used to exclude from the crawl. For more information, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
     */
    public final List<String> exclusions() {
        return exclusions;
    }

    /**
     * <p>
     * The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata folder in your
     * Amazon S3 path. Used to limit the crawler run time.
     * </p>
     * 
     * @return The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata folder
     *         in your Amazon S3 path. Used to limit the crawler run time.
     */
    public final Integer maximumTraversalDepth() {
        return maximumTraversalDepth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPaths() ? paths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusions() ? exclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maximumTraversalDepth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HudiTarget)) {
            return false;
        }
        HudiTarget other = (HudiTarget) obj;
        return hasPaths() == other.hasPaths() && Objects.equals(paths(), other.paths())
                && Objects.equals(connectionName(), other.connectionName()) && hasExclusions() == other.hasExclusions()
                && Objects.equals(exclusions(), other.exclusions())
                && Objects.equals(maximumTraversalDepth(), other.maximumTraversalDepth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HudiTarget").add("Paths", hasPaths() ? paths() : null).add("ConnectionName", connectionName())
                .add("Exclusions", hasExclusions() ? exclusions() : null).add("MaximumTraversalDepth", maximumTraversalDepth())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Paths":
            return Optional.ofNullable(clazz.cast(paths()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "Exclusions":
            return Optional.ofNullable(clazz.cast(exclusions()));
        case "MaximumTraversalDepth":
            return Optional.ofNullable(clazz.cast(maximumTraversalDepth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Paths", PATHS_FIELD);
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("Exclusions", EXCLUSIONS_FIELD);
        map.put("MaximumTraversalDepth", MAXIMUM_TRAVERSAL_DEPTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HudiTarget, T> g) {
        return obj -> g.apply((HudiTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HudiTarget> {
        /**
         * <p>
         * An array of Amazon S3 location strings for Hudi, each indicating the root folder with which the metadata
         * files for a Hudi table resides. The Hudi folder may be located in a child folder of the root folder.
         * </p>
         * <p>
         * The crawler will scan all folders underneath a path for a Hudi folder.
         * </p>
         * 
         * @param paths
         *        An array of Amazon S3 location strings for Hudi, each indicating the root folder with which the
         *        metadata files for a Hudi table resides. The Hudi folder may be located in a child folder of the root
         *        folder.</p>
         *        <p>
         *        The crawler will scan all folders underneath a path for a Hudi folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paths(Collection<String> paths);

        /**
         * <p>
         * An array of Amazon S3 location strings for Hudi, each indicating the root folder with which the metadata
         * files for a Hudi table resides. The Hudi folder may be located in a child folder of the root folder.
         * </p>
         * <p>
         * The crawler will scan all folders underneath a path for a Hudi folder.
         * </p>
         * 
         * @param paths
         *        An array of Amazon S3 location strings for Hudi, each indicating the root folder with which the
         *        metadata files for a Hudi table resides. The Hudi folder may be located in a child folder of the root
         *        folder.</p>
         *        <p>
         *        The crawler will scan all folders underneath a path for a Hudi folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paths(String... paths);

        /**
         * <p>
         * The name of the connection to use to connect to the Hudi target. If your Hudi files are stored in buckets
         * that require VPC authorization, you can set their connection properties here.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection to use to connect to the Hudi target. If your Hudi files are stored in
         *        buckets that require VPC authorization, you can set their connection properties here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * A list of glob patterns used to exclude from the crawl. For more information, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
         * </p>
         * 
         * @param exclusions
         *        A list of glob patterns used to exclude from the crawl. For more information, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusions(Collection<String> exclusions);

        /**
         * <p>
         * A list of glob patterns used to exclude from the crawl. For more information, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
         * </p>
         * 
         * @param exclusions
         *        A list of glob patterns used to exclude from the crawl. For more information, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusions(String... exclusions);

        /**
         * <p>
         * The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata folder in
         * your Amazon S3 path. Used to limit the crawler run time.
         * </p>
         * 
         * @param maximumTraversalDepth
         *        The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata
         *        folder in your Amazon S3 path. Used to limit the crawler run time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumTraversalDepth(Integer maximumTraversalDepth);
    }

    static final class BuilderImpl implements Builder {
        private List<String> paths = DefaultSdkAutoConstructList.getInstance();

        private String connectionName;

        private List<String> exclusions = DefaultSdkAutoConstructList.getInstance();

        private Integer maximumTraversalDepth;

        private BuilderImpl() {
        }

        private BuilderImpl(HudiTarget model) {
            paths(model.paths);
            connectionName(model.connectionName);
            exclusions(model.exclusions);
            maximumTraversalDepth(model.maximumTraversalDepth);
        }

        public final Collection<String> getPaths() {
            if (paths instanceof SdkAutoConstructList) {
                return null;
            }
            return paths;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = PathListCopier.copy(paths);
        }

        @Override
        public final Builder paths(Collection<String> paths) {
            this.paths = PathListCopier.copy(paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paths(String... paths) {
            paths(Arrays.asList(paths));
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Collection<String> getExclusions() {
            if (exclusions instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusions;
        }

        public final void setExclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
        }

        @Override
        public final Builder exclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusions(String... exclusions) {
            exclusions(Arrays.asList(exclusions));
            return this;
        }

        public final Integer getMaximumTraversalDepth() {
            return maximumTraversalDepth;
        }

        public final void setMaximumTraversalDepth(Integer maximumTraversalDepth) {
            this.maximumTraversalDepth = maximumTraversalDepth;
        }

        @Override
        public final Builder maximumTraversalDepth(Integer maximumTraversalDepth) {
            this.maximumTraversalDepth = maximumTraversalDepth;
            return this;
        }

        @Override
        public HudiTarget build() {
            return new HudiTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
