/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JDBCDataType {
    ARRAY("ARRAY"),
    BIGINT("BIGINT"),
    BINARY("BINARY"),
    BIT("BIT"),
    BLOB("BLOB"),
    BOOLEAN("BOOLEAN"),
    CHAR("CHAR"),
    CLOB("CLOB"),
    DATALINK("DATALINK"),
    DATE("DATE"),
    DECIMAL("DECIMAL"),
    DISTINCT("DISTINCT"),
    DOUBLE("DOUBLE"),
    FLOAT("FLOAT"),
    INTEGER("INTEGER"),
    JAVA_OBJECT("JAVA_OBJECT"),
    LONGNVARCHAR("LONGNVARCHAR"),
    LONGVARBINARY("LONGVARBINARY"),
    LONGVARCHAR("LONGVARCHAR"),
    NCHAR("NCHAR"),
    NCLOB("NCLOB"),
    NULL("NULL"),
    NUMERIC("NUMERIC"),
    NVARCHAR("NVARCHAR"),
    OTHER("OTHER"),
    REAL("REAL"),
    REF("REF"),
    REF_CURSOR("REF_CURSOR"),
    ROWID("ROWID"),
    SMALLINT("SMALLINT"),
    SQLXML("SQLXML"),
    STRUCT("STRUCT"),
    TIME("TIME"),
    TIME_WITH_TIMEZONE("TIME_WITH_TIMEZONE"),
    TIMESTAMP("TIMESTAMP"),
    TIMESTAMP_WITH_TIMEZONE("TIMESTAMP_WITH_TIMEZONE"),
    TINYINT("TINYINT"),
    VARBINARY("VARBINARY"),
    VARCHAR("VARCHAR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JDBCDataType> VALUE_MAP;
    private final String value;

    private JDBCDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JDBCDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JDBCDataType> knownValues() {
        EnumSet<JDBCDataType> knownValues = EnumSet.allOf(JDBCDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JDBCDataType.class, JDBCDataType::toString);
    }
}

