/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetProcessingProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetProcessingProperties> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(TargetProcessingProperties.getter(TargetProcessingProperties::roleArn)).setter(TargetProcessingProperties.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsArn").getter(TargetProcessingProperties.getter(TargetProcessingProperties::kmsArn)).setter(TargetProcessingProperties.setter(Builder::kmsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsArn").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(TargetProcessingProperties.getter(TargetProcessingProperties::connectionName)).setter(TargetProcessingProperties.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> EVENT_BUS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBusArn").getter(TargetProcessingProperties.getter(TargetProcessingProperties::eventBusArn)).setter(TargetProcessingProperties.setter(Builder::eventBusArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, KMS_ARN_FIELD, CONNECTION_NAME_FIELD, EVENT_BUS_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetProcessingProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String kmsArn;
    private final String connectionName;
    private final String eventBusArn;

    private TargetProcessingProperties(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.kmsArn = builder.kmsArn;
        this.connectionName = builder.connectionName;
        this.eventBusArn = builder.eventBusArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String kmsArn() {
        return this.kmsArn;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String eventBusArn() {
        return this.eventBusArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBusArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetProcessingProperties)) {
            return false;
        }
        TargetProcessingProperties other = (TargetProcessingProperties)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.kmsArn(), other.kmsArn()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.eventBusArn(), other.eventBusArn());
    }

    public final String toString() {
        return ToString.builder((String)"TargetProcessingProperties").add("RoleArn", (Object)this.roleArn()).add("KmsArn", (Object)this.kmsArn()).add("ConnectionName", (Object)this.connectionName()).add("EventBusArn", (Object)this.eventBusArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "KmsArn": {
                return Optional.ofNullable(clazz.cast(this.kmsArn()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "EventBusArn": {
                return Optional.ofNullable(clazz.cast(this.eventBusArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("KmsArn", KMS_ARN_FIELD);
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("EventBusArn", EVENT_BUS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetProcessingProperties, T> g) {
        return obj -> g.apply((TargetProcessingProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String kmsArn;
        private String connectionName;
        private String eventBusArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetProcessingProperties model) {
            this.roleArn(model.roleArn);
            this.kmsArn(model.kmsArn);
            this.connectionName(model.connectionName);
            this.eventBusArn(model.eventBusArn);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKmsArn() {
            return this.kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getEventBusArn() {
            return this.eventBusArn;
        }

        public final void setEventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
        }

        @Override
        public final Builder eventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
            return this;
        }

        public TargetProcessingProperties build() {
            return new TargetProcessingProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetProcessingProperties> {
        public Builder roleArn(String var1);

        public Builder kmsArn(String var1);

        public Builder connectionName(String var1);

        public Builder eventBusArn(String var1);
    }
}

