/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the result of the evaluation of a data quality analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityAnalyzerResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityAnalyzerResult.Builder, DataQualityAnalyzerResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataQualityAnalyzerResult::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DataQualityAnalyzerResult::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> EVALUATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationMessage").getter(getter(DataQualityAnalyzerResult::evaluationMessage))
            .setter(setter(Builder::evaluationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMessage").build()).build();

    private static final SdkField<Map<String, Double>> EVALUATED_METRICS_FIELD = SdkField
            .<Map<String, Double>> builder(MarshallingType.MAP)
            .memberName("EvaluatedMetrics")
            .getter(getter(DataQualityAnalyzerResult::evaluatedMetrics))
            .setter(setter(Builder::evaluatedMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedMetrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            EVALUATION_MESSAGE_FIELD, EVALUATED_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String evaluationMessage;

    private final Map<String, Double> evaluatedMetrics;

    private DataQualityAnalyzerResult(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.evaluationMessage = builder.evaluationMessage;
        this.evaluatedMetrics = builder.evaluatedMetrics;
    }

    /**
     * <p>
     * The name of the data quality analyzer.
     * </p>
     * 
     * @return The name of the data quality analyzer.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the data quality analyzer.
     * </p>
     * 
     * @return A description of the data quality analyzer.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An evaluation message.
     * </p>
     * 
     * @return An evaluation message.
     */
    public final String evaluationMessage() {
        return evaluationMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluatedMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvaluatedMetrics() {
        return evaluatedMetrics != null && !(evaluatedMetrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of metrics associated with the evaluation of the analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluatedMetrics} method.
     * </p>
     * 
     * @return A map of metrics associated with the evaluation of the analyzer.
     */
    public final Map<String, Double> evaluatedMetrics() {
        return evaluatedMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluatedMetrics() ? evaluatedMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityAnalyzerResult)) {
            return false;
        }
        DataQualityAnalyzerResult other = (DataQualityAnalyzerResult) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(evaluationMessage(), other.evaluationMessage())
                && hasEvaluatedMetrics() == other.hasEvaluatedMetrics()
                && Objects.equals(evaluatedMetrics(), other.evaluatedMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityAnalyzerResult").add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EvaluationMessage", evaluationMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EvaluatedMetrics", evaluatedMetrics() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EvaluationMessage":
            return Optional.ofNullable(clazz.cast(evaluationMessage()));
        case "EvaluatedMetrics":
            return Optional.ofNullable(clazz.cast(evaluatedMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EvaluationMessage", EVALUATION_MESSAGE_FIELD);
        map.put("EvaluatedMetrics", EVALUATED_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityAnalyzerResult, T> g) {
        return obj -> g.apply((DataQualityAnalyzerResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityAnalyzerResult> {
        /**
         * <p>
         * The name of the data quality analyzer.
         * </p>
         * 
         * @param name
         *        The name of the data quality analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the data quality analyzer.
         * </p>
         * 
         * @param description
         *        A description of the data quality analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An evaluation message.
         * </p>
         * 
         * @param evaluationMessage
         *        An evaluation message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationMessage(String evaluationMessage);

        /**
         * <p>
         * A map of metrics associated with the evaluation of the analyzer.
         * </p>
         * 
         * @param evaluatedMetrics
         *        A map of metrics associated with the evaluation of the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatedMetrics(Map<String, Double> evaluatedMetrics);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String evaluationMessage;

        private Map<String, Double> evaluatedMetrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityAnalyzerResult model) {
            name(model.name);
            description(model.description);
            evaluationMessage(model.evaluationMessage);
            evaluatedMetrics(model.evaluatedMetrics);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEvaluationMessage() {
            return evaluationMessage;
        }

        public final void setEvaluationMessage(String evaluationMessage) {
            this.evaluationMessage = evaluationMessage;
        }

        @Override
        public final Builder evaluationMessage(String evaluationMessage) {
            this.evaluationMessage = evaluationMessage;
            return this;
        }

        public final Map<String, Double> getEvaluatedMetrics() {
            if (evaluatedMetrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return evaluatedMetrics;
        }

        public final void setEvaluatedMetrics(Map<String, Double> evaluatedMetrics) {
            this.evaluatedMetrics = EvaluatedMetricsMapCopier.copy(evaluatedMetrics);
        }

        @Override
        public final Builder evaluatedMetrics(Map<String, Double> evaluatedMetrics) {
            this.evaluatedMetrics = EvaluatedMetricsMapCopier.copy(evaluatedMetrics);
            return this;
        }

        @Override
        public DataQualityAnalyzerResult build() {
            return new DataQualityAnalyzerResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
