/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableOptimizerResponse extends GlueResponse implements
        ToCopyableBuilder<GetTableOptimizerResponse.Builder, GetTableOptimizerResponse> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetTableOptimizerResponse::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(GetTableOptimizerResponse::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(GetTableOptimizerResponse::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<TableOptimizer> TABLE_OPTIMIZER_FIELD = SdkField
            .<TableOptimizer> builder(MarshallingType.SDK_POJO).memberName("TableOptimizer")
            .getter(getter(GetTableOptimizerResponse::tableOptimizer)).setter(setter(Builder::tableOptimizer))
            .constructor(TableOptimizer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableOptimizer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TABLE_OPTIMIZER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final TableOptimizer tableOptimizer;

    private GetTableOptimizerResponse(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.tableOptimizer = builder.tableOptimizer;
    }

    /**
     * <p>
     * The Catalog ID of the table.
     * </p>
     * 
     * @return The Catalog ID of the table.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the database in the catalog in which the table resides.
     * </p>
     * 
     * @return The name of the database in the catalog in which the table resides.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The optimizer associated with the specified table.
     * </p>
     * 
     * @return The optimizer associated with the specified table.
     */
    public final TableOptimizer tableOptimizer() {
        return tableOptimizer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(tableOptimizer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableOptimizerResponse)) {
            return false;
        }
        GetTableOptimizerResponse other = (GetTableOptimizerResponse) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(tableOptimizer(), other.tableOptimizer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableOptimizerResponse").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("TableOptimizer", tableOptimizer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TableOptimizer":
            return Optional.ofNullable(clazz.cast(tableOptimizer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("TableOptimizer", TABLE_OPTIMIZER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableOptimizerResponse, T> g) {
        return obj -> g.apply((GetTableOptimizerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTableOptimizerResponse> {
        /**
         * <p>
         * The Catalog ID of the table.
         * </p>
         * 
         * @param catalogId
         *        The Catalog ID of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the database in the catalog in which the table resides.
         * </p>
         * 
         * @param databaseName
         *        The name of the database in the catalog in which the table resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The optimizer associated with the specified table.
         * </p>
         * 
         * @param tableOptimizer
         *        The optimizer associated with the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableOptimizer(TableOptimizer tableOptimizer);

        /**
         * <p>
         * The optimizer associated with the specified table.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableOptimizer.Builder} avoiding the need
         * to create one manually via {@link TableOptimizer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableOptimizer.Builder#build()} is called immediately and its
         * result is passed to {@link #tableOptimizer(TableOptimizer)}.
         * 
         * @param tableOptimizer
         *        a consumer that will call methods on {@link TableOptimizer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableOptimizer(TableOptimizer)
         */
        default Builder tableOptimizer(Consumer<TableOptimizer.Builder> tableOptimizer) {
            return tableOptimizer(TableOptimizer.builder().applyMutation(tableOptimizer).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private TableOptimizer tableOptimizer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableOptimizerResponse model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            tableOptimizer(model.tableOptimizer);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final TableOptimizer.Builder getTableOptimizer() {
            return tableOptimizer != null ? tableOptimizer.toBuilder() : null;
        }

        public final void setTableOptimizer(TableOptimizer.BuilderImpl tableOptimizer) {
            this.tableOptimizer = tableOptimizer != null ? tableOptimizer.build() : null;
        }

        @Override
        public final Builder tableOptimizer(TableOptimizer tableOptimizer) {
            this.tableOptimizer = tableOptimizer;
            return this;
        }

        @Override
        public GetTableOptimizerResponse build() {
            return new GetTableOptimizerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
