/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for a column statistics task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnStatisticsTaskSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnStatisticsTaskSettings.Builder, ColumnStatisticsTaskSettings> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(ColumnStatisticsTaskSettings::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(ColumnStatisticsTaskSettings::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("Schedule").getter(getter(ColumnStatisticsTaskSettings::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<List<String>> COLUMN_NAME_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ColumnNameList")
            .getter(getter(ColumnStatisticsTaskSettings::columnNameList))
            .setter(setter(Builder::columnNameList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNameList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogID").getter(getter(ColumnStatisticsTaskSettings::catalogID)).setter(setter(Builder::catalogID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogID").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(ColumnStatisticsTaskSettings::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<Double> SAMPLE_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SampleSize").getter(getter(ColumnStatisticsTaskSettings::sampleSize))
            .setter(setter(Builder::sampleSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleSize").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(ColumnStatisticsTaskSettings::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<String> SCHEDULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleType").getter(getter(ColumnStatisticsTaskSettings::scheduleTypeAsString))
            .setter(setter(Builder::scheduleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleType").build()).build();

    private static final SdkField<String> SETTING_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SettingSource").getter(getter(ColumnStatisticsTaskSettings::settingSourceAsString))
            .setter(setter(Builder::settingSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingSource").build()).build();

    private static final SdkField<ExecutionAttempt> LAST_EXECUTION_ATTEMPT_FIELD = SdkField
            .<ExecutionAttempt> builder(MarshallingType.SDK_POJO).memberName("LastExecutionAttempt")
            .getter(getter(ColumnStatisticsTaskSettings::lastExecutionAttempt)).setter(setter(Builder::lastExecutionAttempt))
            .constructor(ExecutionAttempt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionAttempt").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            TABLE_NAME_FIELD, SCHEDULE_FIELD, COLUMN_NAME_LIST_FIELD, CATALOG_ID_FIELD, ROLE_FIELD, SAMPLE_SIZE_FIELD,
            SECURITY_CONFIGURATION_FIELD, SCHEDULE_TYPE_FIELD, SETTING_SOURCE_FIELD, LAST_EXECUTION_ATTEMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final String tableName;

    private final Schedule schedule;

    private final List<String> columnNameList;

    private final String catalogID;

    private final String role;

    private final Double sampleSize;

    private final String securityConfiguration;

    private final String scheduleType;

    private final String settingSource;

    private final ExecutionAttempt lastExecutionAttempt;

    private ColumnStatisticsTaskSettings(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.schedule = builder.schedule;
        this.columnNameList = builder.columnNameList;
        this.catalogID = builder.catalogID;
        this.role = builder.role;
        this.sampleSize = builder.sampleSize;
        this.securityConfiguration = builder.securityConfiguration;
        this.scheduleType = builder.scheduleType;
        this.settingSource = builder.settingSource;
        this.lastExecutionAttempt = builder.lastExecutionAttempt;
    }

    /**
     * <p>
     * The name of the database where the table resides.
     * </p>
     * 
     * @return The name of the database where the table resides.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table for which to generate column statistics.
     * </p>
     * 
     * @return The name of the table for which to generate column statistics.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A schedule for running the column statistics, specified in CRON syntax.
     * </p>
     * 
     * @return A schedule for running the column statistics, specified in CRON syntax.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnNameList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnNameList() {
        return columnNameList != null && !(columnNameList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of column names for which to run statistics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnNameList} method.
     * </p>
     * 
     * @return A list of column names for which to run statistics.
     */
    public final List<String> columnNameList() {
        return columnNameList;
    }

    /**
     * <p>
     * The ID of the Data Catalog in which the database resides.
     * </p>
     * 
     * @return The ID of the Data Catalog in which the database resides.
     */
    public final String catalogID() {
        return catalogID;
    }

    /**
     * <p>
     * The role used for running the column statistics.
     * </p>
     * 
     * @return The role used for running the column statistics.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The percentage of data to sample.
     * </p>
     * 
     * @return The percentage of data to sample.
     */
    public final Double sampleSize() {
        return sampleSize;
    }

    /**
     * <p>
     * Name of the security configuration that is used to encrypt CloudWatch logs.
     * </p>
     * 
     * @return Name of the security configuration that is used to encrypt CloudWatch logs.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * <p>
     * The type of schedule for a column statistics task. Possible values may be <code>CRON</code> or <code>AUTO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleType} will
     * return {@link ScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleTypeAsString}.
     * </p>
     * 
     * @return The type of schedule for a column statistics task. Possible values may be <code>CRON</code> or
     *         <code>AUTO</code>.
     * @see ScheduleType
     */
    public final ScheduleType scheduleType() {
        return ScheduleType.fromValue(scheduleType);
    }

    /**
     * <p>
     * The type of schedule for a column statistics task. Possible values may be <code>CRON</code> or <code>AUTO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleType} will
     * return {@link ScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleTypeAsString}.
     * </p>
     * 
     * @return The type of schedule for a column statistics task. Possible values may be <code>CRON</code> or
     *         <code>AUTO</code>.
     * @see ScheduleType
     */
    public final String scheduleTypeAsString() {
        return scheduleType;
    }

    /**
     * <p>
     * The source of setting the column statistics task. Possible values may be <code>CATALOG</code> or
     * <code>TABLE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #settingSource}
     * will return {@link SettingSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #settingSourceAsString}.
     * </p>
     * 
     * @return The source of setting the column statistics task. Possible values may be <code>CATALOG</code> or
     *         <code>TABLE</code>.
     * @see SettingSource
     */
    public final SettingSource settingSource() {
        return SettingSource.fromValue(settingSource);
    }

    /**
     * <p>
     * The source of setting the column statistics task. Possible values may be <code>CATALOG</code> or
     * <code>TABLE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #settingSource}
     * will return {@link SettingSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #settingSourceAsString}.
     * </p>
     * 
     * @return The source of setting the column statistics task. Possible values may be <code>CATALOG</code> or
     *         <code>TABLE</code>.
     * @see SettingSource
     */
    public final String settingSourceAsString() {
        return settingSource;
    }

    /**
     * <p>
     * The last <code>ExecutionAttempt</code> for the column statistics task run.
     * </p>
     * 
     * @return The last <code>ExecutionAttempt</code> for the column statistics task run.
     */
    public final ExecutionAttempt lastExecutionAttempt() {
        return lastExecutionAttempt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnNameList() ? columnNameList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(catalogID());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(settingSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionAttempt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatisticsTaskSettings)) {
            return false;
        }
        ColumnStatisticsTaskSettings other = (ColumnStatisticsTaskSettings) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(schedule(), other.schedule()) && hasColumnNameList() == other.hasColumnNameList()
                && Objects.equals(columnNameList(), other.columnNameList()) && Objects.equals(catalogID(), other.catalogID())
                && Objects.equals(role(), other.role()) && Objects.equals(sampleSize(), other.sampleSize())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && Objects.equals(scheduleTypeAsString(), other.scheduleTypeAsString())
                && Objects.equals(settingSourceAsString(), other.settingSourceAsString())
                && Objects.equals(lastExecutionAttempt(), other.lastExecutionAttempt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnStatisticsTaskSettings").add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("Schedule", schedule()).add("ColumnNameList", hasColumnNameList() ? columnNameList() : null)
                .add("CatalogID", catalogID()).add("Role", role()).add("SampleSize", sampleSize())
                .add("SecurityConfiguration", securityConfiguration()).add("ScheduleType", scheduleTypeAsString())
                .add("SettingSource", settingSourceAsString()).add("LastExecutionAttempt", lastExecutionAttempt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "ColumnNameList":
            return Optional.ofNullable(clazz.cast(columnNameList()));
        case "CatalogID":
            return Optional.ofNullable(clazz.cast(catalogID()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "SampleSize":
            return Optional.ofNullable(clazz.cast(sampleSize()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "ScheduleType":
            return Optional.ofNullable(clazz.cast(scheduleTypeAsString()));
        case "SettingSource":
            return Optional.ofNullable(clazz.cast(settingSourceAsString()));
        case "LastExecutionAttempt":
            return Optional.ofNullable(clazz.cast(lastExecutionAttempt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("ColumnNameList", COLUMN_NAME_LIST_FIELD);
        map.put("CatalogID", CATALOG_ID_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("SampleSize", SAMPLE_SIZE_FIELD);
        map.put("SecurityConfiguration", SECURITY_CONFIGURATION_FIELD);
        map.put("ScheduleType", SCHEDULE_TYPE_FIELD);
        map.put("SettingSource", SETTING_SOURCE_FIELD);
        map.put("LastExecutionAttempt", LAST_EXECUTION_ATTEMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatisticsTaskSettings, T> g) {
        return obj -> g.apply((ColumnStatisticsTaskSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnStatisticsTaskSettings> {
        /**
         * <p>
         * The name of the database where the table resides.
         * </p>
         * 
         * @param databaseName
         *        The name of the database where the table resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table for which to generate column statistics.
         * </p>
         * 
         * @param tableName
         *        The name of the table for which to generate column statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A schedule for running the column statistics, specified in CRON syntax.
         * </p>
         * 
         * @param schedule
         *        A schedule for running the column statistics, specified in CRON syntax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * A schedule for running the column statistics, specified in CRON syntax.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * A list of column names for which to run statistics.
         * </p>
         * 
         * @param columnNameList
         *        A list of column names for which to run statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNameList(Collection<String> columnNameList);

        /**
         * <p>
         * A list of column names for which to run statistics.
         * </p>
         * 
         * @param columnNameList
         *        A list of column names for which to run statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNameList(String... columnNameList);

        /**
         * <p>
         * The ID of the Data Catalog in which the database resides.
         * </p>
         * 
         * @param catalogID
         *        The ID of the Data Catalog in which the database resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogID(String catalogID);

        /**
         * <p>
         * The role used for running the column statistics.
         * </p>
         * 
         * @param role
         *        The role used for running the column statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The percentage of data to sample.
         * </p>
         * 
         * @param sampleSize
         *        The percentage of data to sample.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleSize(Double sampleSize);

        /**
         * <p>
         * Name of the security configuration that is used to encrypt CloudWatch logs.
         * </p>
         * 
         * @param securityConfiguration
         *        Name of the security configuration that is used to encrypt CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * The type of schedule for a column statistics task. Possible values may be <code>CRON</code> or
         * <code>AUTO</code>.
         * </p>
         * 
         * @param scheduleType
         *        The type of schedule for a column statistics task. Possible values may be <code>CRON</code> or
         *        <code>AUTO</code>.
         * @see ScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleType
         */
        Builder scheduleType(String scheduleType);

        /**
         * <p>
         * The type of schedule for a column statistics task. Possible values may be <code>CRON</code> or
         * <code>AUTO</code>.
         * </p>
         * 
         * @param scheduleType
         *        The type of schedule for a column statistics task. Possible values may be <code>CRON</code> or
         *        <code>AUTO</code>.
         * @see ScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleType
         */
        Builder scheduleType(ScheduleType scheduleType);

        /**
         * <p>
         * The source of setting the column statistics task. Possible values may be <code>CATALOG</code> or
         * <code>TABLE</code>.
         * </p>
         * 
         * @param settingSource
         *        The source of setting the column statistics task. Possible values may be <code>CATALOG</code> or
         *        <code>TABLE</code>.
         * @see SettingSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingSource
         */
        Builder settingSource(String settingSource);

        /**
         * <p>
         * The source of setting the column statistics task. Possible values may be <code>CATALOG</code> or
         * <code>TABLE</code>.
         * </p>
         * 
         * @param settingSource
         *        The source of setting the column statistics task. Possible values may be <code>CATALOG</code> or
         *        <code>TABLE</code>.
         * @see SettingSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingSource
         */
        Builder settingSource(SettingSource settingSource);

        /**
         * <p>
         * The last <code>ExecutionAttempt</code> for the column statistics task run.
         * </p>
         * 
         * @param lastExecutionAttempt
         *        The last <code>ExecutionAttempt</code> for the column statistics task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionAttempt(ExecutionAttempt lastExecutionAttempt);

        /**
         * <p>
         * The last <code>ExecutionAttempt</code> for the column statistics task run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionAttempt.Builder} avoiding the
         * need to create one manually via {@link ExecutionAttempt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionAttempt.Builder#build()} is called immediately and its
         * result is passed to {@link #lastExecutionAttempt(ExecutionAttempt)}.
         * 
         * @param lastExecutionAttempt
         *        a consumer that will call methods on {@link ExecutionAttempt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastExecutionAttempt(ExecutionAttempt)
         */
        default Builder lastExecutionAttempt(Consumer<ExecutionAttempt.Builder> lastExecutionAttempt) {
            return lastExecutionAttempt(ExecutionAttempt.builder().applyMutation(lastExecutionAttempt).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private String tableName;

        private Schedule schedule;

        private List<String> columnNameList = DefaultSdkAutoConstructList.getInstance();

        private String catalogID;

        private String role;

        private Double sampleSize;

        private String securityConfiguration;

        private String scheduleType;

        private String settingSource;

        private ExecutionAttempt lastExecutionAttempt;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatisticsTaskSettings model) {
            databaseName(model.databaseName);
            tableName(model.tableName);
            schedule(model.schedule);
            columnNameList(model.columnNameList);
            catalogID(model.catalogID);
            role(model.role);
            sampleSize(model.sampleSize);
            securityConfiguration(model.securityConfiguration);
            scheduleType(model.scheduleType);
            settingSource(model.settingSource);
            lastExecutionAttempt(model.lastExecutionAttempt);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Collection<String> getColumnNameList() {
            if (columnNameList instanceof SdkAutoConstructList) {
                return null;
            }
            return columnNameList;
        }

        public final void setColumnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
        }

        @Override
        public final Builder columnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNameList(String... columnNameList) {
            columnNameList(Arrays.asList(columnNameList));
            return this;
        }

        public final String getCatalogID() {
            return catalogID;
        }

        public final void setCatalogID(String catalogID) {
            this.catalogID = catalogID;
        }

        @Override
        public final Builder catalogID(String catalogID) {
            this.catalogID = catalogID;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Double getSampleSize() {
            return sampleSize;
        }

        public final void setSampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final String getScheduleType() {
            return scheduleType;
        }

        public final void setScheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
        }

        @Override
        public final Builder scheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        @Override
        public final Builder scheduleType(ScheduleType scheduleType) {
            this.scheduleType(scheduleType == null ? null : scheduleType.toString());
            return this;
        }

        public final String getSettingSource() {
            return settingSource;
        }

        public final void setSettingSource(String settingSource) {
            this.settingSource = settingSource;
        }

        @Override
        @Transient
        public final Builder settingSource(String settingSource) {
            this.settingSource = settingSource;
            return this;
        }

        @Override
        @Transient
        public final Builder settingSource(SettingSource settingSource) {
            this.settingSource(settingSource == null ? null : settingSource.toString());
            return this;
        }

        public final ExecutionAttempt.Builder getLastExecutionAttempt() {
            return lastExecutionAttempt != null ? lastExecutionAttempt.toBuilder() : null;
        }

        public final void setLastExecutionAttempt(ExecutionAttempt.BuilderImpl lastExecutionAttempt) {
            this.lastExecutionAttempt = lastExecutionAttempt != null ? lastExecutionAttempt.build() : null;
        }

        @Override
        public final Builder lastExecutionAttempt(ExecutionAttempt lastExecutionAttempt) {
            this.lastExecutionAttempt = lastExecutionAttempt;
            return this;
        }

        @Override
        public ColumnStatisticsTaskSettings build() {
            return new ColumnStatisticsTaskSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
