/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that splits a dataset into two, based on a filter condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Filter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(Filter::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOGICAL_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalOperator").getter(getter(Filter::logicalOperatorAsString))
            .setter(setter(Builder::logicalOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalOperator").build()).build();

    private static final SdkField<List<FilterExpression>> FILTERS_FIELD = SdkField
            .<List<FilterExpression>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(Filter::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterExpression> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterExpression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            LOGICAL_OPERATOR_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String logicalOperator;

    private final List<FilterExpression> filters;

    private Filter(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.logicalOperator = builder.logicalOperator;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data inputs identified by their node names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The data inputs identified by their node names.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * The operator used to filter rows by comparing the key value to a specified value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logicalOperator}
     * will return {@link FilterLogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #logicalOperatorAsString}.
     * </p>
     * 
     * @return The operator used to filter rows by comparing the key value to a specified value.
     * @see FilterLogicalOperator
     */
    public final FilterLogicalOperator logicalOperator() {
        return FilterLogicalOperator.fromValue(logicalOperator);
    }

    /**
     * <p>
     * The operator used to filter rows by comparing the key value to a specified value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logicalOperator}
     * will return {@link FilterLogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #logicalOperatorAsString}.
     * </p>
     * 
     * @return The operator used to filter rows by comparing the key value to a specified value.
     * @see FilterLogicalOperator
     */
    public final String logicalOperatorAsString() {
        return logicalOperator;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a filter expression.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Specifies a filter expression.
     */
    public final List<FilterExpression> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logicalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs())
                && Objects.equals(logicalOperatorAsString(), other.logicalOperatorAsString())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("LogicalOperator", logicalOperatorAsString()).add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "LogicalOperator":
            return Optional.ofNullable(clazz.cast(logicalOperatorAsString()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("LogicalOperator", LOGICAL_OPERATOR_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * The operator used to filter rows by comparing the key value to a specified value.
         * </p>
         * 
         * @param logicalOperator
         *        The operator used to filter rows by comparing the key value to a specified value.
         * @see FilterLogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterLogicalOperator
         */
        Builder logicalOperator(String logicalOperator);

        /**
         * <p>
         * The operator used to filter rows by comparing the key value to a specified value.
         * </p>
         * 
         * @param logicalOperator
         *        The operator used to filter rows by comparing the key value to a specified value.
         * @see FilterLogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterLogicalOperator
         */
        Builder logicalOperator(FilterLogicalOperator logicalOperator);

        /**
         * <p>
         * Specifies a filter expression.
         * </p>
         * 
         * @param filters
         *        Specifies a filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<FilterExpression> filters);

        /**
         * <p>
         * Specifies a filter expression.
         * </p>
         * 
         * @param filters
         *        Specifies a filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(FilterExpression... filters);

        /**
         * <p>
         * Specifies a filter expression.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.FilterExpression.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.FilterExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.FilterExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<FilterExpression>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.FilterExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<FilterExpression>)
         */
        Builder filters(Consumer<FilterExpression.Builder>... filters);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String logicalOperator;

        private List<FilterExpression> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            name(model.name);
            inputs(model.inputs);
            logicalOperator(model.logicalOperator);
            filters(model.filters);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getLogicalOperator() {
            return logicalOperator;
        }

        public final void setLogicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        @Override
        public final Builder logicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
            return this;
        }

        @Override
        public final Builder logicalOperator(FilterLogicalOperator logicalOperator) {
            this.logicalOperator(logicalOperator == null ? null : logicalOperator.toString());
            return this;
        }

        public final List<FilterExpression.Builder> getFilters() {
            List<FilterExpression.Builder> result = FilterExpressionsCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<FilterExpression.BuilderImpl> filters) {
            this.filters = FilterExpressionsCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<FilterExpression> filters) {
            this.filters = FilterExpressionsCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(FilterExpression... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<FilterExpression.Builder>... filters) {
            filters(Stream.of(filters).map(c -> FilterExpression.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
