/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines an Apache Iceberg metadata table to create in the catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergInput implements SdkPojo, Serializable, ToCopyableBuilder<IcebergInput.Builder, IcebergInput> {
    private static final SdkField<String> METADATA_OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataOperation").getter(getter(IcebergInput::metadataOperationAsString))
            .setter(setter(Builder::metadataOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOperation").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(IcebergInput::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_OPERATION_FIELD,
            VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metadataOperation;

    private final String version;

    private IcebergInput(BuilderImpl builder) {
        this.metadataOperation = builder.metadataOperation;
        this.version = builder.version;
    }

    /**
     * <p>
     * A required metadata operation. Can only be set to <code>CREATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataOperation}
     * will return {@link MetadataOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metadataOperationAsString}.
     * </p>
     * 
     * @return A required metadata operation. Can only be set to <code>CREATE</code>.
     * @see MetadataOperation
     */
    public final MetadataOperation metadataOperation() {
        return MetadataOperation.fromValue(metadataOperation);
    }

    /**
     * <p>
     * A required metadata operation. Can only be set to <code>CREATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataOperation}
     * will return {@link MetadataOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metadataOperationAsString}.
     * </p>
     * 
     * @return A required metadata operation. Can only be set to <code>CREATE</code>.
     * @see MetadataOperation
     */
    public final String metadataOperationAsString() {
        return metadataOperation;
    }

    /**
     * <p>
     * The table version for the Iceberg table. Defaults to 2.
     * </p>
     * 
     * @return The table version for the Iceberg table. Defaults to 2.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadataOperationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergInput)) {
            return false;
        }
        IcebergInput other = (IcebergInput) obj;
        return Objects.equals(metadataOperationAsString(), other.metadataOperationAsString())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergInput").add("MetadataOperation", metadataOperationAsString()).add("Version", version())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetadataOperation":
            return Optional.ofNullable(clazz.cast(metadataOperationAsString()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetadataOperation", METADATA_OPERATION_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergInput, T> g) {
        return obj -> g.apply((IcebergInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergInput> {
        /**
         * <p>
         * A required metadata operation. Can only be set to <code>CREATE</code>.
         * </p>
         * 
         * @param metadataOperation
         *        A required metadata operation. Can only be set to <code>CREATE</code>.
         * @see MetadataOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataOperation
         */
        Builder metadataOperation(String metadataOperation);

        /**
         * <p>
         * A required metadata operation. Can only be set to <code>CREATE</code>.
         * </p>
         * 
         * @param metadataOperation
         *        A required metadata operation. Can only be set to <code>CREATE</code>.
         * @see MetadataOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataOperation
         */
        Builder metadataOperation(MetadataOperation metadataOperation);

        /**
         * <p>
         * The table version for the Iceberg table. Defaults to 2.
         * </p>
         * 
         * @param version
         *        The table version for the Iceberg table. Defaults to 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String metadataOperation;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergInput model) {
            metadataOperation(model.metadataOperation);
            version(model.version);
        }

        public final String getMetadataOperation() {
            return metadataOperation;
        }

        public final void setMetadataOperation(String metadataOperation) {
            this.metadataOperation = metadataOperation;
        }

        @Override
        public final Builder metadataOperation(String metadataOperation) {
            this.metadataOperation = metadataOperation;
            return this;
        }

        @Override
        public final Builder metadataOperation(MetadataOperation metadataOperation) {
            this.metadataOperation(metadataOperation == null ? null : metadataOperation.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public IcebergInput build() {
            return new IcebergInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
