/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Edge;
import software.amazon.awssdk.services.glue.model.EdgeListCopier;
import software.amazon.awssdk.services.glue.model.Node;
import software.amazon.awssdk.services.glue.model.NodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowGraph
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowGraph> {
    private static final SdkField<List<Node>> NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Nodes").getter(WorkflowGraph.getter(WorkflowGraph::nodes)).setter(WorkflowGraph.setter(Builder::nodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Node::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Edge>> EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Edges").getter(WorkflowGraph.getter(WorkflowGraph::edges)).setter(WorkflowGraph.setter(Builder::edges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Edge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODES_FIELD, EDGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowGraph.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Node> nodes;
    private final List<Edge> edges;

    private WorkflowGraph(BuilderImpl builder) {
        this.nodes = builder.nodes;
        this.edges = builder.edges;
    }

    public final boolean hasNodes() {
        return this.nodes != null && !(this.nodes instanceof SdkAutoConstructList);
    }

    public final List<Node> nodes() {
        return this.nodes;
    }

    public final boolean hasEdges() {
        return this.edges != null && !(this.edges instanceof SdkAutoConstructList);
    }

    public final List<Edge> edges() {
        return this.edges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodes() ? this.nodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdges() ? this.edges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowGraph)) {
            return false;
        }
        WorkflowGraph other = (WorkflowGraph)obj;
        return this.hasNodes() == other.hasNodes() && Objects.equals(this.nodes(), other.nodes()) && this.hasEdges() == other.hasEdges() && Objects.equals(this.edges(), other.edges());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowGraph").add("Nodes", this.hasNodes() ? this.nodes() : null).add("Edges", this.hasEdges() ? this.edges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Nodes": {
                return Optional.ofNullable(clazz.cast(this.nodes()));
            }
            case "Edges": {
                return Optional.ofNullable(clazz.cast(this.edges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Nodes", NODES_FIELD);
        map.put("Edges", EDGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowGraph, T> g) {
        return obj -> g.apply((WorkflowGraph)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Node> nodes = DefaultSdkAutoConstructList.getInstance();
        private List<Edge> edges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowGraph model) {
            this.nodes(model.nodes);
            this.edges(model.edges);
        }

        public final List<Node.Builder> getNodes() {
            List<Node.Builder> result = NodeListCopier.copyToBuilder(this.nodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodes(Collection<Node.BuilderImpl> nodes) {
            this.nodes = NodeListCopier.copyFromBuilder(nodes);
        }

        @Override
        public final Builder nodes(Collection<Node> nodes) {
            this.nodes = NodeListCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Node ... nodes) {
            this.nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<Node.Builder> ... nodes) {
            this.nodes(Stream.of(nodes).map(c -> (Node)((Node.Builder)Node.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Edge.Builder> getEdges() {
            List<Edge.Builder> result = EdgeListCopier.copyToBuilder(this.edges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdges(Collection<Edge.BuilderImpl> edges) {
            this.edges = EdgeListCopier.copyFromBuilder(edges);
        }

        @Override
        public final Builder edges(Collection<Edge> edges) {
            this.edges = EdgeListCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Edge ... edges) {
            this.edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<Edge.Builder> ... edges) {
            this.edges(Stream.of(edges).map(c -> (Edge)((Edge.Builder)Edge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public WorkflowGraph build() {
            return new WorkflowGraph(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowGraph> {
        public Builder nodes(Collection<Node> var1);

        public Builder nodes(Node ... var1);

        public Builder nodes(Consumer<Node.Builder> ... var1);

        public Builder edges(Collection<Edge> var1);

        public Builder edges(Edge ... var1);

        public Builder edges(Consumer<Edge.Builder> ... var1);
    }
}

