/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.InclusionAnnotationValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDataQualityProfileAnnotationRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, PutDataQualityProfileAnnotationRequest> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(PutDataQualityProfileAnnotationRequest.getter(PutDataQualityProfileAnnotationRequest::profileId)).setter(PutDataQualityProfileAnnotationRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> INCLUSION_ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InclusionAnnotation").getter(PutDataQualityProfileAnnotationRequest.getter(PutDataQualityProfileAnnotationRequest::inclusionAnnotationAsString)).setter(PutDataQualityProfileAnnotationRequest.setter(Builder::inclusionAnnotation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, INCLUSION_ANNOTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutDataQualityProfileAnnotationRequest.memberNameToFieldInitializer();
    private final String profileId;
    private final String inclusionAnnotation;

    private PutDataQualityProfileAnnotationRequest(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.inclusionAnnotation = builder.inclusionAnnotation;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final InclusionAnnotationValue inclusionAnnotation() {
        return InclusionAnnotationValue.fromValue(this.inclusionAnnotation);
    }

    public final String inclusionAnnotationAsString() {
        return this.inclusionAnnotation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionAnnotationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataQualityProfileAnnotationRequest)) {
            return false;
        }
        PutDataQualityProfileAnnotationRequest other = (PutDataQualityProfileAnnotationRequest)((Object)obj);
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.inclusionAnnotationAsString(), other.inclusionAnnotationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutDataQualityProfileAnnotationRequest").add("ProfileId", (Object)this.profileId()).add("InclusionAnnotation", (Object)this.inclusionAnnotationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "InclusionAnnotation": {
                return Optional.ofNullable(clazz.cast(this.inclusionAnnotationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("InclusionAnnotation", INCLUSION_ANNOTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDataQualityProfileAnnotationRequest, T> g) {
        return obj -> g.apply((PutDataQualityProfileAnnotationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String profileId;
        private String inclusionAnnotation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataQualityProfileAnnotationRequest model) {
            super(model);
            this.profileId(model.profileId);
            this.inclusionAnnotation(model.inclusionAnnotation);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getInclusionAnnotation() {
            return this.inclusionAnnotation;
        }

        public final void setInclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
        }

        @Override
        public final Builder inclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
            return this;
        }

        @Override
        public final Builder inclusionAnnotation(InclusionAnnotationValue inclusionAnnotation) {
            this.inclusionAnnotation(inclusionAnnotation == null ? null : inclusionAnnotation.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataQualityProfileAnnotationRequest build() {
            return new PutDataQualityProfileAnnotationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDataQualityProfileAnnotationRequest> {
        public Builder profileId(String var1);

        public Builder inclusionAnnotation(String var1);

        public Builder inclusionAnnotation(InclusionAnnotationValue var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

