/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authentication configuration for a connection returned by the <code>DescribeConnectionType</code> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthConfiguration.Builder, AuthConfiguration> {
    private static final SdkField<Property> AUTHENTICATION_TYPE_FIELD = SdkField.<Property> builder(MarshallingType.SDK_POJO)
            .memberName("AuthenticationType").getter(getter(AuthConfiguration::authenticationType))
            .setter(setter(Builder::authenticationType)).constructor(Property::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<Property> SECRET_ARN_FIELD = SdkField.<Property> builder(MarshallingType.SDK_POJO)
            .memberName("SecretArn").getter(getter(AuthConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .constructor(Property::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<Map<String, Property>> O_AUTH2_PROPERTIES_FIELD = SdkField
            .<Map<String, Property>> builder(MarshallingType.MAP)
            .memberName("OAuth2Properties")
            .getter(getter(AuthConfiguration::oAuth2Properties))
            .setter(setter(Builder::oAuth2Properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Property> builder(MarshallingType.SDK_POJO)
                                            .constructor(Property::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Property>> BASIC_AUTHENTICATION_PROPERTIES_FIELD = SdkField
            .<Map<String, Property>> builder(MarshallingType.MAP)
            .memberName("BasicAuthenticationProperties")
            .getter(getter(AuthConfiguration::basicAuthenticationProperties))
            .setter(setter(Builder::basicAuthenticationProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthenticationProperties")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Property> builder(MarshallingType.SDK_POJO)
                                            .constructor(Property::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Property>> CUSTOM_AUTHENTICATION_PROPERTIES_FIELD = SdkField
            .<Map<String, Property>> builder(MarshallingType.MAP)
            .memberName("CustomAuthenticationProperties")
            .getter(getter(AuthConfiguration::customAuthenticationProperties))
            .setter(setter(Builder::customAuthenticationProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAuthenticationProperties")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Property> builder(MarshallingType.SDK_POJO)
                                            .constructor(Property::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            SECRET_ARN_FIELD, O_AUTH2_PROPERTIES_FIELD, BASIC_AUTHENTICATION_PROPERTIES_FIELD,
            CUSTOM_AUTHENTICATION_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Property authenticationType;

    private final Property secretArn;

    private final Map<String, Property> oAuth2Properties;

    private final Map<String, Property> basicAuthenticationProperties;

    private final Map<String, Property> customAuthenticationProperties;

    private AuthConfiguration(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.secretArn = builder.secretArn;
        this.oAuth2Properties = builder.oAuth2Properties;
        this.basicAuthenticationProperties = builder.basicAuthenticationProperties;
        this.customAuthenticationProperties = builder.customAuthenticationProperties;
    }

    /**
     * <p>
     * The type of authentication for a connection.
     * </p>
     * 
     * @return The type of authentication for a connection.
     */
    public final Property authenticationType() {
        return authenticationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Secrets Manager.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Secrets Manager.
     */
    public final Property secretArn() {
        return secretArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the OAuth2Properties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOAuth2Properties() {
        return oAuth2Properties != null && !(oAuth2Properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs for the OAuth2 properties. Each value is a a <code>Property</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOAuth2Properties} method.
     * </p>
     * 
     * @return A map of key-value pairs for the OAuth2 properties. Each value is a a <code>Property</code> object.
     */
    public final Map<String, Property> oAuth2Properties() {
        return oAuth2Properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the BasicAuthenticationProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBasicAuthenticationProperties() {
        return basicAuthenticationProperties != null && !(basicAuthenticationProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs for the OAuth2 properties. Each value is a a <code>Property</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBasicAuthenticationProperties} method.
     * </p>
     * 
     * @return A map of key-value pairs for the OAuth2 properties. Each value is a a <code>Property</code> object.
     */
    public final Map<String, Property> basicAuthenticationProperties() {
        return basicAuthenticationProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAuthenticationProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomAuthenticationProperties() {
        return customAuthenticationProperties != null && !(customAuthenticationProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs for the custom authentication properties. Each value is a a <code>Property</code>
     * object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAuthenticationProperties} method.
     * </p>
     * 
     * @return A map of key-value pairs for the custom authentication properties. Each value is a a
     *         <code>Property</code> object.
     */
    public final Map<String, Property> customAuthenticationProperties() {
        return customAuthenticationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOAuth2Properties() ? oAuth2Properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBasicAuthenticationProperties() ? basicAuthenticationProperties() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCustomAuthenticationProperties() ? customAuthenticationProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthConfiguration)) {
            return false;
        }
        AuthConfiguration other = (AuthConfiguration) obj;
        return Objects.equals(authenticationType(), other.authenticationType()) && Objects.equals(secretArn(), other.secretArn())
                && hasOAuth2Properties() == other.hasOAuth2Properties()
                && Objects.equals(oAuth2Properties(), other.oAuth2Properties())
                && hasBasicAuthenticationProperties() == other.hasBasicAuthenticationProperties()
                && Objects.equals(basicAuthenticationProperties(), other.basicAuthenticationProperties())
                && hasCustomAuthenticationProperties() == other.hasCustomAuthenticationProperties()
                && Objects.equals(customAuthenticationProperties(), other.customAuthenticationProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AuthConfiguration")
                .add("AuthenticationType", authenticationType())
                .add("SecretArn", secretArn())
                .add("OAuth2Properties", hasOAuth2Properties() ? oAuth2Properties() : null)
                .add("BasicAuthenticationProperties", hasBasicAuthenticationProperties() ? basicAuthenticationProperties() : null)
                .add("CustomAuthenticationProperties",
                        hasCustomAuthenticationProperties() ? customAuthenticationProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationType()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "OAuth2Properties":
            return Optional.ofNullable(clazz.cast(oAuth2Properties()));
        case "BasicAuthenticationProperties":
            return Optional.ofNullable(clazz.cast(basicAuthenticationProperties()));
        case "CustomAuthenticationProperties":
            return Optional.ofNullable(clazz.cast(customAuthenticationProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("OAuth2Properties", O_AUTH2_PROPERTIES_FIELD);
        map.put("BasicAuthenticationProperties", BASIC_AUTHENTICATION_PROPERTIES_FIELD);
        map.put("CustomAuthenticationProperties", CUSTOM_AUTHENTICATION_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthConfiguration, T> g) {
        return obj -> g.apply((AuthConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthConfiguration> {
        /**
         * <p>
         * The type of authentication for a connection.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication for a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationType(Property authenticationType);

        /**
         * <p>
         * The type of authentication for a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link Property.Builder} avoiding the need to
         * create one manually via {@link Property#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Property.Builder#build()} is called immediately and its result is
         * passed to {@link #authenticationType(Property)}.
         * 
         * @param authenticationType
         *        a consumer that will call methods on {@link Property.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationType(Property)
         */
        default Builder authenticationType(Consumer<Property.Builder> authenticationType) {
            return authenticationType(Property.builder().applyMutation(authenticationType).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Secrets Manager.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) for the Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(Property secretArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Secrets Manager.
         * </p>
         * This is a convenience method that creates an instance of the {@link Property.Builder} avoiding the need to
         * create one manually via {@link Property#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Property.Builder#build()} is called immediately and its result is
         * passed to {@link #secretArn(Property)}.
         * 
         * @param secretArn
         *        a consumer that will call methods on {@link Property.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretArn(Property)
         */
        default Builder secretArn(Consumer<Property.Builder> secretArn) {
            return secretArn(Property.builder().applyMutation(secretArn).build());
        }

        /**
         * <p>
         * A map of key-value pairs for the OAuth2 properties. Each value is a a <code>Property</code> object.
         * </p>
         * 
         * @param oAuth2Properties
         *        A map of key-value pairs for the OAuth2 properties. Each value is a a <code>Property</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth2Properties(Map<String, Property> oAuth2Properties);

        /**
         * <p>
         * A map of key-value pairs for the OAuth2 properties. Each value is a a <code>Property</code> object.
         * </p>
         * 
         * @param basicAuthenticationProperties
         *        A map of key-value pairs for the OAuth2 properties. Each value is a a <code>Property</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthenticationProperties(Map<String, Property> basicAuthenticationProperties);

        /**
         * <p>
         * A map of key-value pairs for the custom authentication properties. Each value is a a <code>Property</code>
         * object.
         * </p>
         * 
         * @param customAuthenticationProperties
         *        A map of key-value pairs for the custom authentication properties. Each value is a a
         *        <code>Property</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAuthenticationProperties(Map<String, Property> customAuthenticationProperties);
    }

    static final class BuilderImpl implements Builder {
        private Property authenticationType;

        private Property secretArn;

        private Map<String, Property> oAuth2Properties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Property> basicAuthenticationProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Property> customAuthenticationProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthConfiguration model) {
            authenticationType(model.authenticationType);
            secretArn(model.secretArn);
            oAuth2Properties(model.oAuth2Properties);
            basicAuthenticationProperties(model.basicAuthenticationProperties);
            customAuthenticationProperties(model.customAuthenticationProperties);
        }

        public final Property.Builder getAuthenticationType() {
            return authenticationType != null ? authenticationType.toBuilder() : null;
        }

        public final void setAuthenticationType(Property.BuilderImpl authenticationType) {
            this.authenticationType = authenticationType != null ? authenticationType.build() : null;
        }

        @Override
        public final Builder authenticationType(Property authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public final Property.Builder getSecretArn() {
            return secretArn != null ? secretArn.toBuilder() : null;
        }

        public final void setSecretArn(Property.BuilderImpl secretArn) {
            this.secretArn = secretArn != null ? secretArn.build() : null;
        }

        @Override
        public final Builder secretArn(Property secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Map<String, Property.Builder> getOAuth2Properties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.oAuth2Properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOAuth2Properties(Map<String, Property.BuilderImpl> oAuth2Properties) {
            this.oAuth2Properties = PropertiesMapCopier.copyFromBuilder(oAuth2Properties);
        }

        @Override
        public final Builder oAuth2Properties(Map<String, Property> oAuth2Properties) {
            this.oAuth2Properties = PropertiesMapCopier.copy(oAuth2Properties);
            return this;
        }

        public final Map<String, Property.Builder> getBasicAuthenticationProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.basicAuthenticationProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBasicAuthenticationProperties(Map<String, Property.BuilderImpl> basicAuthenticationProperties) {
            this.basicAuthenticationProperties = PropertiesMapCopier.copyFromBuilder(basicAuthenticationProperties);
        }

        @Override
        public final Builder basicAuthenticationProperties(Map<String, Property> basicAuthenticationProperties) {
            this.basicAuthenticationProperties = PropertiesMapCopier.copy(basicAuthenticationProperties);
            return this;
        }

        public final Map<String, Property.Builder> getCustomAuthenticationProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.customAuthenticationProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCustomAuthenticationProperties(Map<String, Property.BuilderImpl> customAuthenticationProperties) {
            this.customAuthenticationProperties = PropertiesMapCopier.copyFromBuilder(customAuthenticationProperties);
        }

        @Override
        public final Builder customAuthenticationProperties(Map<String, Property> customAuthenticationProperties) {
            this.customAuthenticationProperties = PropertiesMapCopier.copy(customAuthenticationProperties);
            return this;
        }

        @Override
        public AuthConfiguration build() {
            return new AuthConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
