/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties associated with the integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrationConfig.Builder, IntegrationConfig> {
    private static final SdkField<String> REFRESH_INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshInterval").getter(getter(IntegrationConfig::refreshInterval))
            .setter(setter(Builder::refreshInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshInterval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFRESH_INTERVAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String refreshInterval;

    private IntegrationConfig(BuilderImpl builder) {
        this.refreshInterval = builder.refreshInterval;
    }

    /**
     * <p>
     * Specifies the frequency at which CDC (Change Data Capture) pulls or incremental loads should occur. This
     * parameter provides flexibility to align the refresh rate with your specific data update patterns, system load
     * considerations, and performance optimization goals. Time increment can be set from 15 minutes to 8640 minutes
     * (six days). Currently supports creation of <code>RefreshInterval</code> only.
     * </p>
     * 
     * @return Specifies the frequency at which CDC (Change Data Capture) pulls or incremental loads should occur. This
     *         parameter provides flexibility to align the refresh rate with your specific data update patterns, system
     *         load considerations, and performance optimization goals. Time increment can be set from 15 minutes to
     *         8640 minutes (six days). Currently supports creation of <code>RefreshInterval</code> only.
     */
    public final String refreshInterval() {
        return refreshInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(refreshInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationConfig)) {
            return false;
        }
        IntegrationConfig other = (IntegrationConfig) obj;
        return Objects.equals(refreshInterval(), other.refreshInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrationConfig").add("RefreshInterval", refreshInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefreshInterval":
            return Optional.ofNullable(clazz.cast(refreshInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RefreshInterval", REFRESH_INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrationConfig, T> g) {
        return obj -> g.apply((IntegrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrationConfig> {
        /**
         * <p>
         * Specifies the frequency at which CDC (Change Data Capture) pulls or incremental loads should occur. This
         * parameter provides flexibility to align the refresh rate with your specific data update patterns, system load
         * considerations, and performance optimization goals. Time increment can be set from 15 minutes to 8640 minutes
         * (six days). Currently supports creation of <code>RefreshInterval</code> only.
         * </p>
         * 
         * @param refreshInterval
         *        Specifies the frequency at which CDC (Change Data Capture) pulls or incremental loads should occur.
         *        This parameter provides flexibility to align the refresh rate with your specific data update patterns,
         *        system load considerations, and performance optimization goals. Time increment can be set from 15
         *        minutes to 8640 minutes (six days). Currently supports creation of <code>RefreshInterval</code> only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshInterval(String refreshInterval);
    }

    static final class BuilderImpl implements Builder {
        private String refreshInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationConfig model) {
            refreshInterval(model.refreshInterval);
        }

        public final String getRefreshInterval() {
            return refreshInterval;
        }

        public final void setRefreshInterval(String refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        @Override
        public final Builder refreshInterval(String refreshInterval) {
            this.refreshInterval = refreshInterval;
            return this;
        }

        @Override
        public IntegrationConfig build() {
            return new IntegrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
