/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes how data is partitioned on the target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrationPartition implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrationPartition.Builder, IntegrationPartition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(IntegrationPartition::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> FUNCTION_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionSpec").getter(getter(IntegrationPartition::functionSpec)).setter(setter(Builder::functionSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionSpec").build()).build();

    private static final SdkField<String> CONVERSION_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConversionSpec").getter(getter(IntegrationPartition::conversionSpec))
            .setter(setter(Builder::conversionSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversionSpec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            FUNCTION_SPEC_FIELD, CONVERSION_SPEC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String functionSpec;

    private final String conversionSpec;

    private IntegrationPartition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.functionSpec = builder.functionSpec;
        this.conversionSpec = builder.conversionSpec;
    }

    /**
     * <p>
     * The field name used to partition data on the target. Avoid using columns that have unique values for each row
     * (for example, `LastModifiedTimestamp`, `SystemModTimeStamp`) as the partition column. These columns are not
     * suitable for partitioning because they create a large number of small partitions, which can lead to performance
     * issues.
     * </p>
     * 
     * @return The field name used to partition data on the target. Avoid using columns that have unique values for each
     *         row (for example, `LastModifiedTimestamp`, `SystemModTimeStamp`) as the partition column. These columns
     *         are not suitable for partitioning because they create a large number of small partitions, which can lead
     *         to performance issues.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * Specifies the function used to partition data on the target. The only accepted value for this parameter is
     * `'identity'` (string). The `'identity'` function ensures that the data partitioning on the target follows the
     * same scheme as the source. In other words, the partitioning structure of the source data is preserved in the
     * target destination.
     * </p>
     * 
     * @return Specifies the function used to partition data on the target. The only accepted value for this parameter
     *         is `'identity'` (string). The `'identity'` function ensures that the data partitioning on the target
     *         follows the same scheme as the source. In other words, the partitioning structure of the source data is
     *         preserved in the target destination.
     */
    public final String functionSpec() {
        return functionSpec;
    }

    /**
     * <p>
     * Specifies the timestamp format of the source data. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>epoch_sec</code> - Unix epoch timestamp in seconds
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>epoch_milli</code> - Unix epoch timestamp in milliseconds
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iso</code> - ISO 8601 formatted timestamp
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Only specify <code>ConversionSpec</code> when using timestamp-based partition functions (year, month, day, or
     * hour). Glue Zero-ETL uses this parameter to correctly transform source data into timestamp format before
     * partitioning.
     * </p>
     * <p>
     * Do not use high-cardinality columns with the <code>identity</code> partition function. High-cardinality columns
     * include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Primary keys
     * </p>
     * </li>
     * <li>
     * <p>
     * Timestamp fields (such as <code>LastModifiedTimestamp</code>, <code>CreatedDate</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * System-generated timestamps
     * </p>
     * </li>
     * </ul>
     * <p>
     * Using high-cardinality columns with identity partitioning creates many small partitions, which can significantly
     * degrade ingestion performance.
     * </p>
     * </note>
     * 
     * @return Specifies the timestamp format of the source data. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>epoch_sec</code> - Unix epoch timestamp in seconds
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>epoch_milli</code> - Unix epoch timestamp in milliseconds
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iso</code> - ISO 8601 formatted timestamp
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Only specify <code>ConversionSpec</code> when using timestamp-based partition functions (year, month,
     *         day, or hour). Glue Zero-ETL uses this parameter to correctly transform source data into timestamp format
     *         before partitioning.
     *         </p>
     *         <p>
     *         Do not use high-cardinality columns with the <code>identity</code> partition function. High-cardinality
     *         columns include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Primary keys
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Timestamp fields (such as <code>LastModifiedTimestamp</code>, <code>CreatedDate</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         System-generated timestamps
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Using high-cardinality columns with identity partitioning creates many small partitions, which can
     *         significantly degrade ingestion performance.
     *         </p>
     */
    public final String conversionSpec() {
        return conversionSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(functionSpec());
        hashCode = 31 * hashCode + Objects.hashCode(conversionSpec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationPartition)) {
            return false;
        }
        IntegrationPartition other = (IntegrationPartition) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(functionSpec(), other.functionSpec())
                && Objects.equals(conversionSpec(), other.conversionSpec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrationPartition").add("FieldName", fieldName()).add("FunctionSpec", functionSpec())
                .add("ConversionSpec", conversionSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "FunctionSpec":
            return Optional.ofNullable(clazz.cast(functionSpec()));
        case "ConversionSpec":
            return Optional.ofNullable(clazz.cast(conversionSpec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("FunctionSpec", FUNCTION_SPEC_FIELD);
        map.put("ConversionSpec", CONVERSION_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrationPartition, T> g) {
        return obj -> g.apply((IntegrationPartition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrationPartition> {
        /**
         * <p>
         * The field name used to partition data on the target. Avoid using columns that have unique values for each row
         * (for example, `LastModifiedTimestamp`, `SystemModTimeStamp`) as the partition column. These columns are not
         * suitable for partitioning because they create a large number of small partitions, which can lead to
         * performance issues.
         * </p>
         * 
         * @param fieldName
         *        The field name used to partition data on the target. Avoid using columns that have unique values for
         *        each row (for example, `LastModifiedTimestamp`, `SystemModTimeStamp`) as the partition column. These
         *        columns are not suitable for partitioning because they create a large number of small partitions,
         *        which can lead to performance issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * Specifies the function used to partition data on the target. The only accepted value for this parameter is
         * `'identity'` (string). The `'identity'` function ensures that the data partitioning on the target follows the
         * same scheme as the source. In other words, the partitioning structure of the source data is preserved in the
         * target destination.
         * </p>
         * 
         * @param functionSpec
         *        Specifies the function used to partition data on the target. The only accepted value for this
         *        parameter is `'identity'` (string). The `'identity'` function ensures that the data partitioning on
         *        the target follows the same scheme as the source. In other words, the partitioning structure of the
         *        source data is preserved in the target destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionSpec(String functionSpec);

        /**
         * <p>
         * Specifies the timestamp format of the source data. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>epoch_sec</code> - Unix epoch timestamp in seconds
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>epoch_milli</code> - Unix epoch timestamp in milliseconds
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iso</code> - ISO 8601 formatted timestamp
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Only specify <code>ConversionSpec</code> when using timestamp-based partition functions (year, month, day, or
         * hour). Glue Zero-ETL uses this parameter to correctly transform source data into timestamp format before
         * partitioning.
         * </p>
         * <p>
         * Do not use high-cardinality columns with the <code>identity</code> partition function. High-cardinality
         * columns include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Primary keys
         * </p>
         * </li>
         * <li>
         * <p>
         * Timestamp fields (such as <code>LastModifiedTimestamp</code>, <code>CreatedDate</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * System-generated timestamps
         * </p>
         * </li>
         * </ul>
         * <p>
         * Using high-cardinality columns with identity partitioning creates many small partitions, which can
         * significantly degrade ingestion performance.
         * </p>
         * </note>
         * 
         * @param conversionSpec
         *        Specifies the timestamp format of the source data. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>epoch_sec</code> - Unix epoch timestamp in seconds
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>epoch_milli</code> - Unix epoch timestamp in milliseconds
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iso</code> - ISO 8601 formatted timestamp
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Only specify <code>ConversionSpec</code> when using timestamp-based partition functions (year, month,
         *        day, or hour). Glue Zero-ETL uses this parameter to correctly transform source data into timestamp
         *        format before partitioning.
         *        </p>
         *        <p>
         *        Do not use high-cardinality columns with the <code>identity</code> partition function.
         *        High-cardinality columns include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Primary keys
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Timestamp fields (such as <code>LastModifiedTimestamp</code>, <code>CreatedDate</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        System-generated timestamps
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Using high-cardinality columns with identity partitioning creates many small partitions, which can
         *        significantly degrade ingestion performance.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionSpec(String conversionSpec);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String functionSpec;

        private String conversionSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationPartition model) {
            fieldName(model.fieldName);
            functionSpec(model.functionSpec);
            conversionSpec(model.conversionSpec);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getFunctionSpec() {
            return functionSpec;
        }

        public final void setFunctionSpec(String functionSpec) {
            this.functionSpec = functionSpec;
        }

        @Override
        public final Builder functionSpec(String functionSpec) {
            this.functionSpec = functionSpec;
            return this;
        }

        public final String getConversionSpec() {
            return conversionSpec;
        }

        public final void setConversionSpec(String conversionSpec) {
            this.conversionSpec = conversionSpec;
        }

        @Override
        public final Builder conversionSpec(String conversionSpec) {
            this.conversionSpec = conversionSpec;
            return this;
        }

        @Override
        public IntegrationPartition build() {
            return new IntegrationPartition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
