/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCrawlsRequest extends GlueRequest implements
        ToCopyableBuilder<ListCrawlsRequest.Builder, ListCrawlsRequest> {
    private static final SdkField<String> CRAWLER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrawlerName").getter(getter(ListCrawlsRequest::crawlerName)).setter(setter(Builder::crawlerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCrawlsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<CrawlsFilter>> FILTERS_FIELD = SdkField
            .<List<CrawlsFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListCrawlsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CrawlsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CrawlsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCrawlsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_NAME_FIELD,
            MAX_RESULTS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String crawlerName;

    private final Integer maxResults;

    private final List<CrawlsFilter> filters;

    private final String nextToken;

    private ListCrawlsRequest(BuilderImpl builder) {
        super(builder);
        this.crawlerName = builder.crawlerName;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the crawler whose runs you want to retrieve.
     * </p>
     * 
     * @return The name of the crawler whose runs you want to retrieve.
     */
    public final String crawlerName() {
        return crawlerName;
    }

    /**
     * <p>
     * The maximum number of results to return. The default is 20, and maximum is 100.
     * </p>
     * 
     * @return The maximum number of results to return. The default is 20, and maximum is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the crawls by the criteria you specify in a list of <code>CrawlsFilter</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Filters the crawls by the criteria you specify in a list of <code>CrawlsFilter</code> objects.
     */
    public final List<CrawlsFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crawlerName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCrawlsRequest)) {
            return false;
        }
        ListCrawlsRequest other = (ListCrawlsRequest) obj;
        return Objects.equals(crawlerName(), other.crawlerName()) && Objects.equals(maxResults(), other.maxResults())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCrawlsRequest").add("CrawlerName", crawlerName()).add("MaxResults", maxResults())
                .add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlerName":
            return Optional.ofNullable(clazz.cast(crawlerName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CrawlerName", CRAWLER_NAME_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCrawlsRequest, T> g) {
        return obj -> g.apply((ListCrawlsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCrawlsRequest> {
        /**
         * <p>
         * The name of the crawler whose runs you want to retrieve.
         * </p>
         * 
         * @param crawlerName
         *        The name of the crawler whose runs you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerName(String crawlerName);

        /**
         * <p>
         * The maximum number of results to return. The default is 20, and maximum is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return. The default is 20, and maximum is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters the crawls by the criteria you specify in a list of <code>CrawlsFilter</code> objects.
         * </p>
         * 
         * @param filters
         *        Filters the crawls by the criteria you specify in a list of <code>CrawlsFilter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<CrawlsFilter> filters);

        /**
         * <p>
         * Filters the crawls by the criteria you specify in a list of <code>CrawlsFilter</code> objects.
         * </p>
         * 
         * @param filters
         *        Filters the crawls by the criteria you specify in a list of <code>CrawlsFilter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(CrawlsFilter... filters);

        /**
         * <p>
         * Filters the crawls by the criteria you specify in a list of <code>CrawlsFilter</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.CrawlsFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.CrawlsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.CrawlsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<CrawlsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.CrawlsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<CrawlsFilter>)
         */
        Builder filters(Consumer<CrawlsFilter.Builder>... filters);

        /**
         * <p>
         * A continuation token, if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String crawlerName;

        private Integer maxResults;

        private List<CrawlsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCrawlsRequest model) {
            super(model);
            crawlerName(model.crawlerName);
            maxResults(model.maxResults);
            filters(model.filters);
            nextToken(model.nextToken);
        }

        public final String getCrawlerName() {
            return crawlerName;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        @Override
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<CrawlsFilter.Builder> getFilters() {
            List<CrawlsFilter.Builder> result = CrawlsFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<CrawlsFilter.BuilderImpl> filters) {
            this.filters = CrawlsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<CrawlsFilter> filters) {
            this.filters = CrawlsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(CrawlsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<CrawlsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> CrawlsFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCrawlsRequest build() {
            return new ListCrawlsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
