/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an optimizer associated with a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableOptimizer implements SdkPojo, Serializable, ToCopyableBuilder<TableOptimizer.Builder, TableOptimizer> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(TableOptimizer::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<TableOptimizerConfiguration> CONFIGURATION_FIELD = SdkField
            .<TableOptimizerConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(TableOptimizer::configuration)).setter(setter(Builder::configuration))
            .constructor(TableOptimizerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<TableOptimizerRun> LAST_RUN_FIELD = SdkField
            .<TableOptimizerRun> builder(MarshallingType.SDK_POJO).memberName("lastRun").getter(getter(TableOptimizer::lastRun))
            .setter(setter(Builder::lastRun)).constructor(TableOptimizerRun::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            CONFIGURATION_FIELD, LAST_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final TableOptimizerConfiguration configuration;

    private final TableOptimizerRun lastRun;

    private TableOptimizer(BuilderImpl builder) {
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.lastRun = builder.lastRun;
    }

    /**
     * <p>
     * The type of table optimizer. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>compaction</code>: for managing compaction with a table optimizer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>retention</code>: for managing the retention of snapshot with a table optimizer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>orphan_file_deletion</code>: for managing the deletion of orphan files with a table optimizer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableOptimizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of table optimizer. The valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>compaction</code>: for managing compaction with a table optimizer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>retention</code>: for managing the retention of snapshot with a table optimizer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>orphan_file_deletion</code>: for managing the deletion of orphan files with a table optimizer.
     *         </p>
     *         </li>
     * @see TableOptimizerType
     */
    public final TableOptimizerType type() {
        return TableOptimizerType.fromValue(type);
    }

    /**
     * <p>
     * The type of table optimizer. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>compaction</code>: for managing compaction with a table optimizer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>retention</code>: for managing the retention of snapshot with a table optimizer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>orphan_file_deletion</code>: for managing the deletion of orphan files with a table optimizer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableOptimizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of table optimizer. The valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>compaction</code>: for managing compaction with a table optimizer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>retention</code>: for managing the retention of snapshot with a table optimizer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>orphan_file_deletion</code>: for managing the deletion of orphan files with a table optimizer.
     *         </p>
     *         </li>
     * @see TableOptimizerType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A <code>TableOptimizerConfiguration</code> object that was specified when creating or updating a table optimizer.
     * </p>
     * 
     * @return A <code>TableOptimizerConfiguration</code> object that was specified when creating or updating a table
     *         optimizer.
     */
    public final TableOptimizerConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * A <code>TableOptimizerRun</code> object representing the last run of the table optimizer.
     * </p>
     * 
     * @return A <code>TableOptimizerRun</code> object representing the last run of the table optimizer.
     */
    public final TableOptimizerRun lastRun() {
        return lastRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(lastRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptimizer)) {
            return false;
        }
        TableOptimizer other = (TableOptimizer) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(lastRun(), other.lastRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableOptimizer").add("Type", typeAsString()).add("Configuration", configuration())
                .add("LastRun", lastRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "lastRun":
            return Optional.ofNullable(clazz.cast(lastRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("lastRun", LAST_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableOptimizer, T> g) {
        return obj -> g.apply((TableOptimizer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableOptimizer> {
        /**
         * <p>
         * The type of table optimizer. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>compaction</code>: for managing compaction with a table optimizer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>retention</code>: for managing the retention of snapshot with a table optimizer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>orphan_file_deletion</code>: for managing the deletion of orphan files with a table optimizer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of table optimizer. The valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>compaction</code>: for managing compaction with a table optimizer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>retention</code>: for managing the retention of snapshot with a table optimizer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>orphan_file_deletion</code>: for managing the deletion of orphan files with a table optimizer.
         *        </p>
         *        </li>
         * @see TableOptimizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableOptimizerType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of table optimizer. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>compaction</code>: for managing compaction with a table optimizer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>retention</code>: for managing the retention of snapshot with a table optimizer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>orphan_file_deletion</code>: for managing the deletion of orphan files with a table optimizer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of table optimizer. The valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>compaction</code>: for managing compaction with a table optimizer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>retention</code>: for managing the retention of snapshot with a table optimizer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>orphan_file_deletion</code>: for managing the deletion of orphan files with a table optimizer.
         *        </p>
         *        </li>
         * @see TableOptimizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableOptimizerType
         */
        Builder type(TableOptimizerType type);

        /**
         * <p>
         * A <code>TableOptimizerConfiguration</code> object that was specified when creating or updating a table
         * optimizer.
         * </p>
         * 
         * @param configuration
         *        A <code>TableOptimizerConfiguration</code> object that was specified when creating or updating a table
         *        optimizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(TableOptimizerConfiguration configuration);

        /**
         * <p>
         * A <code>TableOptimizerConfiguration</code> object that was specified when creating or updating a table
         * optimizer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableOptimizerConfiguration.Builder}
         * avoiding the need to create one manually via {@link TableOptimizerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableOptimizerConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(TableOptimizerConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link TableOptimizerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(TableOptimizerConfiguration)
         */
        default Builder configuration(Consumer<TableOptimizerConfiguration.Builder> configuration) {
            return configuration(TableOptimizerConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * A <code>TableOptimizerRun</code> object representing the last run of the table optimizer.
         * </p>
         * 
         * @param lastRun
         *        A <code>TableOptimizerRun</code> object representing the last run of the table optimizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRun(TableOptimizerRun lastRun);

        /**
         * <p>
         * A <code>TableOptimizerRun</code> object representing the last run of the table optimizer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableOptimizerRun.Builder} avoiding the
         * need to create one manually via {@link TableOptimizerRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableOptimizerRun.Builder#build()} is called immediately and its
         * result is passed to {@link #lastRun(TableOptimizerRun)}.
         * 
         * @param lastRun
         *        a consumer that will call methods on {@link TableOptimizerRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRun(TableOptimizerRun)
         */
        default Builder lastRun(Consumer<TableOptimizerRun.Builder> lastRun) {
            return lastRun(TableOptimizerRun.builder().applyMutation(lastRun).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private TableOptimizerConfiguration configuration;

        private TableOptimizerRun lastRun;

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptimizer model) {
            type(model.type);
            configuration(model.configuration);
            lastRun(model.lastRun);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TableOptimizerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TableOptimizerConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(TableOptimizerConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(TableOptimizerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final TableOptimizerRun.Builder getLastRun() {
            return lastRun != null ? lastRun.toBuilder() : null;
        }

        public final void setLastRun(TableOptimizerRun.BuilderImpl lastRun) {
            this.lastRun = lastRun != null ? lastRun.build() : null;
        }

        @Override
        public final Builder lastRun(TableOptimizerRun lastRun) {
            this.lastRun = lastRun;
            return this;
        }

        @Override
        public TableOptimizer build() {
            return new TableOptimizer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
