/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateTableRequest.Builder, UpdateTableRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(UpdateTableRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(UpdateTableRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<TableInput> TABLE_INPUT_FIELD = SdkField.<TableInput> builder(MarshallingType.SDK_POJO)
            .memberName("TableInput").getter(getter(UpdateTableRequest::tableInput)).setter(setter(Builder::tableInput))
            .constructor(TableInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableInput").build()).build();

    private static final SdkField<Boolean> SKIP_ARCHIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SkipArchive").getter(getter(UpdateTableRequest::skipArchive)).setter(setter(Builder::skipArchive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipArchive").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(UpdateTableRequest::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(UpdateTableRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<String> VIEW_UPDATE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewUpdateAction").getter(getter(UpdateTableRequest::viewUpdateActionAsString))
            .setter(setter(Builder::viewUpdateAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewUpdateAction").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Force")
            .getter(getter(UpdateTableRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_INPUT_FIELD, SKIP_ARCHIVE_FIELD, TRANSACTION_ID_FIELD, VERSION_ID_FIELD,
            VIEW_UPDATE_ACTION_FIELD, FORCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogId;

    private final String databaseName;

    private final TableInput tableInput;

    private final Boolean skipArchive;

    private final String transactionId;

    private final String versionId;

    private final String viewUpdateAction;

    private final Boolean force;

    private UpdateTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableInput = builder.tableInput;
        this.skipArchive = builder.skipArchive;
        this.transactionId = builder.transactionId;
        this.versionId = builder.versionId;
        this.viewUpdateAction = builder.viewUpdateAction;
        this.force = builder.force;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account ID is
     * used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
     *         ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the catalog database in which the table resides. For Hive compatibility, this name is entirely
     * lowercase.
     * </p>
     * 
     * @return The name of the catalog database in which the table resides. For Hive compatibility, this name is
     *         entirely lowercase.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * An updated <code>TableInput</code> object to define the metadata table in the catalog.
     * </p>
     * 
     * @return An updated <code>TableInput</code> object to define the metadata table in the catalog.
     */
    public final TableInput tableInput() {
        return tableInput;
    }

    /**
     * <p>
     * By default, <code>UpdateTable</code> always creates an archived version of the table before updating it. However,
     * if <code>skipArchive</code> is set to true, <code>UpdateTable</code> does not create the archived version.
     * </p>
     * 
     * @return By default, <code>UpdateTable</code> always creates an archived version of the table before updating it.
     *         However, if <code>skipArchive</code> is set to true, <code>UpdateTable</code> does not create the
     *         archived version.
     */
    public final Boolean skipArchive() {
        return skipArchive;
    }

    /**
     * <p>
     * The transaction ID at which to update the table contents.
     * </p>
     * 
     * @return The transaction ID at which to update the table contents.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The version ID at which to update the table contents.
     * </p>
     * 
     * @return The version ID at which to update the table contents.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The operation to be performed when updating the view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #viewUpdateAction}
     * will return {@link ViewUpdateAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #viewUpdateActionAsString}.
     * </p>
     * 
     * @return The operation to be performed when updating the view.
     * @see ViewUpdateAction
     */
    public final ViewUpdateAction viewUpdateAction() {
        return ViewUpdateAction.fromValue(viewUpdateAction);
    }

    /**
     * <p>
     * The operation to be performed when updating the view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #viewUpdateAction}
     * will return {@link ViewUpdateAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #viewUpdateActionAsString}.
     * </p>
     * 
     * @return The operation to be performed when updating the view.
     * @see ViewUpdateAction
     */
    public final String viewUpdateActionAsString() {
        return viewUpdateAction;
    }

    /**
     * <p>
     * A flag that can be set to true to ignore matching storage descriptor and subobject matching requirements.
     * </p>
     * 
     * @return A flag that can be set to true to ignore matching storage descriptor and subobject matching requirements.
     */
    public final Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableInput());
        hashCode = 31 * hashCode + Objects.hashCode(skipArchive());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(viewUpdateActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableInput(), other.tableInput()) && Objects.equals(skipArchive(), other.skipArchive())
                && Objects.equals(transactionId(), other.transactionId()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(viewUpdateActionAsString(), other.viewUpdateActionAsString())
                && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableInput", tableInput()).add("SkipArchive", skipArchive()).add("TransactionId", transactionId())
                .add("VersionId", versionId()).add("ViewUpdateAction", viewUpdateActionAsString()).add("Force", force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableInput":
            return Optional.ofNullable(clazz.cast(tableInput()));
        case "SkipArchive":
            return Optional.ofNullable(clazz.cast(skipArchive()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "ViewUpdateAction":
            return Optional.ofNullable(clazz.cast(viewUpdateActionAsString()));
        case "Force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableInput", TABLE_INPUT_FIELD);
        map.put("SkipArchive", SKIP_ARCHIVE_FIELD);
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("ViewUpdateAction", VIEW_UPDATE_ACTION_FIELD);
        map.put("Force", FORCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableRequest, T> g) {
        return obj -> g.apply((UpdateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTableRequest> {
        /**
         * <p>
         * The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account ID
         * is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services
         *        account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the catalog database in which the table resides. For Hive compatibility, this name is entirely
         * lowercase.
         * </p>
         * 
         * @param databaseName
         *        The name of the catalog database in which the table resides. For Hive compatibility, this name is
         *        entirely lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * An updated <code>TableInput</code> object to define the metadata table in the catalog.
         * </p>
         * 
         * @param tableInput
         *        An updated <code>TableInput</code> object to define the metadata table in the catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableInput(TableInput tableInput);

        /**
         * <p>
         * An updated <code>TableInput</code> object to define the metadata table in the catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableInput.Builder} avoiding the need to
         * create one manually via {@link TableInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableInput.Builder#build()} is called immediately and its result
         * is passed to {@link #tableInput(TableInput)}.
         * 
         * @param tableInput
         *        a consumer that will call methods on {@link TableInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableInput(TableInput)
         */
        default Builder tableInput(Consumer<TableInput.Builder> tableInput) {
            return tableInput(TableInput.builder().applyMutation(tableInput).build());
        }

        /**
         * <p>
         * By default, <code>UpdateTable</code> always creates an archived version of the table before updating it.
         * However, if <code>skipArchive</code> is set to true, <code>UpdateTable</code> does not create the archived
         * version.
         * </p>
         * 
         * @param skipArchive
         *        By default, <code>UpdateTable</code> always creates an archived version of the table before updating
         *        it. However, if <code>skipArchive</code> is set to true, <code>UpdateTable</code> does not create the
         *        archived version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipArchive(Boolean skipArchive);

        /**
         * <p>
         * The transaction ID at which to update the table contents.
         * </p>
         * 
         * @param transactionId
         *        The transaction ID at which to update the table contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The version ID at which to update the table contents.
         * </p>
         * 
         * @param versionId
         *        The version ID at which to update the table contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The operation to be performed when updating the view.
         * </p>
         * 
         * @param viewUpdateAction
         *        The operation to be performed when updating the view.
         * @see ViewUpdateAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewUpdateAction
         */
        Builder viewUpdateAction(String viewUpdateAction);

        /**
         * <p>
         * The operation to be performed when updating the view.
         * </p>
         * 
         * @param viewUpdateAction
         *        The operation to be performed when updating the view.
         * @see ViewUpdateAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewUpdateAction
         */
        Builder viewUpdateAction(ViewUpdateAction viewUpdateAction);

        /**
         * <p>
         * A flag that can be set to true to ignore matching storage descriptor and subobject matching requirements.
         * </p>
         * 
         * @param force
         *        A flag that can be set to true to ignore matching storage descriptor and subobject matching
         *        requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private TableInput tableInput;

        private Boolean skipArchive;

        private String transactionId;

        private String versionId;

        private String viewUpdateAction;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableInput(model.tableInput);
            skipArchive(model.skipArchive);
            transactionId(model.transactionId);
            versionId(model.versionId);
            viewUpdateAction(model.viewUpdateAction);
            force(model.force);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final TableInput.Builder getTableInput() {
            return tableInput != null ? tableInput.toBuilder() : null;
        }

        public final void setTableInput(TableInput.BuilderImpl tableInput) {
            this.tableInput = tableInput != null ? tableInput.build() : null;
        }

        @Override
        public final Builder tableInput(TableInput tableInput) {
            this.tableInput = tableInput;
            return this;
        }

        public final Boolean getSkipArchive() {
            return skipArchive;
        }

        public final void setSkipArchive(Boolean skipArchive) {
            this.skipArchive = skipArchive;
        }

        @Override
        public final Builder skipArchive(Boolean skipArchive) {
            this.skipArchive = skipArchive;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getViewUpdateAction() {
            return viewUpdateAction;
        }

        public final void setViewUpdateAction(String viewUpdateAction) {
            this.viewUpdateAction = viewUpdateAction;
        }

        @Override
        public final Builder viewUpdateAction(String viewUpdateAction) {
            this.viewUpdateAction = viewUpdateAction;
            return this;
        }

        @Override
        public final Builder viewUpdateAction(ViewUpdateAction viewUpdateAction) {
            this.viewUpdateAction(viewUpdateAction == null ? null : viewUpdateAction.toString());
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
