/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListRegistriesRequest;
import software.amazon.awssdk.services.glue.model.ListRegistriesResponse;
import software.amazon.awssdk.services.glue.model.RegistryListItem;

public class ListRegistriesPublisher
implements SdkPublisher<ListRegistriesResponse> {
    private final GlueAsyncClient client;
    private final ListRegistriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRegistriesPublisher(GlueAsyncClient client, ListRegistriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRegistriesPublisher(GlueAsyncClient client, ListRegistriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRegistriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRegistriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegistryListItem> registries() {
        Function<ListRegistriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.registries() != null) {
                return response.registries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRegistriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRegistriesResponseFetcher
    implements AsyncPageFetcher<ListRegistriesResponse> {
        private ListRegistriesResponseFetcher() {
        }

        public boolean hasNextPage(ListRegistriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRegistriesResponse> nextPage(ListRegistriesResponse previousPage) {
            if (previousPage == null) {
                return ListRegistriesPublisher.this.client.listRegistries(ListRegistriesPublisher.this.firstRequest);
            }
            return ListRegistriesPublisher.this.client.listRegistries((ListRegistriesRequest)((Object)ListRegistriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

