/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnRowFilter;
import software.amazon.awssdk.services.glue.model.ColumnRowFilterListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.NameStringListCopier;
import software.amazon.awssdk.services.glue.model.Permission;
import software.amazon.awssdk.services.glue.model.PermissionListCopier;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUnfilteredTableMetadataResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetUnfilteredTableMetadataResponse> {
    private static final SdkField<Table> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Table").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::table)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::table)).constructor(Table::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedColumns").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::authorizedColumns)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::authorizedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_REGISTERED_WITH_LAKE_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsRegisteredWithLakeFormation").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::isRegisteredWithLakeFormation)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::isRegisteredWithLakeFormation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRegisteredWithLakeFormation").build()}).build();
    private static final SdkField<List<ColumnRowFilter>> CELL_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CellFilters").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::cellFilters)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::cellFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnRowFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> QUERY_AUTHORIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryAuthorizationId").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::queryAuthorizationId)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::queryAuthorizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAuthorizationId").build()}).build();
    private static final SdkField<Boolean> IS_MULTI_DIALECT_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsMultiDialectView").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::isMultiDialectView)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::isMultiDialectView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMultiDialectView").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::resourceArn)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Boolean> IS_PROTECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsProtected").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::isProtected)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::isProtected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsProtected").build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::permissionsAsStrings)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::permissionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROW_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RowFilter").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::rowFilter)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::rowFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_FIELD, AUTHORIZED_COLUMNS_FIELD, IS_REGISTERED_WITH_LAKE_FORMATION_FIELD, CELL_FILTERS_FIELD, QUERY_AUTHORIZATION_ID_FIELD, IS_MULTI_DIALECT_VIEW_FIELD, RESOURCE_ARN_FIELD, IS_PROTECTED_FIELD, PERMISSIONS_FIELD, ROW_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUnfilteredTableMetadataResponse.memberNameToFieldInitializer();
    private final Table table;
    private final List<String> authorizedColumns;
    private final Boolean isRegisteredWithLakeFormation;
    private final List<ColumnRowFilter> cellFilters;
    private final String queryAuthorizationId;
    private final Boolean isMultiDialectView;
    private final String resourceArn;
    private final Boolean isProtected;
    private final List<String> permissions;
    private final String rowFilter;

    private GetUnfilteredTableMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.table = builder.table;
        this.authorizedColumns = builder.authorizedColumns;
        this.isRegisteredWithLakeFormation = builder.isRegisteredWithLakeFormation;
        this.cellFilters = builder.cellFilters;
        this.queryAuthorizationId = builder.queryAuthorizationId;
        this.isMultiDialectView = builder.isMultiDialectView;
        this.resourceArn = builder.resourceArn;
        this.isProtected = builder.isProtected;
        this.permissions = builder.permissions;
        this.rowFilter = builder.rowFilter;
    }

    public final Table table() {
        return this.table;
    }

    public final boolean hasAuthorizedColumns() {
        return this.authorizedColumns != null && !(this.authorizedColumns instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedColumns() {
        return this.authorizedColumns;
    }

    public final Boolean isRegisteredWithLakeFormation() {
        return this.isRegisteredWithLakeFormation;
    }

    public final boolean hasCellFilters() {
        return this.cellFilters != null && !(this.cellFilters instanceof SdkAutoConstructList);
    }

    public final List<ColumnRowFilter> cellFilters() {
        return this.cellFilters;
    }

    public final String queryAuthorizationId() {
        return this.queryAuthorizationId;
    }

    public final Boolean isMultiDialectView() {
        return this.isMultiDialectView;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Boolean isProtected() {
        return this.isProtected;
    }

    public final List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(this.permissions);
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissionsAsStrings() {
        return this.permissions;
    }

    public final String rowFilter() {
        return this.rowFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedColumns() ? this.authorizedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isRegisteredWithLakeFormation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCellFilters() ? this.cellFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAuthorizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMultiDialectView());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.isProtected());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rowFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredTableMetadataResponse)) {
            return false;
        }
        GetUnfilteredTableMetadataResponse other = (GetUnfilteredTableMetadataResponse)((Object)obj);
        return Objects.equals(this.table(), other.table()) && this.hasAuthorizedColumns() == other.hasAuthorizedColumns() && Objects.equals(this.authorizedColumns(), other.authorizedColumns()) && Objects.equals(this.isRegisteredWithLakeFormation(), other.isRegisteredWithLakeFormation()) && this.hasCellFilters() == other.hasCellFilters() && Objects.equals(this.cellFilters(), other.cellFilters()) && Objects.equals(this.queryAuthorizationId(), other.queryAuthorizationId()) && Objects.equals(this.isMultiDialectView(), other.isMultiDialectView()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.isProtected(), other.isProtected()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissionsAsStrings(), other.permissionsAsStrings()) && Objects.equals(this.rowFilter(), other.rowFilter());
    }

    public final String toString() {
        return ToString.builder((String)"GetUnfilteredTableMetadataResponse").add("Table", (Object)this.table()).add("AuthorizedColumns", this.hasAuthorizedColumns() ? this.authorizedColumns() : null).add("IsRegisteredWithLakeFormation", (Object)this.isRegisteredWithLakeFormation()).add("CellFilters", this.hasCellFilters() ? this.cellFilters() : null).add("QueryAuthorizationId", (Object)this.queryAuthorizationId()).add("IsMultiDialectView", (Object)this.isMultiDialectView()).add("ResourceArn", (Object)this.resourceArn()).add("IsProtected", (Object)this.isProtected()).add("Permissions", this.hasPermissions() ? this.permissionsAsStrings() : null).add("RowFilter", (Object)this.rowFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "AuthorizedColumns": {
                return Optional.ofNullable(clazz.cast(this.authorizedColumns()));
            }
            case "IsRegisteredWithLakeFormation": {
                return Optional.ofNullable(clazz.cast(this.isRegisteredWithLakeFormation()));
            }
            case "CellFilters": {
                return Optional.ofNullable(clazz.cast(this.cellFilters()));
            }
            case "QueryAuthorizationId": {
                return Optional.ofNullable(clazz.cast(this.queryAuthorizationId()));
            }
            case "IsMultiDialectView": {
                return Optional.ofNullable(clazz.cast(this.isMultiDialectView()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "IsProtected": {
                return Optional.ofNullable(clazz.cast(this.isProtected()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsStrings()));
            }
            case "RowFilter": {
                return Optional.ofNullable(clazz.cast(this.rowFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Table", TABLE_FIELD);
        map.put("AuthorizedColumns", AUTHORIZED_COLUMNS_FIELD);
        map.put("IsRegisteredWithLakeFormation", IS_REGISTERED_WITH_LAKE_FORMATION_FIELD);
        map.put("CellFilters", CELL_FILTERS_FIELD);
        map.put("QueryAuthorizationId", QUERY_AUTHORIZATION_ID_FIELD);
        map.put("IsMultiDialectView", IS_MULTI_DIALECT_VIEW_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("IsProtected", IS_PROTECTED_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("RowFilter", ROW_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredTableMetadataResponse, T> g) {
        return obj -> g.apply((GetUnfilteredTableMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private Table table;
        private List<String> authorizedColumns = DefaultSdkAutoConstructList.getInstance();
        private Boolean isRegisteredWithLakeFormation;
        private List<ColumnRowFilter> cellFilters = DefaultSdkAutoConstructList.getInstance();
        private String queryAuthorizationId;
        private Boolean isMultiDialectView;
        private String resourceArn;
        private Boolean isProtected;
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();
        private String rowFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredTableMetadataResponse model) {
            super(model);
            this.table(model.table);
            this.authorizedColumns(model.authorizedColumns);
            this.isRegisteredWithLakeFormation(model.isRegisteredWithLakeFormation);
            this.cellFilters(model.cellFilters);
            this.queryAuthorizationId(model.queryAuthorizationId);
            this.isMultiDialectView(model.isMultiDialectView);
            this.resourceArn(model.resourceArn);
            this.isProtected(model.isProtected);
            this.permissionsWithStrings(model.permissions);
            this.rowFilter(model.rowFilter);
        }

        public final Table.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        public final void setTable(Table.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(Table table) {
            this.table = table;
            return this;
        }

        public final Collection<String> getAuthorizedColumns() {
            if (this.authorizedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedColumns;
        }

        public final void setAuthorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
        }

        @Override
        public final Builder authorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedColumns(String ... authorizedColumns) {
            this.authorizedColumns(Arrays.asList(authorizedColumns));
            return this;
        }

        public final Boolean getIsRegisteredWithLakeFormation() {
            return this.isRegisteredWithLakeFormation;
        }

        public final void setIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
        }

        @Override
        public final Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
            return this;
        }

        public final List<ColumnRowFilter.Builder> getCellFilters() {
            List<ColumnRowFilter.Builder> result = ColumnRowFilterListCopier.copyToBuilder(this.cellFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCellFilters(Collection<ColumnRowFilter.BuilderImpl> cellFilters) {
            this.cellFilters = ColumnRowFilterListCopier.copyFromBuilder(cellFilters);
        }

        @Override
        public final Builder cellFilters(Collection<ColumnRowFilter> cellFilters) {
            this.cellFilters = ColumnRowFilterListCopier.copy(cellFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellFilters(ColumnRowFilter ... cellFilters) {
            this.cellFilters(Arrays.asList(cellFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellFilters(Consumer<ColumnRowFilter.Builder> ... cellFilters) {
            this.cellFilters(Stream.of(cellFilters).map(c -> (ColumnRowFilter)((ColumnRowFilter.Builder)ColumnRowFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getQueryAuthorizationId() {
            return this.queryAuthorizationId;
        }

        public final void setQueryAuthorizationId(String queryAuthorizationId) {
            this.queryAuthorizationId = queryAuthorizationId;
        }

        @Override
        public final Builder queryAuthorizationId(String queryAuthorizationId) {
            this.queryAuthorizationId = queryAuthorizationId;
            return this;
        }

        public final Boolean getIsMultiDialectView() {
            return this.isMultiDialectView;
        }

        public final void setIsMultiDialectView(Boolean isMultiDialectView) {
            this.isMultiDialectView = isMultiDialectView;
        }

        @Override
        public final Builder isMultiDialectView(Boolean isMultiDialectView) {
            this.isMultiDialectView = isMultiDialectView;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Boolean getIsProtected() {
            return this.isProtected;
        }

        public final void setIsProtected(Boolean isProtected) {
            this.isProtected = isProtected;
        }

        @Override
        public final Builder isProtected(Boolean isProtected) {
            this.isProtected = isProtected;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String ... permissions) {
            this.permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final String getRowFilter() {
            return this.rowFilter;
        }

        public final void setRowFilter(String rowFilter) {
            this.rowFilter = rowFilter;
        }

        @Override
        public final Builder rowFilter(String rowFilter) {
            this.rowFilter = rowFilter;
            return this;
        }

        @Override
        public GetUnfilteredTableMetadataResponse build() {
            return new GetUnfilteredTableMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUnfilteredTableMetadataResponse> {
        public Builder table(Table var1);

        default public Builder table(Consumer<Table.Builder> table) {
            return this.table((Table)((Table.Builder)Table.builder().applyMutation(table)).build());
        }

        public Builder authorizedColumns(Collection<String> var1);

        public Builder authorizedColumns(String ... var1);

        public Builder isRegisteredWithLakeFormation(Boolean var1);

        public Builder cellFilters(Collection<ColumnRowFilter> var1);

        public Builder cellFilters(ColumnRowFilter ... var1);

        public Builder cellFilters(Consumer<ColumnRowFilter.Builder> ... var1);

        public Builder queryAuthorizationId(String var1);

        public Builder isMultiDialectView(Boolean var1);

        public Builder resourceArn(String var1);

        public Builder isProtected(Boolean var1);

        public Builder permissionsWithStrings(Collection<String> var1);

        public Builder permissionsWithStrings(String ... var1);

        public Builder permissions(Collection<Permission> var1);

        public Builder permissions(Permission ... var1);

        public Builder rowFilter(String var1);
    }
}

