/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ViewRepresentation;
import software.amazon.awssdk.services.glue.model.ViewRepresentationListCopier;
import software.amazon.awssdk.services.glue.model.ViewSubObjectsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewDefinition> {
    private static final SdkField<Boolean> IS_PROTECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsProtected").getter(ViewDefinition.getter(ViewDefinition::isProtected)).setter(ViewDefinition.setter(Builder::isProtected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsProtected").build()}).build();
    private static final SdkField<String> DEFINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Definer").getter(ViewDefinition.getter(ViewDefinition::definer)).setter(ViewDefinition.setter(Builder::definer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definer").build()}).build();
    private static final SdkField<List<String>> SUB_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubObjects").getter(ViewDefinition.getter(ViewDefinition::subObjects)).setter(ViewDefinition.setter(Builder::subObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ViewRepresentation>> REPRESENTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Representations").getter(ViewDefinition.getter(ViewDefinition::representations)).setter(ViewDefinition.setter(Builder::representations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Representations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ViewRepresentation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PROTECTED_FIELD, DEFINER_FIELD, SUB_OBJECTS_FIELD, REPRESENTATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ViewDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isProtected;
    private final String definer;
    private final List<String> subObjects;
    private final List<ViewRepresentation> representations;

    private ViewDefinition(BuilderImpl builder) {
        this.isProtected = builder.isProtected;
        this.definer = builder.definer;
        this.subObjects = builder.subObjects;
        this.representations = builder.representations;
    }

    public final Boolean isProtected() {
        return this.isProtected;
    }

    public final String definer() {
        return this.definer;
    }

    public final boolean hasSubObjects() {
        return this.subObjects != null && !(this.subObjects instanceof SdkAutoConstructList);
    }

    public final List<String> subObjects() {
        return this.subObjects;
    }

    public final boolean hasRepresentations() {
        return this.representations != null && !(this.representations instanceof SdkAutoConstructList);
    }

    public final List<ViewRepresentation> representations() {
        return this.representations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isProtected());
        hashCode = 31 * hashCode + Objects.hashCode(this.definer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubObjects() ? this.subObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepresentations() ? this.representations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewDefinition)) {
            return false;
        }
        ViewDefinition other = (ViewDefinition)obj;
        return Objects.equals(this.isProtected(), other.isProtected()) && Objects.equals(this.definer(), other.definer()) && this.hasSubObjects() == other.hasSubObjects() && Objects.equals(this.subObjects(), other.subObjects()) && this.hasRepresentations() == other.hasRepresentations() && Objects.equals(this.representations(), other.representations());
    }

    public final String toString() {
        return ToString.builder((String)"ViewDefinition").add("IsProtected", (Object)this.isProtected()).add("Definer", (Object)this.definer()).add("SubObjects", this.hasSubObjects() ? this.subObjects() : null).add("Representations", this.hasRepresentations() ? this.representations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsProtected": {
                return Optional.ofNullable(clazz.cast(this.isProtected()));
            }
            case "Definer": {
                return Optional.ofNullable(clazz.cast(this.definer()));
            }
            case "SubObjects": {
                return Optional.ofNullable(clazz.cast(this.subObjects()));
            }
            case "Representations": {
                return Optional.ofNullable(clazz.cast(this.representations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IsProtected", IS_PROTECTED_FIELD);
        map.put("Definer", DEFINER_FIELD);
        map.put("SubObjects", SUB_OBJECTS_FIELD);
        map.put("Representations", REPRESENTATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewDefinition, T> g) {
        return obj -> g.apply((ViewDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isProtected;
        private String definer;
        private List<String> subObjects = DefaultSdkAutoConstructList.getInstance();
        private List<ViewRepresentation> representations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ViewDefinition model) {
            this.isProtected(model.isProtected);
            this.definer(model.definer);
            this.subObjects(model.subObjects);
            this.representations(model.representations);
        }

        public final Boolean getIsProtected() {
            return this.isProtected;
        }

        public final void setIsProtected(Boolean isProtected) {
            this.isProtected = isProtected;
        }

        @Override
        public final Builder isProtected(Boolean isProtected) {
            this.isProtected = isProtected;
            return this;
        }

        public final String getDefiner() {
            return this.definer;
        }

        public final void setDefiner(String definer) {
            this.definer = definer;
        }

        @Override
        public final Builder definer(String definer) {
            this.definer = definer;
            return this;
        }

        public final Collection<String> getSubObjects() {
            if (this.subObjects instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subObjects;
        }

        public final void setSubObjects(Collection<String> subObjects) {
            this.subObjects = ViewSubObjectsListCopier.copy(subObjects);
        }

        @Override
        public final Builder subObjects(Collection<String> subObjects) {
            this.subObjects = ViewSubObjectsListCopier.copy(subObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subObjects(String ... subObjects) {
            this.subObjects(Arrays.asList(subObjects));
            return this;
        }

        public final List<ViewRepresentation.Builder> getRepresentations() {
            List<ViewRepresentation.Builder> result = ViewRepresentationListCopier.copyToBuilder(this.representations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepresentations(Collection<ViewRepresentation.BuilderImpl> representations) {
            this.representations = ViewRepresentationListCopier.copyFromBuilder(representations);
        }

        @Override
        public final Builder representations(Collection<ViewRepresentation> representations) {
            this.representations = ViewRepresentationListCopier.copy(representations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder representations(ViewRepresentation ... representations) {
            this.representations(Arrays.asList(representations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder representations(Consumer<ViewRepresentation.Builder> ... representations) {
            this.representations(Stream.of(representations).map(c -> (ViewRepresentation)((ViewRepresentation.Builder)ViewRepresentation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ViewDefinition build() {
            return new ViewDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewDefinition> {
        public Builder isProtected(Boolean var1);

        public Builder definer(String var1);

        public Builder subObjects(Collection<String> var1);

        public Builder subObjects(String ... var1);

        public Builder representations(Collection<ViewRepresentation> var1);

        public Builder representations(ViewRepresentation ... var1);

        public Builder representations(Consumer<ViewRepresentation.Builder> ... var1);
    }
}

