/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.glue.internal.GlueServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.glue.model.AccessDeniedException;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetBlueprintsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetBlueprintsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetCustomEntityTypesRequest;
import software.amazon.awssdk.services.glue.model.BatchGetCustomEntityTypesResponse;
import software.amazon.awssdk.services.glue.model.BatchGetDataQualityResultRequest;
import software.amazon.awssdk.services.glue.model.BatchGetDataQualityResultResponse;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetJobsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetJobsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.BatchPutDataQualityStatisticAnnotationRequest;
import software.amazon.awssdk.services.glue.model.BatchPutDataQualityStatisticAnnotationResponse;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunRequest;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunResponse;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.CancelDataQualityRuleRecommendationRunRequest;
import software.amazon.awssdk.services.glue.model.CancelDataQualityRuleRecommendationRunResponse;
import software.amazon.awssdk.services.glue.model.CancelDataQualityRulesetEvaluationRunRequest;
import software.amazon.awssdk.services.glue.model.CancelDataQualityRulesetEvaluationRunResponse;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.CancelStatementRequest;
import software.amazon.awssdk.services.glue.model.CancelStatementResponse;
import software.amazon.awssdk.services.glue.model.CheckSchemaVersionValidityRequest;
import software.amazon.awssdk.services.glue.model.CheckSchemaVersionValidityResponse;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskNotRunningException;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskRunningException;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskStoppingException;
import software.amazon.awssdk.services.glue.model.ConcurrentModificationException;
import software.amazon.awssdk.services.glue.model.ConcurrentRunsExceededException;
import software.amazon.awssdk.services.glue.model.ConditionCheckFailureException;
import software.amazon.awssdk.services.glue.model.ConflictException;
import software.amazon.awssdk.services.glue.model.CrawlerNotRunningException;
import software.amazon.awssdk.services.glue.model.CrawlerRunningException;
import software.amazon.awssdk.services.glue.model.CrawlerStoppingException;
import software.amazon.awssdk.services.glue.model.CreateBlueprintRequest;
import software.amazon.awssdk.services.glue.model.CreateBlueprintResponse;
import software.amazon.awssdk.services.glue.model.CreateCatalogRequest;
import software.amazon.awssdk.services.glue.model.CreateCatalogResponse;
import software.amazon.awssdk.services.glue.model.CreateClassifierRequest;
import software.amazon.awssdk.services.glue.model.CreateClassifierResponse;
import software.amazon.awssdk.services.glue.model.CreateColumnStatisticsTaskSettingsRequest;
import software.amazon.awssdk.services.glue.model.CreateColumnStatisticsTaskSettingsResponse;
import software.amazon.awssdk.services.glue.model.CreateConnectionRequest;
import software.amazon.awssdk.services.glue.model.CreateConnectionResponse;
import software.amazon.awssdk.services.glue.model.CreateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.CreateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.CreateCustomEntityTypeRequest;
import software.amazon.awssdk.services.glue.model.CreateCustomEntityTypeResponse;
import software.amazon.awssdk.services.glue.model.CreateDataQualityRulesetRequest;
import software.amazon.awssdk.services.glue.model.CreateDataQualityRulesetResponse;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.CreateIntegrationRequest;
import software.amazon.awssdk.services.glue.model.CreateIntegrationResourcePropertyRequest;
import software.amazon.awssdk.services.glue.model.CreateIntegrationResourcePropertyResponse;
import software.amazon.awssdk.services.glue.model.CreateIntegrationResponse;
import software.amazon.awssdk.services.glue.model.CreateIntegrationTablePropertiesRequest;
import software.amazon.awssdk.services.glue.model.CreateIntegrationTablePropertiesResponse;
import software.amazon.awssdk.services.glue.model.CreateJobRequest;
import software.amazon.awssdk.services.glue.model.CreateJobResponse;
import software.amazon.awssdk.services.glue.model.CreateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.CreateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.CreatePartitionIndexRequest;
import software.amazon.awssdk.services.glue.model.CreatePartitionIndexResponse;
import software.amazon.awssdk.services.glue.model.CreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.CreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.CreateRegistryRequest;
import software.amazon.awssdk.services.glue.model.CreateRegistryResponse;
import software.amazon.awssdk.services.glue.model.CreateSchemaRequest;
import software.amazon.awssdk.services.glue.model.CreateSchemaResponse;
import software.amazon.awssdk.services.glue.model.CreateScriptRequest;
import software.amazon.awssdk.services.glue.model.CreateScriptResponse;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.CreateSessionRequest;
import software.amazon.awssdk.services.glue.model.CreateSessionResponse;
import software.amazon.awssdk.services.glue.model.CreateTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.CreateTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateTableResponse;
import software.amazon.awssdk.services.glue.model.CreateTriggerRequest;
import software.amazon.awssdk.services.glue.model.CreateTriggerResponse;
import software.amazon.awssdk.services.glue.model.CreateUsageProfileRequest;
import software.amazon.awssdk.services.glue.model.CreateUsageProfileResponse;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.glue.model.DeleteBlueprintRequest;
import software.amazon.awssdk.services.glue.model.DeleteBlueprintResponse;
import software.amazon.awssdk.services.glue.model.DeleteCatalogRequest;
import software.amazon.awssdk.services.glue.model.DeleteCatalogResponse;
import software.amazon.awssdk.services.glue.model.DeleteClassifierRequest;
import software.amazon.awssdk.services.glue.model.DeleteClassifierResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsTaskSettingsRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsTaskSettingsResponse;
import software.amazon.awssdk.services.glue.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerRequest;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerResponse;
import software.amazon.awssdk.services.glue.model.DeleteCustomEntityTypeRequest;
import software.amazon.awssdk.services.glue.model.DeleteCustomEntityTypeResponse;
import software.amazon.awssdk.services.glue.model.DeleteDataQualityRulesetRequest;
import software.amazon.awssdk.services.glue.model.DeleteDataQualityRulesetResponse;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.glue.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.glue.model.DeleteIntegrationTablePropertiesRequest;
import software.amazon.awssdk.services.glue.model.DeleteIntegrationTablePropertiesResponse;
import software.amazon.awssdk.services.glue.model.DeleteJobRequest;
import software.amazon.awssdk.services.glue.model.DeleteJobResponse;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformRequest;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformResponse;
import software.amazon.awssdk.services.glue.model.DeletePartitionIndexRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionIndexResponse;
import software.amazon.awssdk.services.glue.model.DeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.DeleteRegistryRequest;
import software.amazon.awssdk.services.glue.model.DeleteRegistryResponse;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.glue.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.glue.model.DeleteSchemaVersionsRequest;
import software.amazon.awssdk.services.glue.model.DeleteSchemaVersionsResponse;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.DeleteSessionRequest;
import software.amazon.awssdk.services.glue.model.DeleteSessionResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.DeleteTriggerRequest;
import software.amazon.awssdk.services.glue.model.DeleteTriggerResponse;
import software.amazon.awssdk.services.glue.model.DeleteUsageProfileRequest;
import software.amazon.awssdk.services.glue.model.DeleteUsageProfileResponse;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.glue.model.DescribeConnectionTypeRequest;
import software.amazon.awssdk.services.glue.model.DescribeConnectionTypeResponse;
import software.amazon.awssdk.services.glue.model.DescribeEntityRequest;
import software.amazon.awssdk.services.glue.model.DescribeEntityResponse;
import software.amazon.awssdk.services.glue.model.DescribeInboundIntegrationsRequest;
import software.amazon.awssdk.services.glue.model.DescribeInboundIntegrationsResponse;
import software.amazon.awssdk.services.glue.model.DescribeIntegrationsRequest;
import software.amazon.awssdk.services.glue.model.DescribeIntegrationsResponse;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.FederatedResourceAlreadyExistsException;
import software.amazon.awssdk.services.glue.model.FederationSourceException;
import software.amazon.awssdk.services.glue.model.FederationSourceRetryableException;
import software.amazon.awssdk.services.glue.model.GetBlueprintRequest;
import software.amazon.awssdk.services.glue.model.GetBlueprintResponse;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunRequest;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunResponse;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunsResponse;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusRequest;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusResponse;
import software.amazon.awssdk.services.glue.model.GetCatalogRequest;
import software.amazon.awssdk.services.glue.model.GetCatalogResponse;
import software.amazon.awssdk.services.glue.model.GetCatalogsRequest;
import software.amazon.awssdk.services.glue.model.GetCatalogsResponse;
import software.amazon.awssdk.services.glue.model.GetClassifierRequest;
import software.amazon.awssdk.services.glue.model.GetClassifierResponse;
import software.amazon.awssdk.services.glue.model.GetClassifiersRequest;
import software.amazon.awssdk.services.glue.model.GetClassifiersResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskSettingsRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskSettingsResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionsRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.GetCustomEntityTypeRequest;
import software.amazon.awssdk.services.glue.model.GetCustomEntityTypeResponse;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityModelRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityModelResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityModelResultRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityModelResultResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityResultRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityResultResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityRuleRecommendationRunRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityRuleRecommendationRunResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityRulesetEvaluationRunRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityRulesetEvaluationRunResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityRulesetRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityRulesetResponse;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphRequest;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.GetEntityRecordsRequest;
import software.amazon.awssdk.services.glue.model.GetEntityRecordsResponse;
import software.amazon.awssdk.services.glue.model.GetIntegrationResourcePropertyRequest;
import software.amazon.awssdk.services.glue.model.GetIntegrationResourcePropertyResponse;
import software.amazon.awssdk.services.glue.model.GetIntegrationTablePropertiesRequest;
import software.amazon.awssdk.services.glue.model.GetIntegrationTablePropertiesResponse;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.GetJobRequest;
import software.amazon.awssdk.services.glue.model.GetJobResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunsRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunsResponse;
import software.amazon.awssdk.services.glue.model.GetJobsRequest;
import software.amazon.awssdk.services.glue.model.GetJobsResponse;
import software.amazon.awssdk.services.glue.model.GetMappingRequest;
import software.amazon.awssdk.services.glue.model.GetMappingResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;
import software.amazon.awssdk.services.glue.model.GetPlanRequest;
import software.amazon.awssdk.services.glue.model.GetPlanResponse;
import software.amazon.awssdk.services.glue.model.GetRegistryRequest;
import software.amazon.awssdk.services.glue.model.GetRegistryResponse;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaByDefinitionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaByDefinitionResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionsDiffRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionsDiffResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse;
import software.amazon.awssdk.services.glue.model.GetSessionRequest;
import software.amazon.awssdk.services.glue.model.GetSessionResponse;
import software.amazon.awssdk.services.glue.model.GetStatementRequest;
import software.amazon.awssdk.services.glue.model.GetStatementResponse;
import software.amazon.awssdk.services.glue.model.GetTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.GetTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionsRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionsResponse;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.GetTagsRequest;
import software.amazon.awssdk.services.glue.model.GetTagsResponse;
import software.amazon.awssdk.services.glue.model.GetTriggerRequest;
import software.amazon.awssdk.services.glue.model.GetTriggerResponse;
import software.amazon.awssdk.services.glue.model.GetTriggersRequest;
import software.amazon.awssdk.services.glue.model.GetTriggersResponse;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionMetadataRequest;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionMetadataResponse;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataResponse;
import software.amazon.awssdk.services.glue.model.GetUnfilteredTableMetadataRequest;
import software.amazon.awssdk.services.glue.model.GetUnfilteredTableMetadataResponse;
import software.amazon.awssdk.services.glue.model.GetUsageProfileRequest;
import software.amazon.awssdk.services.glue.model.GetUsageProfileResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse;
import software.amazon.awssdk.services.glue.model.GlueEncryptionException;
import software.amazon.awssdk.services.glue.model.GlueException;
import software.amazon.awssdk.services.glue.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.glue.model.IllegalBlueprintStateException;
import software.amazon.awssdk.services.glue.model.IllegalSessionStateException;
import software.amazon.awssdk.services.glue.model.IllegalWorkflowStateException;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueRequest;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueResponse;
import software.amazon.awssdk.services.glue.model.IntegrationConflictOperationException;
import software.amazon.awssdk.services.glue.model.IntegrationNotFoundException;
import software.amazon.awssdk.services.glue.model.IntegrationQuotaExceededException;
import software.amazon.awssdk.services.glue.model.InternalServerException;
import software.amazon.awssdk.services.glue.model.InternalServiceException;
import software.amazon.awssdk.services.glue.model.InvalidInputException;
import software.amazon.awssdk.services.glue.model.InvalidIntegrationStateException;
import software.amazon.awssdk.services.glue.model.InvalidStateException;
import software.amazon.awssdk.services.glue.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.glue.model.ListBlueprintsRequest;
import software.amazon.awssdk.services.glue.model.ListBlueprintsResponse;
import software.amazon.awssdk.services.glue.model.ListColumnStatisticsTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.ListColumnStatisticsTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.ListConnectionTypesRequest;
import software.amazon.awssdk.services.glue.model.ListConnectionTypesResponse;
import software.amazon.awssdk.services.glue.model.ListCrawlersRequest;
import software.amazon.awssdk.services.glue.model.ListCrawlersResponse;
import software.amazon.awssdk.services.glue.model.ListCrawlsRequest;
import software.amazon.awssdk.services.glue.model.ListCrawlsResponse;
import software.amazon.awssdk.services.glue.model.ListCustomEntityTypesRequest;
import software.amazon.awssdk.services.glue.model.ListCustomEntityTypesResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityResultsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityResultsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityRuleRecommendationRunsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityRuleRecommendationRunsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetEvaluationRunsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetEvaluationRunsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityStatisticAnnotationsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityStatisticAnnotationsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityStatisticsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityStatisticsResponse;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.ListEntitiesRequest;
import software.amazon.awssdk.services.glue.model.ListEntitiesResponse;
import software.amazon.awssdk.services.glue.model.ListJobsRequest;
import software.amazon.awssdk.services.glue.model.ListJobsResponse;
import software.amazon.awssdk.services.glue.model.ListMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.ListMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.ListRegistriesRequest;
import software.amazon.awssdk.services.glue.model.ListRegistriesResponse;
import software.amazon.awssdk.services.glue.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.glue.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.glue.model.ListSchemasRequest;
import software.amazon.awssdk.services.glue.model.ListSchemasResponse;
import software.amazon.awssdk.services.glue.model.ListSessionsRequest;
import software.amazon.awssdk.services.glue.model.ListSessionsResponse;
import software.amazon.awssdk.services.glue.model.ListStatementsRequest;
import software.amazon.awssdk.services.glue.model.ListStatementsResponse;
import software.amazon.awssdk.services.glue.model.ListTableOptimizerRunsRequest;
import software.amazon.awssdk.services.glue.model.ListTableOptimizerRunsResponse;
import software.amazon.awssdk.services.glue.model.ListTriggersRequest;
import software.amazon.awssdk.services.glue.model.ListTriggersResponse;
import software.amazon.awssdk.services.glue.model.ListUsageProfilesRequest;
import software.amazon.awssdk.services.glue.model.ListUsageProfilesResponse;
import software.amazon.awssdk.services.glue.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.MlTransformNotReadyException;
import software.amazon.awssdk.services.glue.model.ModifyIntegrationRequest;
import software.amazon.awssdk.services.glue.model.ModifyIntegrationResponse;
import software.amazon.awssdk.services.glue.model.NoScheduleException;
import software.amazon.awssdk.services.glue.model.OperationNotSupportedException;
import software.amazon.awssdk.services.glue.model.OperationTimeoutException;
import software.amazon.awssdk.services.glue.model.PermissionTypeMismatchException;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.PutDataQualityProfileAnnotationRequest;
import software.amazon.awssdk.services.glue.model.PutDataQualityProfileAnnotationResponse;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.PutSchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.PutSchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.QuerySchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.QuerySchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.RegisterSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.RegisterSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.RemoveSchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.RemoveSchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.ResourceNotFoundException;
import software.amazon.awssdk.services.glue.model.ResourceNotReadyException;
import software.amazon.awssdk.services.glue.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.glue.model.ResumeWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.ResumeWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.RunStatementRequest;
import software.amazon.awssdk.services.glue.model.RunStatementResponse;
import software.amazon.awssdk.services.glue.model.SchedulerNotRunningException;
import software.amazon.awssdk.services.glue.model.SchedulerRunningException;
import software.amazon.awssdk.services.glue.model.SchedulerTransitioningException;
import software.amazon.awssdk.services.glue.model.SearchTablesRequest;
import software.amazon.awssdk.services.glue.model.SearchTablesResponse;
import software.amazon.awssdk.services.glue.model.StartBlueprintRunRequest;
import software.amazon.awssdk.services.glue.model.StartBlueprintRunResponse;
import software.amazon.awssdk.services.glue.model.StartColumnStatisticsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartColumnStatisticsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartColumnStatisticsTaskRunScheduleRequest;
import software.amazon.awssdk.services.glue.model.StartColumnStatisticsTaskRunScheduleResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StartDataQualityRuleRecommendationRunRequest;
import software.amazon.awssdk.services.glue.model.StartDataQualityRuleRecommendationRunResponse;
import software.amazon.awssdk.services.glue.model.StartDataQualityRulesetEvaluationRunRequest;
import software.amazon.awssdk.services.glue.model.StartDataQualityRulesetEvaluationRunResponse;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartJobRunRequest;
import software.amazon.awssdk.services.glue.model.StartJobRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartTriggerRequest;
import software.amazon.awssdk.services.glue.model.StartTriggerResponse;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.StopColumnStatisticsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StopColumnStatisticsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StopColumnStatisticsTaskRunScheduleRequest;
import software.amazon.awssdk.services.glue.model.StopColumnStatisticsTaskRunScheduleResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StopSessionRequest;
import software.amazon.awssdk.services.glue.model.StopSessionResponse;
import software.amazon.awssdk.services.glue.model.StopTriggerRequest;
import software.amazon.awssdk.services.glue.model.StopTriggerResponse;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.TagResourceRequest;
import software.amazon.awssdk.services.glue.model.TagResourceResponse;
import software.amazon.awssdk.services.glue.model.TargetResourceNotFoundException;
import software.amazon.awssdk.services.glue.model.TestConnectionRequest;
import software.amazon.awssdk.services.glue.model.TestConnectionResponse;
import software.amazon.awssdk.services.glue.model.ThrottlingException;
import software.amazon.awssdk.services.glue.model.UntagResourceRequest;
import software.amazon.awssdk.services.glue.model.UntagResourceResponse;
import software.amazon.awssdk.services.glue.model.UpdateBlueprintRequest;
import software.amazon.awssdk.services.glue.model.UpdateBlueprintResponse;
import software.amazon.awssdk.services.glue.model.UpdateCatalogRequest;
import software.amazon.awssdk.services.glue.model.UpdateCatalogResponse;
import software.amazon.awssdk.services.glue.model.UpdateClassifierRequest;
import software.amazon.awssdk.services.glue.model.UpdateClassifierResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsTaskSettingsRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsTaskSettingsResponse;
import software.amazon.awssdk.services.glue.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.glue.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.UpdateDataQualityRulesetRequest;
import software.amazon.awssdk.services.glue.model.UpdateDataQualityRulesetResponse;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.UpdateIntegrationResourcePropertyRequest;
import software.amazon.awssdk.services.glue.model.UpdateIntegrationResourcePropertyResponse;
import software.amazon.awssdk.services.glue.model.UpdateIntegrationTablePropertiesRequest;
import software.amazon.awssdk.services.glue.model.UpdateIntegrationTablePropertiesResponse;
import software.amazon.awssdk.services.glue.model.UpdateJobFromSourceControlRequest;
import software.amazon.awssdk.services.glue.model.UpdateJobFromSourceControlResponse;
import software.amazon.awssdk.services.glue.model.UpdateJobRequest;
import software.amazon.awssdk.services.glue.model.UpdateJobResponse;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.UpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.UpdateRegistryRequest;
import software.amazon.awssdk.services.glue.model.UpdateRegistryResponse;
import software.amazon.awssdk.services.glue.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.glue.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.glue.model.UpdateSourceControlFromJobRequest;
import software.amazon.awssdk.services.glue.model.UpdateSourceControlFromJobResponse;
import software.amazon.awssdk.services.glue.model.UpdateTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableResponse;
import software.amazon.awssdk.services.glue.model.UpdateTriggerRequest;
import software.amazon.awssdk.services.glue.model.UpdateTriggerResponse;
import software.amazon.awssdk.services.glue.model.UpdateUsageProfileRequest;
import software.amazon.awssdk.services.glue.model.UpdateUsageProfileResponse;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.glue.model.ValidationException;
import software.amazon.awssdk.services.glue.model.VersionMismatchException;
import software.amazon.awssdk.services.glue.transform.BatchCreatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeletePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeleteTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeleteTableVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetCrawlersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetCustomEntityTypesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetDataQualityResultRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetDevEndpointsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetJobsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetTableOptimizerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetTriggersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchPutDataQualityStatisticAnnotationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchStopJobRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchUpdatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CancelDataQualityRuleRecommendationRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CancelDataQualityRulesetEvaluationRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CancelMlTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CancelStatementRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CheckSchemaVersionValidityRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateBlueprintRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateCatalogRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateColumnStatisticsTaskSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateCustomEntityTypeRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateDataQualityRulesetRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateIntegrationResourcePropertyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateIntegrationTablePropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreatePartitionIndexRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateRegistryRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateSchemaRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateScriptRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateSessionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateTableOptimizerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateUsageProfileRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteBlueprintRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteCatalogRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteColumnStatisticsForPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteColumnStatisticsForTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteColumnStatisticsTaskSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteCustomEntityTypeRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteDataQualityRulesetRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteIntegrationTablePropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeletePartitionIndexRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeletePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteRegistryRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteSchemaRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteSchemaVersionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteSessionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTableOptimizerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTableVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteUsageProfileRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteWorkflowRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DescribeConnectionTypeRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DescribeEntityRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DescribeInboundIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DescribeIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetBlueprintRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetBlueprintRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetBlueprintRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCatalogImportStatusRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCatalogRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCatalogsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetClassifiersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetColumnStatisticsForPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetColumnStatisticsForTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetColumnStatisticsTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetColumnStatisticsTaskRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetColumnStatisticsTaskSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetConnectionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCrawlerMetricsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCrawlersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCustomEntityTypeRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataCatalogEncryptionSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataQualityModelRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataQualityModelResultRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataQualityResultRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataQualityRuleRecommendationRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataQualityRulesetEvaluationRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataQualityRulesetRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDatabasesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataflowGraphRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDevEndpointsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetEntityRecordsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetIntegrationResourcePropertyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetIntegrationTablePropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobBookmarkRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMappingRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTaskRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTransformsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPartitionIndexesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPartitionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPlanRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetRegistryRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSchemaByDefinitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSchemaRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSchemaVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSchemaVersionsDiffRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSecurityConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetStatementRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableOptimizerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableVersionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTablesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTriggersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUnfilteredPartitionMetadataRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUnfilteredPartitionsMetadataRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUnfilteredTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUsageProfileRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUserDefinedFunctionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRunPropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ImportCatalogToGlueRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListColumnStatisticsTaskRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListConnectionTypesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListCrawlersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListCrawlsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListCustomEntityTypesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListDataQualityResultsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListDataQualityRuleRecommendationRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListDataQualityRulesetEvaluationRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListDataQualityRulesetsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListDataQualityStatisticAnnotationsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListDataQualityStatisticsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListDevEndpointsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListEntitiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListMlTransformsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListRegistriesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListSchemaVersionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListSchemasRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListSessionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListStatementsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListTableOptimizerRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListTriggersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListUsageProfilesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ModifyIntegrationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutDataCatalogEncryptionSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutDataQualityProfileAnnotationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutSchemaVersionMetadataRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutWorkflowRunPropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.QuerySchemaVersionMetadataRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.RegisterSchemaVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.RemoveSchemaVersionMetadataRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ResetJobBookmarkRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ResumeWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.RunStatementRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.SearchTablesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartBlueprintRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartColumnStatisticsTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartColumnStatisticsTaskRunScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartCrawlerScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartDataQualityRuleRecommendationRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartDataQualityRulesetEvaluationRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartExportLabelsTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartImportLabelsTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartJobRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartMlEvaluationTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartMlLabelingSetGenerationTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopColumnStatisticsTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopColumnStatisticsTaskRunScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopCrawlerScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopSessionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.TestConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateBlueprintRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateCatalogRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateColumnStatisticsForPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateColumnStatisticsForTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateColumnStatisticsTaskSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateCrawlerScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateDataQualityRulesetRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateIntegrationResourcePropertyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateIntegrationTablePropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateJobFromSourceControlRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateRegistryRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateSchemaRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateSourceControlFromJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateTableOptimizerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateUsageProfileRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateWorkflowRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link GlueClient}.
 *
 * @see GlueClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGlueClient implements GlueClient {
    private static final Logger log = Logger.loggerFor(DefaultGlueClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGlueClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates one or more partitions in a batch operation.
     * </p>
     *
     * @param batchCreatePartitionRequest
     * @return Result of the BatchCreatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchCreatePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchCreatePartitionResponse batchCreatePartition(BatchCreatePartitionRequest batchCreatePartitionRequest)
            throws InvalidInputException, AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException,
            EntityNotFoundException, OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreatePartitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreatePartitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreatePartitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchCreatePartitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreatePartition");

            return clientHandler.execute(new ClientExecutionParams<BatchCreatePartitionRequest, BatchCreatePartitionResponse>()
                    .withOperationName("BatchCreatePartition").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchCreatePartitionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchCreatePartitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a list of connection definitions from the Data Catalog.
     * </p>
     *
     * @param batchDeleteConnectionRequest
     * @return Result of the BatchDeleteConnection operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchDeleteConnectionResponse batchDeleteConnection(BatchDeleteConnectionRequest batchDeleteConnectionRequest)
            throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteConnection");

            return clientHandler.execute(new ClientExecutionParams<BatchDeleteConnectionRequest, BatchDeleteConnectionResponse>()
                    .withOperationName("BatchDeleteConnection").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchDeleteConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchDeleteConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes one or more partitions in a batch operation.
     * </p>
     *
     * @param batchDeletePartitionRequest
     * @return Result of the BatchDeletePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeletePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchDeletePartitionResponse batchDeletePartition(BatchDeletePartitionRequest batchDeletePartitionRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeletePartitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeletePartitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeletePartitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeletePartitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeletePartition");

            return clientHandler.execute(new ClientExecutionParams<BatchDeletePartitionRequest, BatchDeletePartitionResponse>()
                    .withOperationName("BatchDeletePartition").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchDeletePartitionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchDeletePartitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes multiple tables at once.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion
     * of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>BatchDeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note>
     *
     * @param batchDeleteTableRequest
     * @return Result of the BatchDeleteTable operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws ResourceNotReadyException
     *         A resource was not ready for a transaction.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchDeleteTableResponse batchDeleteTable(BatchDeleteTableRequest batchDeleteTableRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, ResourceNotReadyException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteTableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchDeleteTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteTable");

            return clientHandler.execute(new ClientExecutionParams<BatchDeleteTableRequest, BatchDeleteTableResponse>()
                    .withOperationName("BatchDeleteTable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchDeleteTableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchDeleteTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified batch of versions of a table.
     * </p>
     *
     * @param batchDeleteTableVersionRequest
     * @return Result of the BatchDeleteTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteTableVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchDeleteTableVersionResponse batchDeleteTableVersion(BatchDeleteTableVersionRequest batchDeleteTableVersionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteTableVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteTableVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteTableVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteTableVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteTableVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteTableVersionRequest, BatchDeleteTableVersionResponse>()
                            .withOperationName("BatchDeleteTableVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDeleteTableVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDeleteTableVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a list of blueprints.
     * </p>
     *
     * @param batchGetBlueprintsRequest
     * @return Result of the BatchGetBlueprints operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetBlueprintsResponse batchGetBlueprints(BatchGetBlueprintsRequest batchGetBlueprintsRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetBlueprintsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetBlueprintsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetBlueprintsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetBlueprintsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetBlueprints");

            return clientHandler.execute(new ClientExecutionParams<BatchGetBlueprintsRequest, BatchGetBlueprintsResponse>()
                    .withOperationName("BatchGetBlueprints").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetBlueprintsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetBlueprintsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of crawler names. After calling the
     * <code>ListCrawlers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetCrawlersRequest
     * @return Result of the BatchGetCrawlers operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetCrawlers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetCrawlersResponse batchGetCrawlers(BatchGetCrawlersRequest batchGetCrawlersRequest)
            throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetCrawlersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetCrawlersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetCrawlersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetCrawlersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetCrawlers");

            return clientHandler.execute(new ClientExecutionParams<BatchGetCrawlersRequest, BatchGetCrawlersResponse>()
                    .withOperationName("BatchGetCrawlers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetCrawlersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetCrawlersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the details for the custom patterns specified by a list of names.
     * </p>
     *
     * @param batchGetCustomEntityTypesRequest
     * @return Result of the BatchGetCustomEntityTypes operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetCustomEntityTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCustomEntityTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetCustomEntityTypesResponse batchGetCustomEntityTypes(
            BatchGetCustomEntityTypesRequest batchGetCustomEntityTypesRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetCustomEntityTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetCustomEntityTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetCustomEntityTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetCustomEntityTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetCustomEntityTypes");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetCustomEntityTypesRequest, BatchGetCustomEntityTypesResponse>()
                            .withOperationName("BatchGetCustomEntityTypes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetCustomEntityTypesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetCustomEntityTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of data quality results for the specified result IDs.
     * </p>
     *
     * @param batchGetDataQualityResultRequest
     * @return Result of the BatchGetDataQualityResult operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetDataQualityResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDataQualityResult"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetDataQualityResultResponse batchGetDataQualityResult(
            BatchGetDataQualityResultRequest batchGetDataQualityResultRequest) throws InvalidInputException,
            OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetDataQualityResultResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetDataQualityResultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDataQualityResultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDataQualityResultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDataQualityResult");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetDataQualityResultRequest, BatchGetDataQualityResultResponse>()
                            .withOperationName("BatchGetDataQualityResult").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetDataQualityResultRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetDataQualityResultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of development endpoint names. After calling the
     * <code>ListDevEndpoints</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetDevEndpointsRequest
     * @return Result of the BatchGetDevEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetDevEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetDevEndpointsResponse batchGetDevEndpoints(BatchGetDevEndpointsRequest batchGetDevEndpointsRequest)
            throws AccessDeniedException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetDevEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetDevEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDevEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDevEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDevEndpoints");

            return clientHandler.execute(new ClientExecutionParams<BatchGetDevEndpointsRequest, BatchGetDevEndpointsResponse>()
                    .withOperationName("BatchGetDevEndpoints").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetDevEndpointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetDevEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of job names. After calling the <code>ListJobs</code>
     * operation, you can call this operation to access the data to which you have been granted permissions. This
     * operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetJobsRequest
     * @return Result of the BatchGetJobs operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetJobsResponse batchGetJobs(BatchGetJobsRequest batchGetJobsRequest) throws InternalServiceException,
            OperationTimeoutException, InvalidInputException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetJobs");

            return clientHandler.execute(new ClientExecutionParams<BatchGetJobsRequest, BatchGetJobsResponse>()
                    .withOperationName("BatchGetJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves partitions in a batch request.
     * </p>
     *
     * @param batchGetPartitionRequest
     * @return Result of the BatchGetPartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws InvalidStateException
     *         An error that indicates your data is in an invalid state.
     * @throws FederationSourceException
     *         A federation source failed.
     * @throws FederationSourceRetryableException
     *         A federation source failed, but the operation may be retried.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetPartitionResponse batchGetPartition(BatchGetPartitionRequest batchGetPartitionRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, InvalidStateException, FederationSourceException, FederationSourceRetryableException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetPartitionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetPartitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetPartitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetPartitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetPartition");

            return clientHandler.execute(new ClientExecutionParams<BatchGetPartitionRequest, BatchGetPartitionResponse>()
                    .withOperationName("BatchGetPartition").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetPartitionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetPartitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the configuration for the specified table optimizers.
     * </p>
     *
     * @param batchGetTableOptimizerRequest
     * @return Result of the BatchGetTableOptimizer operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ThrottlingException
     *         The throttling threshhold was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTableOptimizer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchGetTableOptimizerResponse batchGetTableOptimizer(BatchGetTableOptimizerRequest batchGetTableOptimizerRequest)
            throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetTableOptimizerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetTableOptimizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetTableOptimizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetTableOptimizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetTableOptimizer");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetTableOptimizerRequest, BatchGetTableOptimizerResponse>()
                            .withOperationName("BatchGetTableOptimizer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetTableOptimizerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetTableOptimizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of trigger names. After calling the
     * <code>ListTriggers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetTriggersRequest
     * @return Result of the BatchGetTriggers operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetTriggersResponse batchGetTriggers(BatchGetTriggersRequest batchGetTriggersRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetTriggersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetTriggersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetTriggersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetTriggersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetTriggers");

            return clientHandler.execute(new ClientExecutionParams<BatchGetTriggersRequest, BatchGetTriggersResponse>()
                    .withOperationName("BatchGetTriggers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetTriggersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetTriggersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of workflow names. After calling the
     * <code>ListWorkflows</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetWorkflowsRequest
     * @return Result of the BatchGetWorkflows operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetWorkflowsResponse batchGetWorkflows(BatchGetWorkflowsRequest batchGetWorkflowsRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetWorkflowsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetWorkflowsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetWorkflowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetWorkflows");

            return clientHandler.execute(new ClientExecutionParams<BatchGetWorkflowsRequest, BatchGetWorkflowsResponse>()
                    .withOperationName("BatchGetWorkflows").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetWorkflowsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetWorkflowsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Annotate datapoints over time for a specific data quality statistic.
     * </p>
     *
     * @param batchPutDataQualityStatisticAnnotationRequest
     * @return Result of the BatchPutDataQualityStatisticAnnotation operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchPutDataQualityStatisticAnnotation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchPutDataQualityStatisticAnnotation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchPutDataQualityStatisticAnnotationResponse batchPutDataQualityStatisticAnnotation(
            BatchPutDataQualityStatisticAnnotationRequest batchPutDataQualityStatisticAnnotationRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException,
            ResourceNumberLimitExceededException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchPutDataQualityStatisticAnnotationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchPutDataQualityStatisticAnnotationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchPutDataQualityStatisticAnnotationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchPutDataQualityStatisticAnnotationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchPutDataQualityStatisticAnnotation");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchPutDataQualityStatisticAnnotationRequest, BatchPutDataQualityStatisticAnnotationResponse>()
                            .withOperationName("BatchPutDataQualityStatisticAnnotation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(batchPutDataQualityStatisticAnnotationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchPutDataQualityStatisticAnnotationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops one or more job runs for a specified job definition.
     * </p>
     *
     * @param batchStopJobRunRequest
     * @return Result of the BatchStopJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchStopJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchStopJobRunResponse batchStopJobRun(BatchStopJobRunRequest batchStopJobRunRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchStopJobRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchStopJobRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchStopJobRunRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchStopJobRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchStopJobRun");

            return clientHandler.execute(new ClientExecutionParams<BatchStopJobRunRequest, BatchStopJobRunResponse>()
                    .withOperationName("BatchStopJobRun").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchStopJobRunRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchStopJobRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates one or more partitions in a batch operation.
     * </p>
     *
     * @param batchUpdatePartitionRequest
     * @return Result of the BatchUpdatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchUpdatePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchUpdatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchUpdatePartitionResponse batchUpdatePartition(BatchUpdatePartitionRequest batchUpdatePartitionRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdatePartitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdatePartitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdatePartitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdatePartitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdatePartition");

            return clientHandler.execute(new ClientExecutionParams<BatchUpdatePartitionRequest, BatchUpdatePartitionResponse>()
                    .withOperationName("BatchUpdatePartition").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchUpdatePartitionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchUpdatePartitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the specified recommendation run that was being used to generate rules.
     * </p>
     *
     * @param cancelDataQualityRuleRecommendationRunRequest
     * @return Result of the CancelDataQualityRuleRecommendationRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CancelDataQualityRuleRecommendationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelDataQualityRuleRecommendationRun"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelDataQualityRuleRecommendationRunResponse cancelDataQualityRuleRecommendationRun(
            CancelDataQualityRuleRecommendationRunRequest cancelDataQualityRuleRecommendationRunRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelDataQualityRuleRecommendationRunResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CancelDataQualityRuleRecommendationRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelDataQualityRuleRecommendationRunRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelDataQualityRuleRecommendationRunRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelDataQualityRuleRecommendationRun");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelDataQualityRuleRecommendationRunRequest, CancelDataQualityRuleRecommendationRunResponse>()
                            .withOperationName("CancelDataQualityRuleRecommendationRun").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(cancelDataQualityRuleRecommendationRunRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelDataQualityRuleRecommendationRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a run where a ruleset is being evaluated against a data source.
     * </p>
     *
     * @param cancelDataQualityRulesetEvaluationRunRequest
     * @return Result of the CancelDataQualityRulesetEvaluationRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CancelDataQualityRulesetEvaluationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelDataQualityRulesetEvaluationRun"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelDataQualityRulesetEvaluationRunResponse cancelDataQualityRulesetEvaluationRun(
            CancelDataQualityRulesetEvaluationRunRequest cancelDataQualityRulesetEvaluationRunRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelDataQualityRulesetEvaluationRunResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CancelDataQualityRulesetEvaluationRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelDataQualityRulesetEvaluationRunRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelDataQualityRulesetEvaluationRunRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelDataQualityRulesetEvaluationRun");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelDataQualityRulesetEvaluationRunRequest, CancelDataQualityRulesetEvaluationRunResponse>()
                            .withOperationName("CancelDataQualityRulesetEvaluationRun").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(cancelDataQualityRulesetEvaluationRunRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelDataQualityRulesetEvaluationRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as
     * part of various machine learning workflows. You can cancel a machine learning task run at any time by calling
     * <code>CancelMLTaskRun</code> with a task run's parent transform's <code>TransformID</code> and the task run's
     * <code>TaskRunId</code>.
     * </p>
     *
     * @param cancelMlTaskRunRequest
     * @return Result of the CancelMLTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CancelMLTaskRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelMlTaskRunResponse cancelMLTaskRun(CancelMlTaskRunRequest cancelMlTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelMlTaskRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelMlTaskRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMlTaskRunRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMlTaskRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMLTaskRun");

            return clientHandler.execute(new ClientExecutionParams<CancelMlTaskRunRequest, CancelMlTaskRunResponse>()
                    .withOperationName("CancelMLTaskRun").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelMlTaskRunRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelMlTaskRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the statement.
     * </p>
     *
     * @param cancelStatementRequest
     * @return Result of the CancelStatement operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws IllegalSessionStateException
     *         The session is in an invalid state to perform a requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CancelStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelStatement" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelStatementResponse cancelStatement(CancelStatementRequest cancelStatementRequest) throws AccessDeniedException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            IllegalSessionStateException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelStatementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelStatement");

            return clientHandler.execute(new ClientExecutionParams<CancelStatementRequest, CancelStatementResponse>()
                    .withOperationName("CancelStatement").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelStatementRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Validates the supplied schema. This call has no side effects, it simply validates using the supplied schema using
     * <code>DataFormat</code> as the format. Since it does not take a schema set name, no compatibility checks are
     * performed.
     * </p>
     *
     * @param checkSchemaVersionValidityRequest
     * @return Result of the CheckSchemaVersionValidity operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CheckSchemaVersionValidity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CheckSchemaVersionValidity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CheckSchemaVersionValidityResponse checkSchemaVersionValidity(
            CheckSchemaVersionValidityRequest checkSchemaVersionValidityRequest) throws InvalidInputException,
            AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CheckSchemaVersionValidityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CheckSchemaVersionValidityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(checkSchemaVersionValidityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, checkSchemaVersionValidityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CheckSchemaVersionValidity");

            return clientHandler
                    .execute(new ClientExecutionParams<CheckSchemaVersionValidityRequest, CheckSchemaVersionValidityResponse>()
                            .withOperationName("CheckSchemaVersionValidity").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(checkSchemaVersionValidityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CheckSchemaVersionValidityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers a blueprint with Glue.
     * </p>
     *
     * @param createBlueprintRequest
     * @return Result of the CreateBlueprint operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBlueprintResponse createBlueprint(CreateBlueprintRequest createBlueprintRequest) throws AlreadyExistsException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBlueprintResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBlueprintResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBlueprintRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBlueprintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBlueprint");

            return clientHandler.execute(new ClientExecutionParams<CreateBlueprintRequest, CreateBlueprintResponse>()
                    .withOperationName("CreateBlueprint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBlueprintRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBlueprintRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new catalog in the Glue Data Catalog.
     * </p>
     *
     * @param createCatalogRequest
     * @return Result of the CreateCatalog operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws FederatedResourceAlreadyExistsException
     *         A federated resource already exists.
     * @throws FederationSourceException
     *         A federation source failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCatalogResponse createCatalog(CreateCatalogRequest createCatalogRequest) throws InvalidInputException,
            AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, ConcurrentModificationException, AccessDeniedException, EntityNotFoundException,
            FederatedResourceAlreadyExistsException, FederationSourceException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCatalogResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCatalog");

            return clientHandler.execute(new ClientExecutionParams<CreateCatalogRequest, CreateCatalogResponse>()
                    .withOperationName("CreateCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a classifier in the user's account. This can be a <code>GrokClassifier</code>, an
     * <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which
     * field of the request is present.
     * </p>
     *
     * @param createClassifierRequest
     * @return Result of the CreateClassifier operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateClassifierResponse createClassifier(CreateClassifierRequest createClassifierRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateClassifierResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateClassifierResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClassifierRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClassifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClassifier");

            return clientHandler.execute(new ClientExecutionParams<CreateClassifierRequest, CreateClassifierResponse>()
                    .withOperationName("CreateClassifier").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createClassifierRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateClassifierRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates settings for a column statistics task.
     * </p>
     *
     * @param createColumnStatisticsTaskSettingsRequest
     * @return Result of the CreateColumnStatisticsTaskSettings operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ColumnStatisticsTaskRunningException
     *         An exception thrown when you try to start another job while running a column stats generation job.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateColumnStatisticsTaskSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateColumnStatisticsTaskSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateColumnStatisticsTaskSettingsResponse createColumnStatisticsTaskSettings(
            CreateColumnStatisticsTaskSettingsRequest createColumnStatisticsTaskSettingsRequest) throws AlreadyExistsException,
            AccessDeniedException, EntityNotFoundException, InvalidInputException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ColumnStatisticsTaskRunningException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateColumnStatisticsTaskSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateColumnStatisticsTaskSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createColumnStatisticsTaskSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createColumnStatisticsTaskSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateColumnStatisticsTaskSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateColumnStatisticsTaskSettingsRequest, CreateColumnStatisticsTaskSettingsResponse>()
                            .withOperationName("CreateColumnStatisticsTaskSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createColumnStatisticsTaskSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateColumnStatisticsTaskSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a connection definition in the Data Catalog.
     * </p>
     * <p>
     * Connections used for creating federated resources require the IAM <code>glue:PassConnection</code> permission.
     * </p>
     *
     * @param createConnectionRequest
     * @return Result of the CreateConnection operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnection");

            return clientHandler.execute(new ClientExecutionParams<CreateConnectionRequest, CreateConnectionResponse>()
                    .withOperationName("CreateConnection").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new crawler with specified targets, role, configuration, and optional schedule. At least one crawl
     * target must be specified, in the <code>s3Targets</code> field, the <code>jdbcTargets</code> field, or the
     * <code>DynamoDBTargets</code> field.
     * </p>
     *
     * @param createCrawlerRequest
     * @return Result of the CreateCrawler operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateCrawler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCrawlerResponse createCrawler(CreateCrawlerRequest createCrawlerRequest) throws InvalidInputException,
            AlreadyExistsException, OperationTimeoutException, ResourceNumberLimitExceededException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCrawlerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCrawlerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCrawlerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCrawlerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCrawler");

            return clientHandler.execute(new ClientExecutionParams<CreateCrawlerRequest, CreateCrawlerResponse>()
                    .withOperationName("CreateCrawler").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCrawlerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCrawlerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom pattern that is used to detect sensitive data across the columns and rows of your structured
     * data.
     * </p>
     * <p>
     * Each custom pattern you create specifies a regular expression and an optional list of context words. If no
     * context words are passed only a regular expression is checked.
     * </p>
     *
     * @param createCustomEntityTypeRequest
     * @return Result of the CreateCustomEntityType operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateCustomEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCustomEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateCustomEntityTypeResponse createCustomEntityType(CreateCustomEntityTypeRequest createCustomEntityTypeRequest)
            throws AccessDeniedException, AlreadyExistsException, IdempotentParameterMismatchException, InternalServiceException,
            InvalidInputException, OperationTimeoutException, ResourceNumberLimitExceededException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCustomEntityTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCustomEntityTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomEntityTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomEntityTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomEntityType");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCustomEntityTypeRequest, CreateCustomEntityTypeResponse>()
                            .withOperationName("CreateCustomEntityType").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCustomEntityTypeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCustomEntityTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a data quality ruleset with DQDL rules applied to a specified Glue table.
     * </p>
     * <p>
     * You create the ruleset using the Data Quality Definition Language (DQDL). For more information, see the Glue
     * developer guide.
     * </p>
     *
     * @param createDataQualityRulesetRequest
     *        A request to create a data quality ruleset.
     * @return Result of the CreateDataQualityRuleset operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateDataQualityRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDataQualityRuleset" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDataQualityRulesetResponse createDataQualityRuleset(
            CreateDataQualityRulesetRequest createDataQualityRulesetRequest) throws InvalidInputException,
            AlreadyExistsException, OperationTimeoutException, InternalServiceException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataQualityRulesetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDataQualityRulesetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataQualityRulesetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataQualityRulesetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataQualityRuleset");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDataQualityRulesetRequest, CreateDataQualityRulesetResponse>()
                            .withOperationName("CreateDataQualityRuleset").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDataQualityRulesetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDataQualityRulesetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new database in a Data Catalog.
     * </p>
     *
     * @param createDatabaseRequest
     * @return Result of the CreateDatabase operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws FederatedResourceAlreadyExistsException
     *         A federated resource already exists.
     * @throws FederationSourceException
     *         A federation source failed.
     * @throws FederationSourceRetryableException
     *         A federation source failed, but the operation may be retried.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDatabaseResponse createDatabase(CreateDatabaseRequest createDatabaseRequest) throws InvalidInputException,
            AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, ConcurrentModificationException, FederatedResourceAlreadyExistsException,
            FederationSourceException, FederationSourceRetryableException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDatabase");

            return clientHandler.execute(new ClientExecutionParams<CreateDatabaseRequest, CreateDatabaseResponse>()
                    .withOperationName("CreateDatabase").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDatabaseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDatabaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new development endpoint.
     * </p>
     *
     * @param createDevEndpointRequest
     * @return Result of the CreateDevEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateDevEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDevEndpointResponse createDevEndpoint(CreateDevEndpointRequest createDevEndpointRequest)
            throws AccessDeniedException, AlreadyExistsException, IdempotentParameterMismatchException, InternalServiceException,
            OperationTimeoutException, InvalidInputException, ValidationException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDevEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDevEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDevEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDevEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDevEndpoint");

            return clientHandler.execute(new ClientExecutionParams<CreateDevEndpointRequest, CreateDevEndpointResponse>()
                    .withOperationName("CreateDevEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDevEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDevEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Zero-ETL integration in the caller's account between two resources with Amazon Resource Names (ARNs):
     * the <code>SourceArn</code> and <code>TargetArn</code>.
     * </p>
     *
     * @param createIntegrationRequest
     * @return Result of the CreateIntegration operation returned by the service.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InternalServerException
     *         An internal server error occurred.
     * @throws IntegrationConflictOperationException
     *         The requested operation conflicts with another operation.
     * @throws IntegrationQuotaExceededException
     *         The data processed through your integration exceeded your quota.
     * @throws KmsKeyNotAccessibleException
     *         The KMS key specified is not accessible.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ConflictException
     *         The <code>CreatePartitions</code> API was called on a table that has indexes enabled.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIntegrationResponse createIntegration(CreateIntegrationRequest createIntegrationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            IntegrationConflictOperationException, IntegrationQuotaExceededException, KmsKeyNotAccessibleException,
            EntityNotFoundException, InternalServiceException, ConflictException, ResourceNumberLimitExceededException,
            InvalidInputException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIntegrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntegration");

            return clientHandler.execute(new ClientExecutionParams<CreateIntegrationRequest, CreateIntegrationResponse>()
                    .withOperationName("CreateIntegration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API can be used for setting up the <code>ResourceProperty</code> of the Glue connection (for the source) or
     * Glue database ARN (for the target). These properties can include the role to access the connection or database.
     * To set both source and target properties the same API needs to be invoked with the Glue connection ARN as
     * <code>ResourceArn</code> with <code>SourceProcessingProperties</code> and the Glue database ARN as
     * <code>ResourceArn</code> with <code>TargetProcessingProperties</code> respectively.
     * </p>
     *
     * @param createIntegrationResourcePropertyRequest
     * @return Result of the CreateIntegrationResourceProperty operation returned by the service.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConflictException
     *         The <code>CreatePartitions</code> API was called on a table that has indexes enabled.
     * @throws InternalServerException
     *         An internal server error occurred.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateIntegrationResourceProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateIntegrationResourceProperty"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIntegrationResourcePropertyResponse createIntegrationResourceProperty(
            CreateIntegrationResourcePropertyRequest createIntegrationResourcePropertyRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException,
            EntityNotFoundException, InternalServiceException, InvalidInputException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIntegrationResourcePropertyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIntegrationResourcePropertyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIntegrationResourcePropertyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createIntegrationResourcePropertyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntegrationResourceProperty");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIntegrationResourcePropertyRequest, CreateIntegrationResourcePropertyResponse>()
                            .withOperationName("CreateIntegrationResourceProperty").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createIntegrationResourcePropertyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIntegrationResourcePropertyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is used to provide optional override properties for the the tables that need to be replicated. These
     * properties can include properties for filtering and partitioning for the source and target tables. To set both
     * source and target properties the same API need to be invoked with the Glue connection ARN as
     * <code>ResourceArn</code> with <code>SourceTableConfig</code>, and the Glue database ARN as
     * <code>ResourceArn</code> with <code>TargetTableConfig</code> respectively.
     * </p>
     *
     * @param createIntegrationTablePropertiesRequest
     * @return Result of the CreateIntegrationTableProperties operation returned by the service.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InternalServerException
     *         An internal server error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateIntegrationTableProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateIntegrationTableProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIntegrationTablePropertiesResponse createIntegrationTableProperties(
            CreateIntegrationTablePropertiesRequest createIntegrationTablePropertiesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, EntityNotFoundException,
            InternalServiceException, InvalidInputException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIntegrationTablePropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIntegrationTablePropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIntegrationTablePropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createIntegrationTablePropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntegrationTableProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIntegrationTablePropertiesRequest, CreateIntegrationTablePropertiesResponse>()
                            .withOperationName("CreateIntegrationTableProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createIntegrationTablePropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIntegrationTablePropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new job definition.
     * </p>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidInputException,
            IdempotentParameterMismatchException, AlreadyExistsException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJob");

            return clientHandler.execute(new ClientExecutionParams<CreateJobRequest, CreateJobResponse>()
                    .withOperationName("CreateJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Glue machine learning transform. This operation creates the transform and all the necessary parameters
     * to train it.
     * </p>
     * <p>
     * Call this operation as the first step in the process of using a machine learning transform (such as the
     * <code>FindMatches</code> transform) for deduplicating data. You can provide an optional <code>Description</code>,
     * in addition to the parameters that you want to use for your algorithm.
     * </p>
     * <p>
     * You must also specify certain parameters for the tasks that Glue runs on your behalf as part of learning from
     * your data and creating a high-quality machine learning transform. These parameters include <code>Role</code>, and
     * optionally, <code>AllocatedCapacity</code>, <code>Timeout</code>, and <code>MaxRetries</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html">Jobs</a>.
     * </p>
     *
     * @param createMlTransformRequest
     * @return Result of the CreateMLTransform operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateMLTransform
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateMlTransformResponse createMLTransform(CreateMlTransformRequest createMlTransformRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AccessDeniedException, ResourceNumberLimitExceededException, IdempotentParameterMismatchException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMlTransformResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMlTransformResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMlTransformRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMlTransformRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMLTransform");

            return clientHandler.execute(new ClientExecutionParams<CreateMlTransformRequest, CreateMlTransformResponse>()
                    .withOperationName("CreateMLTransform").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createMlTransformRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMlTransformRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new partition.
     * </p>
     *
     * @param createPartitionRequest
     * @return Result of the CreatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreatePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePartitionResponse createPartition(CreatePartitionRequest createPartitionRequest) throws InvalidInputException,
            AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException, EntityNotFoundException,
            OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePartitionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePartitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPartitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPartitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePartition");

            return clientHandler.execute(new ClientExecutionParams<CreatePartitionRequest, CreatePartitionResponse>()
                    .withOperationName("CreatePartition").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPartitionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePartitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a specified partition index in an existing table.
     * </p>
     *
     * @param createPartitionIndexRequest
     * @return Result of the CreatePartitionIndex operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreatePartitionIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartitionIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePartitionIndexResponse createPartitionIndex(CreatePartitionIndexRequest createPartitionIndexRequest)
            throws AlreadyExistsException, InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException,
            InternalServiceException, OperationTimeoutException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePartitionIndexResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePartitionIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPartitionIndexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPartitionIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePartitionIndex");

            return clientHandler.execute(new ClientExecutionParams<CreatePartitionIndexRequest, CreatePartitionIndexResponse>()
                    .withOperationName("CreatePartitionIndex").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPartitionIndexRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePartitionIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new registry which may be used to hold a collection of schemas.
     * </p>
     *
     * @param createRegistryRequest
     * @return Result of the CreateRegistry operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRegistryResponse createRegistry(CreateRegistryRequest createRegistryRequest) throws InvalidInputException,
            AccessDeniedException, AlreadyExistsException, ResourceNumberLimitExceededException, ConcurrentModificationException,
            InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRegistryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRegistryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRegistryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRegistryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRegistry");

            return clientHandler.execute(new ClientExecutionParams<CreateRegistryRequest, CreateRegistryResponse>()
                    .withOperationName("CreateRegistry").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRegistryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRegistryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new schema set and registers the schema definition. Returns an error if the schema set already exists
     * without actually registering the version.
     * </p>
     * <p>
     * When the schema set is created, a version checkpoint will be set to the first version. Compatibility mode
     * "DISABLED" restricts any additional schema versions from being added after the first schema version. For all
     * other compatibility modes, validation of compatibility settings will be applied only from the second version
     * onwards when the <code>RegisterSchemaVersion</code> API is used.
     * </p>
     * <p>
     * When this API is called without a <code>RegistryId</code>, this will create an entry for a "default-registry" in
     * the registry database tables, if it is not already present.
     * </p>
     *
     * @param createSchemaRequest
     * @return Result of the CreateSchema operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSchemaResponse createSchema(CreateSchemaRequest createSchemaRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, AlreadyExistsException, ResourceNumberLimitExceededException,
            ConcurrentModificationException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSchemaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSchemaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSchema");

            return clientHandler.execute(new ClientExecutionParams<CreateSchemaRequest, CreateSchemaResponse>()
                    .withOperationName("CreateSchema").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSchemaRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSchemaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Transforms a directed acyclic graph (DAG) into code.
     * </p>
     *
     * @param createScriptRequest
     * @return Result of the CreateScript operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateScriptResponse createScript(CreateScriptRequest createScriptRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateScriptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateScriptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createScriptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createScriptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateScript");

            return clientHandler.execute(new ClientExecutionParams<CreateScriptRequest, CreateScriptResponse>()
                    .withOperationName("CreateScript").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createScriptRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateScriptRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new security configuration. A security configuration is a set of security properties that can be used
     * by Glue. You can use a security configuration to encrypt data at rest. For information about using security
     * configurations in Glue, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html">Encrypting Data Written
     * by Crawlers, Jobs, and Development Endpoints</a>.
     * </p>
     *
     * @param createSecurityConfigurationRequest
     * @return Result of the CreateSecurityConfiguration operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSecurityConfigurationResponse createSecurityConfiguration(
            CreateSecurityConfigurationRequest createSecurityConfigurationRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSecurityConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSecurityConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSecurityConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSecurityConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSecurityConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateSecurityConfigurationRequest, CreateSecurityConfigurationResponse>()
                            .withOperationName("CreateSecurityConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createSecurityConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateSecurityConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new session.
     * </p>
     *
     * @param createSessionRequest
     *        Request to create a new session.
     * @return Result of the CreateSession operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSessionResponse createSession(CreateSessionRequest createSessionRequest) throws AccessDeniedException,
            IdempotentParameterMismatchException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            ValidationException, AlreadyExistsException, ResourceNumberLimitExceededException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSession");

            return clientHandler.execute(new ClientExecutionParams<CreateSessionRequest, CreateSessionResponse>()
                    .withOperationName("CreateSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new table definition in the Data Catalog.
     * </p>
     *
     * @param createTableRequest
     * @return Result of the CreateTable operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws ResourceNotReadyException
     *         A resource was not ready for a transaction.
     * @throws FederationSourceException
     *         A federation source failed.
     * @throws FederationSourceRetryableException
     *         A federation source failed, but the operation may be retried.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws AlreadyExistsException,
            InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException, InternalServiceException,
            OperationTimeoutException, GlueEncryptionException, ConcurrentModificationException, ResourceNotReadyException,
            FederationSourceException, FederationSourceRetryableException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTable");

            return clientHandler.execute(new ClientExecutionParams<CreateTableRequest, CreateTableResponse>()
                    .withOperationName("CreateTable").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createTableRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new table optimizer for a specific function.
     * </p>
     *
     * @param createTableOptimizerRequest
     * @return Result of the CreateTableOptimizer operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ValidationException
     *         A value could not be validated.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ThrottlingException
     *         The throttling threshhold was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTableOptimizer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTableOptimizerResponse createTableOptimizer(CreateTableOptimizerRequest createTableOptimizerRequest)
            throws EntityNotFoundException, ValidationException, InvalidInputException, AccessDeniedException,
            AlreadyExistsException, InternalServiceException, ThrottlingException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTableOptimizerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTableOptimizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTableOptimizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTableOptimizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTableOptimizer");

            return clientHandler.execute(new ClientExecutionParams<CreateTableOptimizerRequest, CreateTableOptimizerResponse>()
                    .withOperationName("CreateTableOptimizer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTableOptimizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTableOptimizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new trigger.
     * </p>
     * <p>
     * Job arguments may be logged. Do not pass plaintext secrets as arguments. Retrieve secrets from a Glue Connection,
     * Amazon Web Services Secrets Manager or other secret management mechanism if you intend to keep them within the
     * Job.
     * </p>
     *
     * @param createTriggerRequest
     * @return Result of the CreateTrigger operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTriggerResponse createTrigger(CreateTriggerRequest createTriggerRequest) throws AlreadyExistsException,
            EntityNotFoundException, InvalidInputException, IdempotentParameterMismatchException, InternalServiceException,
            OperationTimeoutException, ResourceNumberLimitExceededException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTriggerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTriggerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTriggerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTriggerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrigger");

            return clientHandler.execute(new ClientExecutionParams<CreateTriggerRequest, CreateTriggerResponse>()
                    .withOperationName("CreateTrigger").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTriggerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTriggerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Glue usage profile.
     * </p>
     *
     * @param createUsageProfileRequest
     * @return Result of the CreateUsageProfile operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws OperationNotSupportedException
     *         The operation is not available in the region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateUsageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUsageProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUsageProfileResponse createUsageProfile(CreateUsageProfileRequest createUsageProfileRequest)
            throws InvalidInputException, InternalServiceException, AlreadyExistsException, OperationTimeoutException,
            ResourceNumberLimitExceededException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUsageProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUsageProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUsageProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsageProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsageProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateUsageProfileRequest, CreateUsageProfileResponse>()
                    .withOperationName("CreateUsageProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createUsageProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUsageProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new function definition in the Data Catalog.
     * </p>
     *
     * @param createUserDefinedFunctionRequest
     * @return Result of the CreateUserDefinedFunction operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateUserDefinedFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUserDefinedFunctionResponse createUserDefinedFunction(
            CreateUserDefinedFunctionRequest createUserDefinedFunctionRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, EntityNotFoundException, OperationTimeoutException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserDefinedFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUserDefinedFunctionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserDefinedFunctionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserDefinedFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserDefinedFunction");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateUserDefinedFunctionRequest, CreateUserDefinedFunctionResponse>()
                            .withOperationName("CreateUserDefinedFunction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createUserDefinedFunctionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateUserDefinedFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new workflow.
     * </p>
     *
     * @param createWorkflowRequest
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ResourceNumberLimitExceededException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkflowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkflow");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkflowRequest, CreateWorkflowResponse>()
                    .withOperationName("CreateWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWorkflowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing blueprint.
     * </p>
     *
     * @param deleteBlueprintRequest
     * @return Result of the DeleteBlueprint operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBlueprintResponse deleteBlueprint(DeleteBlueprintRequest deleteBlueprintRequest) throws InvalidInputException,
            OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBlueprintResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBlueprintResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBlueprintRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBlueprintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBlueprint");

            return clientHandler.execute(new ClientExecutionParams<DeleteBlueprintRequest, DeleteBlueprintResponse>()
                    .withOperationName("DeleteBlueprint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBlueprintRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBlueprintRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified catalog from the Glue Data Catalog.
     * </p>
     * <p>
     * After completing this operation, you no longer have access to the databases, tables (and all table versions and
     * partitions that might belong to the tables) and the user-defined functions in the deleted catalog. Glue deletes
     * these "orphaned" resources asynchronously in a timely manner, at the discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources before calling the <code>DeleteCatalog</code>
     * operation, use <code>DeleteTableVersion</code> (or <code>BatchDeleteTableVersion</code>),
     * <code>DeletePartition</code> (or <code>BatchDeletePartition</code>), <code>DeleteTable</code> (or
     * <code>BatchDeleteTable</code>), <code>DeleteUserDefinedFunction</code> and <code>DeleteDatabase</code> to delete
     * any resources that belong to the catalog.
     * </p>
     *
     * @param deleteCatalogRequest
     * @return Result of the DeleteCatalog operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws FederationSourceException
     *         A federation source failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCatalogResponse deleteCatalog(DeleteCatalogRequest deleteCatalogRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            ConcurrentModificationException, AccessDeniedException, FederationSourceException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCatalogResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCatalog");

            return clientHandler.execute(new ClientExecutionParams<DeleteCatalogRequest, DeleteCatalogResponse>()
                    .withOperationName("DeleteCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a classifier from the Data Catalog.
     * </p>
     *
     * @param deleteClassifierRequest
     * @return Result of the DeleteClassifier operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteClassifierResponse deleteClassifier(DeleteClassifierRequest deleteClassifierRequest)
            throws EntityNotFoundException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteClassifierResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteClassifierResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClassifierRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClassifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClassifier");

            return clientHandler.execute(new ClientExecutionParams<DeleteClassifierRequest, DeleteClassifierResponse>()
                    .withOperationName("DeleteClassifier").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteClassifierRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteClassifierRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the partition column statistics of a column.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeletePartition</code>.
     * </p>
     *
     * @param deleteColumnStatisticsForPartitionRequest
     * @return Result of the DeleteColumnStatisticsForPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteColumnStatisticsForPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteColumnStatisticsForPartitionResponse deleteColumnStatisticsForPartition(
            DeleteColumnStatisticsForPartitionRequest deleteColumnStatisticsForPartitionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteColumnStatisticsForPartitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteColumnStatisticsForPartitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteColumnStatisticsForPartitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteColumnStatisticsForPartitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteColumnStatisticsForPartition");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteColumnStatisticsForPartitionRequest, DeleteColumnStatisticsForPartitionResponse>()
                            .withOperationName("DeleteColumnStatisticsForPartition").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteColumnStatisticsForPartitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteColumnStatisticsForPartitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeleteTable</code>.
     * </p>
     *
     * @param deleteColumnStatisticsForTableRequest
     * @return Result of the DeleteColumnStatisticsForTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteColumnStatisticsForTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteColumnStatisticsForTableResponse deleteColumnStatisticsForTable(
            DeleteColumnStatisticsForTableRequest deleteColumnStatisticsForTableRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteColumnStatisticsForTableResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteColumnStatisticsForTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetResourceNotFoundException::builder).build());
            case "IllegalBlueprintStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalBlueprintStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalBlueprintStateException::builder).build());
            case "InvalidStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidStateException::builder).build());
            case "FederatedResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederatedResourceAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederatedResourceAlreadyExistsException::builder).build());
            case "NoScheduleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoScheduleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoScheduleException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ConcurrentRunsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConditionCheckFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteColumnStatisticsForTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteColumnStatisticsForTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteColumnStatisticsForTable");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteColumnStatisticsForTableRequest, DeleteColumnStatisticsForTableResponse>()
                            .withOperationName("DeleteColumnStatisticsForTable").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteColumnStatisticsForTableRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteColumnStatisticsForTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes settings for a column statistics task.
     * </p>
     *
     * @param deleteColumnStatisticsTaskSettingsRequest
     * @return Result of the DeleteColumnStatisticsTaskSettings operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteColumnStatisticsTaskSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsTaskSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteColumnStatisticsTaskSettingsResponse deleteColumnStatisticsTaskSettings(
            DeleteColumnStatisticsTaskSettingsRequest deleteColumnStatisticsTaskSettingsRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteColumnStatisticsTaskSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteColumnStatisticsTaskSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "SchedulerTransitioningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build());
            case "IntegrationNotFoundFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationNotFoundException::builder).build());
            case "IllegalSessionStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalSessionStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalSessionStateException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "KMSKeyNotAccessibleFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "IntegrationConflictOperationFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).build());
            case "CrawlerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerRunningException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "CrawlerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build());
            case "GlueEncryptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GlueEncryptionException::builder).build());
            case "OperationTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationTimeoutException::builder).build());
            case "ColumnStatisticsTaskRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskRunningException::builder).build());
            case "ColumnStatisticsTaskStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskStoppingException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskStoppingException::builder).build());
            case "VersionMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(VersionMismatchException::builder).build());
            case "IntegrationQuotaExceededFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).build());
            case "MLTransformNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "IllegalWorkflowStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build());
            case "ResourceNumberLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
            case "SchedulerNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build());
            case "InvalidIntegrationStateFault":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIntegrationStateFault").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIntegrationStateException::builder).build());
            case "SchedulerRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SchedulerRunningException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SchedulerRunningException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ColumnStatisticsTaskNotRunningException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ColumnStatisticsTaskNotRunningException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ColumnStatisticsTaskNotRunningException::builder).build());
            case "CrawlerStoppingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CrawlerStoppingException::builder).build());
            case "FederationSourceRetryableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceRetryableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FederationSourceRetryableException::builder).build());
            case "FederationSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FederationSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FederationSourceException::builder).build());
            case "EntityNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
            case "PermissionTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
            case "TargetResourceNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetResourceNotFound").h