/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a blueprint run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlueprintRun implements SdkPojo, Serializable, ToCopyableBuilder<BlueprintRun.Builder, BlueprintRun> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueprintName").getter(getter(BlueprintRun::blueprintName)).setter(setter(Builder::blueprintName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintName").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(BlueprintRun::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowName").getter(getter(BlueprintRun::workflowName)).setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(BlueprintRun::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedOn").getter(getter(BlueprintRun::startedOn)).setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedOn").getter(getter(BlueprintRun::completedOn)).setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(BlueprintRun::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> ROLLBACK_ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RollbackErrorMessage").getter(getter(BlueprintRun::rollbackErrorMessage))
            .setter(setter(Builder::rollbackErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackErrorMessage").build())
            .build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Parameters").getter(getter(BlueprintRun::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(BlueprintRun::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD,
            RUN_ID_FIELD, WORKFLOW_NAME_FIELD, STATE_FIELD, STARTED_ON_FIELD, COMPLETED_ON_FIELD, ERROR_MESSAGE_FIELD,
            ROLLBACK_ERROR_MESSAGE_FIELD, PARAMETERS_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String blueprintName;

    private final String runId;

    private final String workflowName;

    private final String state;

    private final Instant startedOn;

    private final Instant completedOn;

    private final String errorMessage;

    private final String rollbackErrorMessage;

    private final String parameters;

    private final String roleArn;

    private BlueprintRun(BuilderImpl builder) {
        this.blueprintName = builder.blueprintName;
        this.runId = builder.runId;
        this.workflowName = builder.workflowName;
        this.state = builder.state;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
        this.errorMessage = builder.errorMessage;
        this.rollbackErrorMessage = builder.rollbackErrorMessage;
        this.parameters = builder.parameters;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the blueprint.
     * </p>
     * 
     * @return The name of the blueprint.
     */
    public final String blueprintName() {
        return blueprintName;
    }

    /**
     * <p>
     * The run ID for this blueprint run.
     * </p>
     * 
     * @return The run ID for this blueprint run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The name of a workflow that is created as a result of a successful blueprint run. If a blueprint run has an
     * error, there will not be a workflow created.
     * </p>
     * 
     * @return The name of a workflow that is created as a result of a successful blueprint run. If a blueprint run has
     *         an error, there will not be a workflow created.
     */
    public final String workflowName() {
        return workflowName;
    }

    /**
     * <p>
     * The state of the blueprint run. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running — The blueprint run is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded — The blueprint run completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed — The blueprint run failed and rollback is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * Rolling Back — The blueprint run failed and rollback is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BlueprintRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the blueprint run. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running — The blueprint run is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded — The blueprint run completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed — The blueprint run failed and rollback is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Rolling Back — The blueprint run failed and rollback is in progress.
     *         </p>
     *         </li>
     * @see BlueprintRunState
     */
    public final BlueprintRunState state() {
        return BlueprintRunState.fromValue(state);
    }

    /**
     * <p>
     * The state of the blueprint run. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running — The blueprint run is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded — The blueprint run completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed — The blueprint run failed and rollback is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * Rolling Back — The blueprint run failed and rollback is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BlueprintRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the blueprint run. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running — The blueprint run is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded — The blueprint run completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed — The blueprint run failed and rollback is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Rolling Back — The blueprint run failed and rollback is in progress.
     *         </p>
     *         </li>
     * @see BlueprintRunState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time that the blueprint run started.
     * </p>
     * 
     * @return The date and time that the blueprint run started.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * The date and time that the blueprint run completed.
     * </p>
     * 
     * @return The date and time that the blueprint run completed.
     */
    public final Instant completedOn() {
        return completedOn;
    }

    /**
     * <p>
     * Indicates any errors that are seen while running the blueprint.
     * </p>
     * 
     * @return Indicates any errors that are seen while running the blueprint.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * If there are any errors while creating the entities of a workflow, we try to roll back the created entities until
     * that point and delete them. This attribute indicates the errors seen while trying to delete the entities that are
     * created.
     * </p>
     * 
     * @return If there are any errors while creating the entities of a workflow, we try to roll back the created
     *         entities until that point and delete them. This attribute indicates the errors seen while trying to
     *         delete the entities that are created.
     */
    public final String rollbackErrorMessage() {
        return rollbackErrorMessage;
    }

    /**
     * <p>
     * The blueprint parameters as a string. You will have to provide a value for each key that is required from the
     * parameter spec that is defined in the <code>Blueprint$ParameterSpec</code>.
     * </p>
     * 
     * @return The blueprint parameters as a string. You will have to provide a value for each key that is required from
     *         the parameter spec that is defined in the <code>Blueprint$ParameterSpec</code>.
     */
    public final String parameters() {
        return parameters;
    }

    /**
     * <p>
     * The role ARN. This role will be assumed by the Glue service and will be used to create the workflow and other
     * entities of a workflow.
     * </p>
     * 
     * @return The role ARN. This role will be assumed by the Glue service and will be used to create the workflow and
     *         other entities of a workflow.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueprintRun)) {
            return false;
        }
        BlueprintRun other = (BlueprintRun) obj;
        return Objects.equals(blueprintName(), other.blueprintName()) && Objects.equals(runId(), other.runId())
                && Objects.equals(workflowName(), other.workflowName()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(startedOn(), other.startedOn()) && Objects.equals(completedOn(), other.completedOn())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(rollbackErrorMessage(), other.rollbackErrorMessage())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlueprintRun").add("BlueprintName", blueprintName()).add("RunId", runId())
                .add("WorkflowName", workflowName()).add("State", stateAsString()).add("StartedOn", startedOn())
                .add("CompletedOn", completedOn()).add("ErrorMessage", errorMessage())
                .add("RollbackErrorMessage", rollbackErrorMessage()).add("Parameters", parameters()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueprintName":
            return Optional.ofNullable(clazz.cast(blueprintName()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "WorkflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "CompletedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "RollbackErrorMessage":
            return Optional.ofNullable(clazz.cast(rollbackErrorMessage()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlueprintName", BLUEPRINT_NAME_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        map.put("WorkflowName", WORKFLOW_NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StartedOn", STARTED_ON_FIELD);
        map.put("CompletedOn", COMPLETED_ON_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("RollbackErrorMessage", ROLLBACK_ERROR_MESSAGE_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlueprintRun, T> g) {
        return obj -> g.apply((BlueprintRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlueprintRun> {
        /**
         * <p>
         * The name of the blueprint.
         * </p>
         * 
         * @param blueprintName
         *        The name of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * <p>
         * The run ID for this blueprint run.
         * </p>
         * 
         * @param runId
         *        The run ID for this blueprint run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The name of a workflow that is created as a result of a successful blueprint run. If a blueprint run has an
         * error, there will not be a workflow created.
         * </p>
         * 
         * @param workflowName
         *        The name of a workflow that is created as a result of a successful blueprint run. If a blueprint run
         *        has an error, there will not be a workflow created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);

        /**
         * <p>
         * The state of the blueprint run. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running — The blueprint run is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded — The blueprint run completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed — The blueprint run failed and rollback is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * Rolling Back — The blueprint run failed and rollback is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state of the blueprint run. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running — The blueprint run is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded — The blueprint run completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed — The blueprint run failed and rollback is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Rolling Back — The blueprint run failed and rollback is in progress.
         *        </p>
         *        </li>
         * @see BlueprintRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintRunState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the blueprint run. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running — The blueprint run is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded — The blueprint run completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed — The blueprint run failed and rollback is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * Rolling Back — The blueprint run failed and rollback is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state of the blueprint run. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running — The blueprint run is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded — The blueprint run completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed — The blueprint run failed and rollback is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Rolling Back — The blueprint run failed and rollback is in progress.
         *        </p>
         *        </li>
         * @see BlueprintRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintRunState
         */
        Builder state(BlueprintRunState state);

        /**
         * <p>
         * The date and time that the blueprint run started.
         * </p>
         * 
         * @param startedOn
         *        The date and time that the blueprint run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);

        /**
         * <p>
         * The date and time that the blueprint run completed.
         * </p>
         * 
         * @param completedOn
         *        The date and time that the blueprint run completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Instant completedOn);

        /**
         * <p>
         * Indicates any errors that are seen while running the blueprint.
         * </p>
         * 
         * @param errorMessage
         *        Indicates any errors that are seen while running the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * If there are any errors while creating the entities of a workflow, we try to roll back the created entities
         * until that point and delete them. This attribute indicates the errors seen while trying to delete the
         * entities that are created.
         * </p>
         * 
         * @param rollbackErrorMessage
         *        If there are any errors while creating the entities of a workflow, we try to roll back the created
         *        entities until that point and delete them. This attribute indicates the errors seen while trying to
         *        delete the entities that are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackErrorMessage(String rollbackErrorMessage);

        /**
         * <p>
         * The blueprint parameters as a string. You will have to provide a value for each key that is required from the
         * parameter spec that is defined in the <code>Blueprint$ParameterSpec</code>.
         * </p>
         * 
         * @param parameters
         *        The blueprint parameters as a string. You will have to provide a value for each key that is required
         *        from the parameter spec that is defined in the <code>Blueprint$ParameterSpec</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        /**
         * <p>
         * The role ARN. This role will be assumed by the Glue service and will be used to create the workflow and other
         * entities of a workflow.
         * </p>
         * 
         * @param roleArn
         *        The role ARN. This role will be assumed by the Glue service and will be used to create the workflow
         *        and other entities of a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintName;

        private String runId;

        private String workflowName;

        private String state;

        private Instant startedOn;

        private Instant completedOn;

        private String errorMessage;

        private String rollbackErrorMessage;

        private String parameters;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueprintRun model) {
            blueprintName(model.blueprintName);
            runId(model.runId);
            workflowName(model.workflowName);
            state(model.state);
            startedOn(model.startedOn);
            completedOn(model.completedOn);
            errorMessage(model.errorMessage);
            rollbackErrorMessage(model.rollbackErrorMessage);
            parameters(model.parameters);
            roleArn(model.roleArn);
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BlueprintRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getRollbackErrorMessage() {
            return rollbackErrorMessage;
        }

        public final void setRollbackErrorMessage(String rollbackErrorMessage) {
            this.rollbackErrorMessage = rollbackErrorMessage;
        }

        @Override
        public final Builder rollbackErrorMessage(String rollbackErrorMessage) {
            this.rollbackErrorMessage = rollbackErrorMessage;
            return this;
        }

        public final String getParameters() {
            return parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public BlueprintRun build() {
            return new BlueprintRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
