/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties associated with the integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrationConfig.Builder, IntegrationConfig> {
    private static final SdkField<String> REFRESH_INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshInterval").getter(getter(IntegrationConfig::refreshInterval))
            .setter(setter(Builder::refreshInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshInterval").build()).build();

    private static final SdkField<Map<String, String>> SOURCE_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("SourceProperties")
            .getter(getter(IntegrationConfig::sourceProperties))
            .setter(setter(Builder::sourceProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFRESH_INTERVAL_FIELD,
            SOURCE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String refreshInterval;

    private final Map<String, String> sourceProperties;

    private IntegrationConfig(BuilderImpl builder) {
        this.refreshInterval = builder.refreshInterval;
        this.sourceProperties = builder.sourceProperties;
    }

    /**
     * <p>
     * Specifies the frequency at which CDC (Change Data Capture) pulls or incremental loads should occur. This
     * parameter provides flexibility to align the refresh rate with your specific data update patterns, system load
     * considerations, and performance optimization goals. Time increment can be set from 15 minutes to 8640 minutes
     * (six days). Currently supports creation of <code>RefreshInterval</code> only.
     * </p>
     * 
     * @return Specifies the frequency at which CDC (Change Data Capture) pulls or incremental loads should occur. This
     *         parameter provides flexibility to align the refresh rate with your specific data update patterns, system
     *         load considerations, and performance optimization goals. Time increment can be set from 15 minutes to
     *         8640 minutes (six days). Currently supports creation of <code>RefreshInterval</code> only.
     */
    public final String refreshInterval() {
        return refreshInterval;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceProperties() {
        return sourceProperties != null && !(sourceProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of key-value pairs that specify additional properties for the integration source. These properties
     * provide configuration options that can be used to customize the behavior of the ODB source during data
     * integration operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceProperties} method.
     * </p>
     * 
     * @return A collection of key-value pairs that specify additional properties for the integration source. These
     *         properties provide configuration options that can be used to customize the behavior of the ODB source
     *         during data integration operations.
     */
    public final Map<String, String> sourceProperties() {
        return sourceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(refreshInterval());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceProperties() ? sourceProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationConfig)) {
            return false;
        }
        IntegrationConfig other = (IntegrationConfig) obj;
        return Objects.equals(refreshInterval(), other.refreshInterval()) && hasSourceProperties() == other.hasSourceProperties()
                && Objects.equals(sourceProperties(), other.sourceProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrationConfig").add("RefreshInterval", refreshInterval())
                .add("SourceProperties", hasSourceProperties() ? sourceProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefreshInterval":
            return Optional.ofNullable(clazz.cast(refreshInterval()));
        case "SourceProperties":
            return Optional.ofNullable(clazz.cast(sourceProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RefreshInterval", REFRESH_INTERVAL_FIELD);
        map.put("SourceProperties", SOURCE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrationConfig, T> g) {
        return obj -> g.apply((IntegrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrationConfig> {
        /**
         * <p>
         * Specifies the frequency at which CDC (Change Data Capture) pulls or incremental loads should occur. This
         * parameter provides flexibility to align the refresh rate with your specific data update patterns, system load
         * considerations, and performance optimization goals. Time increment can be set from 15 minutes to 8640 minutes
         * (six days). Currently supports creation of <code>RefreshInterval</code> only.
         * </p>
         * 
         * @param refreshInterval
         *        Specifies the frequency at which CDC (Change Data Capture) pulls or incremental loads should occur.
         *        This parameter provides flexibility to align the refresh rate with your specific data update patterns,
         *        system load considerations, and performance optimization goals. Time increment can be set from 15
         *        minutes to 8640 minutes (six days). Currently supports creation of <code>RefreshInterval</code> only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshInterval(String refreshInterval);

        /**
         * <p>
         * A collection of key-value pairs that specify additional properties for the integration source. These
         * properties provide configuration options that can be used to customize the behavior of the ODB source during
         * data integration operations.
         * </p>
         * 
         * @param sourceProperties
         *        A collection of key-value pairs that specify additional properties for the integration source. These
         *        properties provide configuration options that can be used to customize the behavior of the ODB source
         *        during data integration operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProperties(Map<String, String> sourceProperties);
    }

    static final class BuilderImpl implements Builder {
        private String refreshInterval;

        private Map<String, String> sourceProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationConfig model) {
            refreshInterval(model.refreshInterval);
            sourceProperties(model.sourceProperties);
        }

        public final String getRefreshInterval() {
            return refreshInterval;
        }

        public final void setRefreshInterval(String refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        @Override
        public final Builder refreshInterval(String refreshInterval) {
            this.refreshInterval = refreshInterval;
            return this;
        }

        public final Map<String, String> getSourceProperties() {
            if (sourceProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return sourceProperties;
        }

        public final void setSourceProperties(Map<String, String> sourceProperties) {
            this.sourceProperties = IntegrationSourcePropertiesMapCopier.copy(sourceProperties);
        }

        @Override
        public final Builder sourceProperties(Map<String, String> sourceProperties) {
            this.sourceProperties = IntegrationSourcePropertiesMapCopier.copy(sourceProperties);
            return this;
        }

        @Override
        public IntegrationConfig build() {
            return new IntegrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
