/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCatalogsRequest extends GlueRequest implements
        ToCopyableBuilder<GetCatalogsRequest.Builder, GetCatalogsRequest> {
    private static final SdkField<String> PARENT_CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentCatalogId").getter(getter(GetCatalogsRequest::parentCatalogId))
            .setter(setter(Builder::parentCatalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentCatalogId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCatalogsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetCatalogsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Boolean> RECURSIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Recursive").getter(getter(GetCatalogsRequest::recursive)).setter(setter(Builder::recursive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recursive").build()).build();

    private static final SdkField<Boolean> INCLUDE_ROOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeRoot").getter(getter(GetCatalogsRequest::includeRoot)).setter(setter(Builder::includeRoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeRoot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_CATALOG_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RECURSIVE_FIELD, INCLUDE_ROOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String parentCatalogId;

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean recursive;

    private final Boolean includeRoot;

    private GetCatalogsRequest(BuilderImpl builder) {
        super(builder);
        this.parentCatalogId = builder.parentCatalogId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.recursive = builder.recursive;
        this.includeRoot = builder.includeRoot;
    }

    /**
     * <p>
     * The ID of the parent catalog in which the catalog resides. If none is provided, the Amazon Web Services Account
     * Number is used by default.
     * </p>
     * 
     * @return The ID of the parent catalog in which the catalog resides. If none is provided, the Amazon Web Services
     *         Account Number is used by default.
     */
    public final String parentCatalogId() {
        return parentCatalogId;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of catalogs to return in one response.
     * </p>
     * 
     * @return The maximum number of catalogs to return in one response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Whether to list all catalogs across the catalog hierarchy, starting from the <code>ParentCatalogId</code>.
     * Defaults to <code>false</code> . When <code>true</code>, all catalog objects in the <code>ParentCatalogID</code>
     * hierarchy are enumerated in the response.
     * </p>
     * 
     * @return Whether to list all catalogs across the catalog hierarchy, starting from the <code>ParentCatalogId</code>
     *         . Defaults to <code>false</code> . When <code>true</code>, all catalog objects in the
     *         <code>ParentCatalogID</code> hierarchy are enumerated in the response.
     */
    public final Boolean recursive() {
        return recursive;
    }

    /**
     * <p>
     * Whether to list the default catalog in the account and region in the response. Defaults to <code>false</code>.
     * When <code>true</code> and <code>ParentCatalogId = NULL | Amazon Web Services Account ID</code>, all catalogs and
     * the default catalog are enumerated in the response.
     * </p>
     * <p>
     * When the <code>ParentCatalogId</code> is not equal to null, and this attribute is passed as <code>false</code> or
     * <code>true</code>, an <code>InvalidInputException</code> is thrown.
     * </p>
     * 
     * @return Whether to list the default catalog in the account and region in the response. Defaults to
     *         <code>false</code>. When <code>true</code> and
     *         <code>ParentCatalogId = NULL | Amazon Web Services Account ID</code>, all catalogs and the default
     *         catalog are enumerated in the response.</p>
     *         <p>
     *         When the <code>ParentCatalogId</code> is not equal to null, and this attribute is passed as
     *         <code>false</code> or <code>true</code>, an <code>InvalidInputException</code> is thrown.
     */
    public final Boolean includeRoot() {
        return includeRoot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(parentCatalogId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(recursive());
        hashCode = 31 * hashCode + Objects.hashCode(includeRoot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCatalogsRequest)) {
            return false;
        }
        GetCatalogsRequest other = (GetCatalogsRequest) obj;
        return Objects.equals(parentCatalogId(), other.parentCatalogId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(recursive(), other.recursive())
                && Objects.equals(includeRoot(), other.includeRoot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCatalogsRequest").add("ParentCatalogId", parentCatalogId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Recursive", recursive()).add("IncludeRoot", includeRoot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParentCatalogId":
            return Optional.ofNullable(clazz.cast(parentCatalogId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Recursive":
            return Optional.ofNullable(clazz.cast(recursive()));
        case "IncludeRoot":
            return Optional.ofNullable(clazz.cast(includeRoot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParentCatalogId", PARENT_CATALOG_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Recursive", RECURSIVE_FIELD);
        map.put("IncludeRoot", INCLUDE_ROOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCatalogsRequest, T> g) {
        return obj -> g.apply((GetCatalogsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCatalogsRequest> {
        /**
         * <p>
         * The ID of the parent catalog in which the catalog resides. If none is provided, the Amazon Web Services
         * Account Number is used by default.
         * </p>
         * 
         * @param parentCatalogId
         *        The ID of the parent catalog in which the catalog resides. If none is provided, the Amazon Web
         *        Services Account Number is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentCatalogId(String parentCatalogId);

        /**
         * <p>
         * A continuation token, if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of catalogs to return in one response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of catalogs to return in one response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Whether to list all catalogs across the catalog hierarchy, starting from the <code>ParentCatalogId</code>.
         * Defaults to <code>false</code> . When <code>true</code>, all catalog objects in the
         * <code>ParentCatalogID</code> hierarchy are enumerated in the response.
         * </p>
         * 
         * @param recursive
         *        Whether to list all catalogs across the catalog hierarchy, starting from the
         *        <code>ParentCatalogId</code>. Defaults to <code>false</code> . When <code>true</code>, all catalog
         *        objects in the <code>ParentCatalogID</code> hierarchy are enumerated in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursive(Boolean recursive);

        /**
         * <p>
         * Whether to list the default catalog in the account and region in the response. Defaults to <code>false</code>
         * . When <code>true</code> and <code>ParentCatalogId = NULL | Amazon Web Services Account ID</code>, all
         * catalogs and the default catalog are enumerated in the response.
         * </p>
         * <p>
         * When the <code>ParentCatalogId</code> is not equal to null, and this attribute is passed as
         * <code>false</code> or <code>true</code>, an <code>InvalidInputException</code> is thrown.
         * </p>
         * 
         * @param includeRoot
         *        Whether to list the default catalog in the account and region in the response. Defaults to
         *        <code>false</code>. When <code>true</code> and
         *        <code>ParentCatalogId = NULL | Amazon Web Services Account ID</code>, all catalogs and the default
         *        catalog are enumerated in the response.</p>
         *        <p>
         *        When the <code>ParentCatalogId</code> is not equal to null, and this attribute is passed as
         *        <code>false</code> or <code>true</code>, an <code>InvalidInputException</code> is thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeRoot(Boolean includeRoot);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String parentCatalogId;

        private String nextToken;

        private Integer maxResults;

        private Boolean recursive;

        private Boolean includeRoot;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCatalogsRequest model) {
            super(model);
            parentCatalogId(model.parentCatalogId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            recursive(model.recursive);
            includeRoot(model.includeRoot);
        }

        public final String getParentCatalogId() {
            return parentCatalogId;
        }

        public final void setParentCatalogId(String parentCatalogId) {
            this.parentCatalogId = parentCatalogId;
        }

        @Override
        public final Builder parentCatalogId(String parentCatalogId) {
            this.parentCatalogId = parentCatalogId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getRecursive() {
            return recursive;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final Boolean getIncludeRoot() {
            return includeRoot;
        }

        public final void setIncludeRoot(Boolean includeRoot) {
            this.includeRoot = includeRoot;
        }

        @Override
        public final Builder includeRoot(Boolean includeRoot) {
            this.includeRoot = includeRoot;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCatalogsRequest build() {
            return new GetCatalogsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
