/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowResponse extends GlueResponse implements
        ToCopyableBuilder<GetWorkflowResponse.Builder, GetWorkflowResponse> {
    private static final SdkField<Workflow> WORKFLOW_FIELD = SdkField.<Workflow> builder(MarshallingType.SDK_POJO)
            .memberName("Workflow").getter(getter(GetWorkflowResponse::workflow)).setter(setter(Builder::workflow))
            .constructor(Workflow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Workflow workflow;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.workflow = builder.workflow;
    }

    /**
     * <p>
     * The resource metadata for the workflow.
     * </p>
     * 
     * @return The resource metadata for the workflow.
     */
    public final Workflow workflow() {
        return workflow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse) obj;
        return Objects.equals(workflow(), other.workflow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowResponse").add("Workflow", workflow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workflow":
            return Optional.ofNullable(clazz.cast(workflow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Workflow", WORKFLOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowResponse> {
        /**
         * <p>
         * The resource metadata for the workflow.
         * </p>
         * 
         * @param workflow
         *        The resource metadata for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflow(Workflow workflow);

        /**
         * <p>
         * The resource metadata for the workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link Workflow.Builder} avoiding the need to
         * create one manually via {@link Workflow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Workflow.Builder#build()} is called immediately and its result is
         * passed to {@link #workflow(Workflow)}.
         * 
         * @param workflow
         *        a consumer that will call methods on {@link Workflow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflow(Workflow)
         */
        default Builder workflow(Consumer<Workflow.Builder> workflow) {
            return workflow(Workflow.builder().applyMutation(workflow).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Workflow workflow;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            workflow(model.workflow);
        }

        public final Workflow.Builder getWorkflow() {
            return workflow != null ? workflow.toBuilder() : null;
        }

        public final void setWorkflow(Workflow.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        @Override
        public final Builder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
