/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a single field within an Iceberg table schema, including its identifier, name, data type, nullability, and
 * documentation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergStructField implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergStructField.Builder, IcebergStructField> {
    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(IcebergStructField::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(IcebergStructField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Document> TYPE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT).memberName("Type")
            .getter(getter(IcebergStructField::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Required").getter(getter(IcebergStructField::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required").build()).build();

    private static final SdkField<String> DOC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Doc")
            .getter(getter(IcebergStructField::doc)).setter(setter(Builder::doc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Doc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            TYPE_FIELD, REQUIRED_FIELD, DOC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer id;

    private final String name;

    private final Document type;

    private final Boolean required;

    private final String doc;

    private IcebergStructField(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.required = builder.required;
        this.doc = builder.doc;
    }

    /**
     * <p>
     * The unique identifier assigned to this field within the Iceberg table schema, used for schema evolution and field
     * tracking.
     * </p>
     * 
     * @return The unique identifier assigned to this field within the Iceberg table schema, used for schema evolution
     *         and field tracking.
     */
    public final Integer id() {
        return id;
    }

    /**
     * <p>
     * The name of the field as it appears in the table schema and query operations.
     * </p>
     * 
     * @return The name of the field as it appears in the table schema and query operations.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data type definition for this field, specifying the structure and format of the data it contains.
     * </p>
     * 
     * @return The data type definition for this field, specifying the structure and format of the data it contains.
     */
    public final Document type() {
        return type;
    }

    /**
     * <p>
     * Indicates whether this field is required (non-nullable) or optional (nullable) in the table schema.
     * </p>
     * 
     * @return Indicates whether this field is required (non-nullable) or optional (nullable) in the table schema.
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * Optional documentation or description text that provides additional context about the purpose and usage of this
     * field.
     * </p>
     * 
     * @return Optional documentation or description text that provides additional context about the purpose and usage
     *         of this field.
     */
    public final String doc() {
        return doc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(doc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergStructField)) {
            return false;
        }
        IcebergStructField other = (IcebergStructField) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && Objects.equals(required(), other.required()) && Objects.equals(doc(), other.doc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergStructField").add("Id", id()).add("Name", name()).add("Type", type())
                .add("Required", required()).add("Doc", doc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Required":
            return Optional.ofNullable(clazz.cast(required()));
        case "Doc":
            return Optional.ofNullable(clazz.cast(doc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Required", REQUIRED_FIELD);
        map.put("Doc", DOC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergStructField, T> g) {
        return obj -> g.apply((IcebergStructField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergStructField> {
        /**
         * <p>
         * The unique identifier assigned to this field within the Iceberg table schema, used for schema evolution and
         * field tracking.
         * </p>
         * 
         * @param id
         *        The unique identifier assigned to this field within the Iceberg table schema, used for schema
         *        evolution and field tracking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * <p>
         * The name of the field as it appears in the table schema and query operations.
         * </p>
         * 
         * @param name
         *        The name of the field as it appears in the table schema and query operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type definition for this field, specifying the structure and format of the data it contains.
         * </p>
         * 
         * @param type
         *        The data type definition for this field, specifying the structure and format of the data it contains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Document type);

        /**
         * <p>
         * Indicates whether this field is required (non-nullable) or optional (nullable) in the table schema.
         * </p>
         * 
         * @param required
         *        Indicates whether this field is required (non-nullable) or optional (nullable) in the table schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * Optional documentation or description text that provides additional context about the purpose and usage of
         * this field.
         * </p>
         * 
         * @param doc
         *        Optional documentation or description text that provides additional context about the purpose and
         *        usage of this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doc(String doc);
    }

    static final class BuilderImpl implements Builder {
        private Integer id;

        private String name;

        private Document type;

        private Boolean required;

        private String doc;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergStructField model) {
            id(model.id);
            name(model.name);
            type(model.type);
            required(model.required);
            doc(model.doc);
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Document getType() {
            return type;
        }

        public final void setType(Document type) {
            this.type = type;
        }

        @Override
        public final Builder type(Document type) {
            this.type = type;
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final String getDoc() {
            return doc;
        }

        public final void setDoc(String doc) {
            this.doc = doc;
        }

        @Override
        public final Builder doc(String doc) {
            this.doc = doc;
            return this;
        }

        @Override
        public IcebergStructField build() {
            return new IcebergStructField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
