/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria that are used to filter the task runs for the machine learning transform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskRunFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskRunFilterCriteria.Builder, TaskRunFilterCriteria> {
    private static final SdkField<String> TASK_RUN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskRunType").getter(getter(TaskRunFilterCriteria::taskRunTypeAsString))
            .setter(setter(Builder::taskRunType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRunType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TaskRunFilterCriteria::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> STARTED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedBefore").getter(getter(TaskRunFilterCriteria::startedBefore))
            .setter(setter(Builder::startedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedBefore").build()).build();

    private static final SdkField<Instant> STARTED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAfter").getter(getter(TaskRunFilterCriteria::startedAfter)).setter(setter(Builder::startedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_RUN_TYPE_FIELD,
            STATUS_FIELD, STARTED_BEFORE_FIELD, STARTED_AFTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String taskRunType;

    private final String status;

    private final Instant startedBefore;

    private final Instant startedAfter;

    private TaskRunFilterCriteria(BuilderImpl builder) {
        this.taskRunType = builder.taskRunType;
        this.status = builder.status;
        this.startedBefore = builder.startedBefore;
        this.startedAfter = builder.startedAfter;
    }

    /**
     * <p>
     * The type of task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunType} will
     * return {@link TaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunTypeAsString}.
     * </p>
     * 
     * @return The type of task run.
     * @see TaskType
     */
    public final TaskType taskRunType() {
        return TaskType.fromValue(taskRunType);
    }

    /**
     * <p>
     * The type of task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunType} will
     * return {@link TaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunTypeAsString}.
     * </p>
     * 
     * @return The type of task run.
     * @see TaskType
     */
    public final String taskRunTypeAsString() {
        return taskRunType;
    }

    /**
     * <p>
     * The current status of the task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the task run.
     * @see TaskStatusType
     */
    public final TaskStatusType status() {
        return TaskStatusType.fromValue(status);
    }

    /**
     * <p>
     * The current status of the task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the task run.
     * @see TaskStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Filter on task runs started before this date.
     * </p>
     * 
     * @return Filter on task runs started before this date.
     */
    public final Instant startedBefore() {
        return startedBefore;
    }

    /**
     * <p>
     * Filter on task runs started after this date.
     * </p>
     * 
     * @return Filter on task runs started after this date.
     */
    public final Instant startedAfter() {
        return startedAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskRunTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(startedAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRunFilterCriteria)) {
            return false;
        }
        TaskRunFilterCriteria other = (TaskRunFilterCriteria) obj;
        return Objects.equals(taskRunTypeAsString(), other.taskRunTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startedBefore(), other.startedBefore()) && Objects.equals(startedAfter(), other.startedAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskRunFilterCriteria").add("TaskRunType", taskRunTypeAsString())
                .add("Status", statusAsString()).add("StartedBefore", startedBefore()).add("StartedAfter", startedAfter())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskRunType":
            return Optional.ofNullable(clazz.cast(taskRunTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartedBefore":
            return Optional.ofNullable(clazz.cast(startedBefore()));
        case "StartedAfter":
            return Optional.ofNullable(clazz.cast(startedAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskRunType", TASK_RUN_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartedBefore", STARTED_BEFORE_FIELD);
        map.put("StartedAfter", STARTED_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskRunFilterCriteria, T> g) {
        return obj -> g.apply((TaskRunFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskRunFilterCriteria> {
        /**
         * <p>
         * The type of task run.
         * </p>
         * 
         * @param taskRunType
         *        The type of task run.
         * @see TaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskType
         */
        Builder taskRunType(String taskRunType);

        /**
         * <p>
         * The type of task run.
         * </p>
         * 
         * @param taskRunType
         *        The type of task run.
         * @see TaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskType
         */
        Builder taskRunType(TaskType taskRunType);

        /**
         * <p>
         * The current status of the task run.
         * </p>
         * 
         * @param status
         *        The current status of the task run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the task run.
         * </p>
         * 
         * @param status
         *        The current status of the task run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(TaskStatusType status);

        /**
         * <p>
         * Filter on task runs started before this date.
         * </p>
         * 
         * @param startedBefore
         *        Filter on task runs started before this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBefore(Instant startedBefore);

        /**
         * <p>
         * Filter on task runs started after this date.
         * </p>
         * 
         * @param startedAfter
         *        Filter on task runs started after this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAfter(Instant startedAfter);
    }

    static final class BuilderImpl implements Builder {
        private String taskRunType;

        private String status;

        private Instant startedBefore;

        private Instant startedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskRunFilterCriteria model) {
            taskRunType(model.taskRunType);
            status(model.status);
            startedBefore(model.startedBefore);
            startedAfter(model.startedAfter);
        }

        public final String getTaskRunType() {
            return taskRunType;
        }

        public final void setTaskRunType(String taskRunType) {
            this.taskRunType = taskRunType;
        }

        @Override
        public final Builder taskRunType(String taskRunType) {
            this.taskRunType = taskRunType;
            return this;
        }

        @Override
        public final Builder taskRunType(TaskType taskRunType) {
            this.taskRunType(taskRunType == null ? null : taskRunType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedBefore() {
            return startedBefore;
        }

        public final void setStartedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
        }

        @Override
        public final Builder startedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
            return this;
        }

        public final Instant getStartedAfter() {
            return startedAfter;
        }

        public final void setStartedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
        }

        @Override
        public final Builder startedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
            return this;
        }

        @Override
        public TaskRunFilterCriteria build() {
            return new TaskRunFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
