/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PropertyType {
    USER_INPUT("USER_INPUT"),
    SECRET("SECRET"),
    READ_ONLY("READ_ONLY"),
    UNUSED("UNUSED"),
    SECRET_OR_USER_INPUT("SECRET_OR_USER_INPUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PropertyType> VALUE_MAP;
    private final String value;

    private PropertyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PropertyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PropertyType> knownValues() {
        EnumSet<PropertyType> knownValues = EnumSet.allOf(PropertyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PropertyType.class, PropertyType::toString);
    }
}

