/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.IcebergPartitionSpec;
import software.amazon.awssdk.services.glue.model.IcebergSchema;
import software.amazon.awssdk.services.glue.model.IcebergSortOrder;
import software.amazon.awssdk.services.glue.model.StringToStringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergTableUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergTableUpdate> {
    private static final SdkField<IcebergSchema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schema").getter(IcebergTableUpdate.getter(IcebergTableUpdate::schema)).setter(IcebergTableUpdate.setter(Builder::schema)).constructor(IcebergSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<IcebergPartitionSpec> PARTITION_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PartitionSpec").getter(IcebergTableUpdate.getter(IcebergTableUpdate::partitionSpec)).setter(IcebergTableUpdate.setter(Builder::partitionSpec)).constructor(IcebergPartitionSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSpec").build()}).build();
    private static final SdkField<IcebergSortOrder> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortOrder").getter(IcebergTableUpdate.getter(IcebergTableUpdate::sortOrder)).setter(IcebergTableUpdate.setter(Builder::sortOrder)).constructor(IcebergSortOrder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(IcebergTableUpdate.getter(IcebergTableUpdate::location)).setter(IcebergTableUpdate.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Properties").getter(IcebergTableUpdate.getter(IcebergTableUpdate::properties)).setter(IcebergTableUpdate.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD, PARTITION_SPEC_FIELD, SORT_ORDER_FIELD, LOCATION_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergTableUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IcebergSchema schema;
    private final IcebergPartitionSpec partitionSpec;
    private final IcebergSortOrder sortOrder;
    private final String location;
    private final Map<String, String> properties;

    private IcebergTableUpdate(BuilderImpl builder) {
        this.schema = builder.schema;
        this.partitionSpec = builder.partitionSpec;
        this.sortOrder = builder.sortOrder;
        this.location = builder.location;
        this.properties = builder.properties;
    }

    public final IcebergSchema schema() {
        return this.schema;
    }

    public final IcebergPartitionSpec partitionSpec() {
        return this.partitionSpec;
    }

    public final IcebergSortOrder sortOrder() {
        return this.sortOrder;
    }

    public final String location() {
        return this.location;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergTableUpdate)) {
            return false;
        }
        IcebergTableUpdate other = (IcebergTableUpdate)obj;
        return Objects.equals(this.schema(), other.schema()) && Objects.equals(this.partitionSpec(), other.partitionSpec()) && Objects.equals(this.sortOrder(), other.sortOrder()) && Objects.equals(this.location(), other.location()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergTableUpdate").add("Schema", (Object)this.schema()).add("PartitionSpec", (Object)this.partitionSpec()).add("SortOrder", (Object)this.sortOrder()).add("Location", (Object)this.location()).add("Properties", this.hasProperties() ? this.properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "PartitionSpec": {
                return Optional.ofNullable(clazz.cast(this.partitionSpec()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrder()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Schema", SCHEMA_FIELD);
        map.put("PartitionSpec", PARTITION_SPEC_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergTableUpdate, T> g) {
        return obj -> g.apply((IcebergTableUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IcebergSchema schema;
        private IcebergPartitionSpec partitionSpec;
        private IcebergSortOrder sortOrder;
        private String location;
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergTableUpdate model) {
            this.schema(model.schema);
            this.partitionSpec(model.partitionSpec);
            this.sortOrder(model.sortOrder);
            this.location(model.location);
            this.properties(model.properties);
        }

        public final IcebergSchema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(IcebergSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(IcebergSchema schema) {
            this.schema = schema;
            return this;
        }

        public final IcebergPartitionSpec.Builder getPartitionSpec() {
            return this.partitionSpec != null ? this.partitionSpec.toBuilder() : null;
        }

        public final void setPartitionSpec(IcebergPartitionSpec.BuilderImpl partitionSpec) {
            this.partitionSpec = partitionSpec != null ? partitionSpec.build() : null;
        }

        @Override
        public final Builder partitionSpec(IcebergPartitionSpec partitionSpec) {
            this.partitionSpec = partitionSpec;
            return this;
        }

        public final IcebergSortOrder.Builder getSortOrder() {
            return this.sortOrder != null ? this.sortOrder.toBuilder() : null;
        }

        public final void setSortOrder(IcebergSortOrder.BuilderImpl sortOrder) {
            this.sortOrder = sortOrder != null ? sortOrder.build() : null;
        }

        @Override
        public final Builder sortOrder(IcebergSortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = StringToStringMapCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = StringToStringMapCopier.copy(properties);
            return this;
        }

        public IcebergTableUpdate build() {
            return new IcebergTableUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergTableUpdate> {
        public Builder schema(IcebergSchema var1);

        default public Builder schema(Consumer<IcebergSchema.Builder> schema) {
            return this.schema((IcebergSchema)((IcebergSchema.Builder)IcebergSchema.builder().applyMutation(schema)).build());
        }

        public Builder partitionSpec(IcebergPartitionSpec var1);

        default public Builder partitionSpec(Consumer<IcebergPartitionSpec.Builder> partitionSpec) {
            return this.partitionSpec((IcebergPartitionSpec)((IcebergPartitionSpec.Builder)IcebergPartitionSpec.builder().applyMutation(partitionSpec)).build());
        }

        public Builder sortOrder(IcebergSortOrder var1);

        default public Builder sortOrder(Consumer<IcebergSortOrder.Builder> sortOrder) {
            return this.sortOrder((IcebergSortOrder)((IcebergSortOrder.Builder)IcebergSortOrder.builder().applyMutation(sortOrder)).build());
        }

        public Builder location(String var1);

        public Builder properties(Map<String, String> var1);
    }
}

