/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatabasesRequest extends GlueRequest implements
        ToCopyableBuilder<GetDatabasesRequest.Builder, GetDatabasesRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetDatabasesRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetDatabasesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetDatabasesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceShareType").getter(getter(GetDatabasesRequest::resourceShareTypeAsString))
            .setter(setter(Builder::resourceShareType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareType").build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributesToGet")
            .getter(getter(GetDatabasesRequest::attributesToGetAsStrings))
            .setter(setter(Builder::attributesToGetWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOURCE_SHARE_TYPE_FIELD, ATTRIBUTES_TO_GET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogId;

    private final String nextToken;

    private final Integer maxResults;

    private final String resourceShareType;

    private final List<String> attributesToGet;

    private GetDatabasesRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceShareType = builder.resourceShareType;
        this.attributesToGet = builder.attributesToGet;
    }

    /**
     * <p>
     * The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is provided, the Amazon Web
     * Services account ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is provided, the Amazon
     *         Web Services account ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of databases to return in one response.
     * </p>
     * 
     * @return The maximum number of databases to return in one response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Allows you to specify that you want to list the databases shared with your account. The allowable values are
     * <code>FEDERATED</code>, <code>FOREIGN</code> or <code>ALL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If set to <code>FEDERATED</code>, will list the federated databases (referencing an external entity) shared with
     * your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If set to <code>FOREIGN</code>, will list the databases shared with your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor
     * local account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceShareType}
     * will return {@link ResourceShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceShareTypeAsString}.
     * </p>
     * 
     * @return Allows you to specify that you want to list the databases shared with your account. The allowable values
     *         are <code>FEDERATED</code>, <code>FOREIGN</code> or <code>ALL</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If set to <code>FEDERATED</code>, will list the federated databases (referencing an external entity)
     *         shared with your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If set to <code>FOREIGN</code>, will list the databases shared with your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in
     *         yor local account.
     *         </p>
     *         </li>
     * @see ResourceShareType
     */
    public final ResourceShareType resourceShareType() {
        return ResourceShareType.fromValue(resourceShareType);
    }

    /**
     * <p>
     * Allows you to specify that you want to list the databases shared with your account. The allowable values are
     * <code>FEDERATED</code>, <code>FOREIGN</code> or <code>ALL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If set to <code>FEDERATED</code>, will list the federated databases (referencing an external entity) shared with
     * your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If set to <code>FOREIGN</code>, will list the databases shared with your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor
     * local account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceShareType}
     * will return {@link ResourceShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceShareTypeAsString}.
     * </p>
     * 
     * @return Allows you to specify that you want to list the databases shared with your account. The allowable values
     *         are <code>FEDERATED</code>, <code>FOREIGN</code> or <code>ALL</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If set to <code>FEDERATED</code>, will list the federated databases (referencing an external entity)
     *         shared with your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If set to <code>FOREIGN</code>, will list the databases shared with your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in
     *         yor local account.
     *         </p>
     *         </li>
     * @see ResourceShareType
     */
    public final String resourceShareTypeAsString() {
        return resourceShareType;
    }

    /**
     * <p>
     * Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t accept an
     * empty list. The request must include the <code>NAME</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToGet} method.
     * </p>
     * 
     * @return Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t
     *         accept an empty list. The request must include the <code>NAME</code>.
     */
    public final List<DatabaseAttributes> attributesToGet() {
        return DatabaseAttributesListCopier.copyStringToEnum(attributesToGet);
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributesToGet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributesToGet() {
        return attributesToGet != null && !(attributesToGet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t accept an
     * empty list. The request must include the <code>NAME</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToGet} method.
     * </p>
     * 
     * @return Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t
     *         accept an empty list. The request must include the <code>NAME</code>.
     */
    public final List<String> attributesToGetAsStrings() {
        return attributesToGet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesToGet() ? attributesToGetAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatabasesRequest)) {
            return false;
        }
        GetDatabasesRequest other = (GetDatabasesRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(resourceShareTypeAsString(), other.resourceShareTypeAsString())
                && hasAttributesToGet() == other.hasAttributesToGet()
                && Objects.equals(attributesToGetAsStrings(), other.attributesToGetAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatabasesRequest").add("CatalogId", catalogId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("ResourceShareType", resourceShareTypeAsString())
                .add("AttributesToGet", hasAttributesToGet() ? attributesToGetAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ResourceShareType":
            return Optional.ofNullable(clazz.cast(resourceShareTypeAsString()));
        case "AttributesToGet":
            return Optional.ofNullable(clazz.cast(attributesToGetAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("ResourceShareType", RESOURCE_SHARE_TYPE_FIELD);
        map.put("AttributesToGet", ATTRIBUTES_TO_GET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDatabasesRequest, T> g) {
        return obj -> g.apply((GetDatabasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDatabasesRequest> {
        /**
         * <p>
         * The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is provided, the Amazon Web
         * Services account ID is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is provided, the
         *        Amazon Web Services account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A continuation token, if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of databases to return in one response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of databases to return in one response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Allows you to specify that you want to list the databases shared with your account. The allowable values are
         * <code>FEDERATED</code>, <code>FOREIGN</code> or <code>ALL</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If set to <code>FEDERATED</code>, will list the federated databases (referencing an external entity) shared
         * with your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If set to <code>FOREIGN</code>, will list the databases shared with your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor
         * local account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceShareType
         *        Allows you to specify that you want to list the databases shared with your account. The allowable
         *        values are <code>FEDERATED</code>, <code>FOREIGN</code> or <code>ALL</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If set to <code>FEDERATED</code>, will list the federated databases (referencing an external entity)
         *        shared with your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If set to <code>FOREIGN</code>, will list the databases shared with your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases
         *        in yor local account.
         *        </p>
         *        </li>
         * @see ResourceShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareType
         */
        Builder resourceShareType(String resourceShareType);

        /**
         * <p>
         * Allows you to specify that you want to list the databases shared with your account. The allowable values are
         * <code>FEDERATED</code>, <code>FOREIGN</code> or <code>ALL</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If set to <code>FEDERATED</code>, will list the federated databases (referencing an external entity) shared
         * with your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If set to <code>FOREIGN</code>, will list the databases shared with your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor
         * local account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceShareType
         *        Allows you to specify that you want to list the databases shared with your account. The allowable
         *        values are <code>FEDERATED</code>, <code>FOREIGN</code> or <code>ALL</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If set to <code>FEDERATED</code>, will list the federated databases (referencing an external entity)
         *        shared with your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If set to <code>FOREIGN</code>, will list the databases shared with your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases
         *        in yor local account.
         *        </p>
         *        </li>
         * @see ResourceShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareType
         */
        Builder resourceShareType(ResourceShareType resourceShareType);

        /**
         * <p>
         * Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t accept
         * an empty list. The request must include the <code>NAME</code>.
         * </p>
         * 
         * @param attributesToGet
         *        Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t
         *        accept an empty list. The request must include the <code>NAME</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGetWithStrings(Collection<String> attributesToGet);

        /**
         * <p>
         * Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t accept
         * an empty list. The request must include the <code>NAME</code>.
         * </p>
         * 
         * @param attributesToGet
         *        Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t
         *        accept an empty list. The request must include the <code>NAME</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGetWithStrings(String... attributesToGet);

        /**
         * <p>
         * Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t accept
         * an empty list. The request must include the <code>NAME</code>.
         * </p>
         * 
         * @param attributesToGet
         *        Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t
         *        accept an empty list. The request must include the <code>NAME</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(Collection<DatabaseAttributes> attributesToGet);

        /**
         * <p>
         * Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t accept
         * an empty list. The request must include the <code>NAME</code>.
         * </p>
         * 
         * @param attributesToGet
         *        Specifies the database fields returned by the <code>GetDatabases</code> call. This parameter doesn’t
         *        accept an empty list. The request must include the <code>NAME</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(DatabaseAttributes... attributesToGet);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String nextToken;

        private Integer maxResults;

        private String resourceShareType;

        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatabasesRequest model) {
            super(model);
            catalogId(model.catalogId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            resourceShareType(model.resourceShareType);
            attributesToGetWithStrings(model.attributesToGet);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getResourceShareType() {
            return resourceShareType;
        }

        public final void setResourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
        }

        @Override
        public final Builder resourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
            return this;
        }

        @Override
        public final Builder resourceShareType(ResourceShareType resourceShareType) {
            this.resourceShareType(resourceShareType == null ? null : resourceShareType.toString());
            return this;
        }

        public final Collection<String> getAttributesToGet() {
            if (attributesToGet instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesToGet;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = DatabaseAttributesListCopier.copy(attributesToGet);
        }

        @Override
        public final Builder attributesToGetWithStrings(Collection<String> attributesToGet) {
            this.attributesToGet = DatabaseAttributesListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGetWithStrings(String... attributesToGet) {
            attributesToGetWithStrings(Arrays.asList(attributesToGet));
            return this;
        }

        @Override
        public final Builder attributesToGet(Collection<DatabaseAttributes> attributesToGet) {
            this.attributesToGet = DatabaseAttributesListCopier.copyEnumToString(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(DatabaseAttributes... attributesToGet) {
            attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDatabasesRequest build() {
            return new GetDatabasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
