/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUnfilteredPartitionsMetadataResponse extends GlueResponse implements
        ToCopyableBuilder<GetUnfilteredPartitionsMetadataResponse.Builder, GetUnfilteredPartitionsMetadataResponse> {
    private static final SdkField<List<UnfilteredPartition>> UNFILTERED_PARTITIONS_FIELD = SdkField
            .<List<UnfilteredPartition>> builder(MarshallingType.LIST)
            .memberName("UnfilteredPartitions")
            .getter(getter(GetUnfilteredPartitionsMetadataResponse::unfilteredPartitions))
            .setter(setter(Builder::unfilteredPartitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnfilteredPartitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnfilteredPartition> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnfilteredPartition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetUnfilteredPartitionsMetadataResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNFILTERED_PARTITIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UnfilteredPartition> unfilteredPartitions;

    private final String nextToken;

    private GetUnfilteredPartitionsMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.unfilteredPartitions = builder.unfilteredPartitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnfilteredPartitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnfilteredPartitions() {
        return unfilteredPartitions != null && !(unfilteredPartitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of requested partitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnfilteredPartitions} method.
     * </p>
     * 
     * @return A list of requested partitions.
     */
    public final List<UnfilteredPartition> unfilteredPartitions() {
        return unfilteredPartitions;
    }

    /**
     * <p>
     * A continuation token, if the returned list of partitions does not include the last one.
     * </p>
     * 
     * @return A continuation token, if the returned list of partitions does not include the last one.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUnfilteredPartitions() ? unfilteredPartitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredPartitionsMetadataResponse)) {
            return false;
        }
        GetUnfilteredPartitionsMetadataResponse other = (GetUnfilteredPartitionsMetadataResponse) obj;
        return hasUnfilteredPartitions() == other.hasUnfilteredPartitions()
                && Objects.equals(unfilteredPartitions(), other.unfilteredPartitions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUnfilteredPartitionsMetadataResponse")
                .add("UnfilteredPartitions", hasUnfilteredPartitions() ? unfilteredPartitions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnfilteredPartitions":
            return Optional.ofNullable(clazz.cast(unfilteredPartitions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UnfilteredPartitions", UNFILTERED_PARTITIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredPartitionsMetadataResponse, T> g) {
        return obj -> g.apply((GetUnfilteredPartitionsMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetUnfilteredPartitionsMetadataResponse> {
        /**
         * <p>
         * A list of requested partitions.
         * </p>
         * 
         * @param unfilteredPartitions
         *        A list of requested partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unfilteredPartitions(Collection<UnfilteredPartition> unfilteredPartitions);

        /**
         * <p>
         * A list of requested partitions.
         * </p>
         * 
         * @param unfilteredPartitions
         *        A list of requested partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unfilteredPartitions(UnfilteredPartition... unfilteredPartitions);

        /**
         * <p>
         * A list of requested partitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.UnfilteredPartition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.UnfilteredPartition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.UnfilteredPartition.Builder#build()} is called immediately
         * and its result is passed to {@link #unfilteredPartitions(List<UnfilteredPartition>)}.
         * 
         * @param unfilteredPartitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.UnfilteredPartition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unfilteredPartitions(java.util.Collection<UnfilteredPartition>)
         */
        Builder unfilteredPartitions(Consumer<UnfilteredPartition.Builder>... unfilteredPartitions);

        /**
         * <p>
         * A continuation token, if the returned list of partitions does not include the last one.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if the returned list of partitions does not include the last one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<UnfilteredPartition> unfilteredPartitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredPartitionsMetadataResponse model) {
            super(model);
            unfilteredPartitions(model.unfilteredPartitions);
            nextToken(model.nextToken);
        }

        public final List<UnfilteredPartition.Builder> getUnfilteredPartitions() {
            List<UnfilteredPartition.Builder> result = UnfilteredPartitionListCopier.copyToBuilder(this.unfilteredPartitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnfilteredPartitions(Collection<UnfilteredPartition.BuilderImpl> unfilteredPartitions) {
            this.unfilteredPartitions = UnfilteredPartitionListCopier.copyFromBuilder(unfilteredPartitions);
        }

        @Override
        public final Builder unfilteredPartitions(Collection<UnfilteredPartition> unfilteredPartitions) {
            this.unfilteredPartitions = UnfilteredPartitionListCopier.copy(unfilteredPartitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unfilteredPartitions(UnfilteredPartition... unfilteredPartitions) {
            unfilteredPartitions(Arrays.asList(unfilteredPartitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unfilteredPartitions(Consumer<UnfilteredPartition.Builder>... unfilteredPartitions) {
            unfilteredPartitions(Stream.of(unfilteredPartitions).map(c -> UnfilteredPartition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetUnfilteredPartitionsMetadataResponse build() {
            return new GetUnfilteredPartitionsMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
