/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCrawlsResponse extends GlueResponse implements
        ToCopyableBuilder<ListCrawlsResponse.Builder, ListCrawlsResponse> {
    private static final SdkField<List<CrawlerHistory>> CRAWLS_FIELD = SdkField
            .<List<CrawlerHistory>> builder(MarshallingType.LIST)
            .memberName("Crawls")
            .getter(getter(ListCrawlsResponse::crawls))
            .setter(setter(Builder::crawls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Crawls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CrawlerHistory> builder(MarshallingType.SDK_POJO)
                                            .constructor(CrawlerHistory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCrawlsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CRAWLS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CrawlerHistory> crawls;

    private final String nextToken;

    private ListCrawlsResponse(BuilderImpl builder) {
        super(builder);
        this.crawls = builder.crawls;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Crawls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCrawls() {
        return crawls != null && !(crawls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrawls} method.
     * </p>
     * 
     * @return A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     */
    public final List<CrawlerHistory> crawls() {
        return crawls;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     * 
     * @return A continuation token for paginating the returned list of tokens, returned if the current segment of the
     *         list is not the last.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCrawls() ? crawls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCrawlsResponse)) {
            return false;
        }
        ListCrawlsResponse other = (ListCrawlsResponse) obj;
        return hasCrawls() == other.hasCrawls() && Objects.equals(crawls(), other.crawls())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCrawlsResponse").add("Crawls", hasCrawls() ? crawls() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Crawls":
            return Optional.ofNullable(clazz.cast(crawls()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Crawls", CRAWLS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCrawlsResponse, T> g) {
        return obj -> g.apply((ListCrawlsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCrawlsResponse> {
        /**
         * <p>
         * A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
         * </p>
         * 
         * @param crawls
         *        A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawls(Collection<CrawlerHistory> crawls);

        /**
         * <p>
         * A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
         * </p>
         * 
         * @param crawls
         *        A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawls(CrawlerHistory... crawls);

        /**
         * <p>
         * A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.CrawlerHistory.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.CrawlerHistory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.CrawlerHistory.Builder#build()} is called immediately and
         * its result is passed to {@link #crawls(List<CrawlerHistory>)}.
         * 
         * @param crawls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.CrawlerHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crawls(java.util.Collection<CrawlerHistory>)
         */
        Builder crawls(Consumer<CrawlerHistory.Builder>... crawls);

        /**
         * <p>
         * A continuation token for paginating the returned list of tokens, returned if the current segment of the list
         * is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token for paginating the returned list of tokens, returned if the current segment of
         *        the list is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<CrawlerHistory> crawls = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCrawlsResponse model) {
            super(model);
            crawls(model.crawls);
            nextToken(model.nextToken);
        }

        public final List<CrawlerHistory.Builder> getCrawls() {
            List<CrawlerHistory.Builder> result = CrawlerHistoryListCopier.copyToBuilder(this.crawls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrawls(Collection<CrawlerHistory.BuilderImpl> crawls) {
            this.crawls = CrawlerHistoryListCopier.copyFromBuilder(crawls);
        }

        @Override
        public final Builder crawls(Collection<CrawlerHistory> crawls) {
            this.crawls = CrawlerHistoryListCopier.copy(crawls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawls(CrawlerHistory... crawls) {
            crawls(Arrays.asList(crawls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawls(Consumer<CrawlerHistory.Builder>... crawls) {
            crawls(Stream.of(crawls).map(c -> CrawlerHistory.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCrawlsResponse build() {
            return new ListCrawlsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
