/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a Hudi data source stored in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3HudiSource implements SdkPojo, Serializable, ToCopyableBuilder<S3HudiSource.Builder, S3HudiSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(S3HudiSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Paths")
            .getter(getter(S3HudiSource::paths))
            .setter(setter(Builder::paths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Paths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_HUDI_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalHudiOptions")
            .getter(getter(S3HudiSource::additionalHudiOptions))
            .setter(setter(Builder::additionalHudiOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalHudiOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<S3DirectSourceAdditionalOptions> ADDITIONAL_OPTIONS_FIELD = SdkField
            .<S3DirectSourceAdditionalOptions> builder(MarshallingType.SDK_POJO).memberName("AdditionalOptions")
            .getter(getter(S3HudiSource::additionalOptions)).setter(setter(Builder::additionalOptions))
            .constructor(S3DirectSourceAdditionalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build()).build();

    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField
            .<List<GlueSchema>> builder(MarshallingType.LIST)
            .memberName("OutputSchemas")
            .getter(getter(S3HudiSource::outputSchemas))
            .setter(setter(Builder::outputSchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlueSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlueSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATHS_FIELD,
            ADDITIONAL_HUDI_OPTIONS_FIELD, ADDITIONAL_OPTIONS_FIELD, OUTPUT_SCHEMAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> paths;

    private final Map<String, String> additionalHudiOptions;

    private final S3DirectSourceAdditionalOptions additionalOptions;

    private final List<GlueSchema> outputSchemas;

    private S3HudiSource(BuilderImpl builder) {
        this.name = builder.name;
        this.paths = builder.paths;
        this.additionalHudiOptions = builder.additionalHudiOptions;
        this.additionalOptions = builder.additionalOptions;
        this.outputSchemas = builder.outputSchemas;
    }

    /**
     * <p>
     * The name of the Hudi source.
     * </p>
     * 
     * @return The name of the Hudi source.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Paths property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPaths() {
        return paths != null && !(paths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Amazon S3 paths to read from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPaths} method.
     * </p>
     * 
     * @return A list of the Amazon S3 paths to read from.
     */
    public final List<String> paths() {
        return paths;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalHudiOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalHudiOptions() {
        return additionalHudiOptions != null && !(additionalHudiOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies additional connection options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalHudiOptions} method.
     * </p>
     * 
     * @return Specifies additional connection options.
     */
    public final Map<String, String> additionalHudiOptions() {
        return additionalHudiOptions;
    }

    /**
     * <p>
     * Specifies additional options for the connector.
     * </p>
     * 
     * @return Specifies additional options for the connector.
     */
    public final S3DirectSourceAdditionalOptions additionalOptions() {
        return additionalOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSchemas property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSchemas() {
        return outputSchemas != null && !(outputSchemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the data schema for the Hudi source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSchemas} method.
     * </p>
     * 
     * @return Specifies the data schema for the Hudi source.
     */
    public final List<GlueSchema> outputSchemas() {
        return outputSchemas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasPaths() ? paths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalHudiOptions() ? additionalHudiOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(additionalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSchemas() ? outputSchemas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3HudiSource)) {
            return false;
        }
        S3HudiSource other = (S3HudiSource) obj;
        return Objects.equals(name(), other.name()) && hasPaths() == other.hasPaths() && Objects.equals(paths(), other.paths())
                && hasAdditionalHudiOptions() == other.hasAdditionalHudiOptions()
                && Objects.equals(additionalHudiOptions(), other.additionalHudiOptions())
                && Objects.equals(additionalOptions(), other.additionalOptions())
                && hasOutputSchemas() == other.hasOutputSchemas() && Objects.equals(outputSchemas(), other.outputSchemas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3HudiSource").add("Name", name()).add("Paths", hasPaths() ? paths() : null)
                .add("AdditionalHudiOptions", hasAdditionalHudiOptions() ? additionalHudiOptions() : null)
                .add("AdditionalOptions", additionalOptions()).add("OutputSchemas", hasOutputSchemas() ? outputSchemas() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Paths":
            return Optional.ofNullable(clazz.cast(paths()));
        case "AdditionalHudiOptions":
            return Optional.ofNullable(clazz.cast(additionalHudiOptions()));
        case "AdditionalOptions":
            return Optional.ofNullable(clazz.cast(additionalOptions()));
        case "OutputSchemas":
            return Optional.ofNullable(clazz.cast(outputSchemas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Paths", PATHS_FIELD);
        map.put("AdditionalHudiOptions", ADDITIONAL_HUDI_OPTIONS_FIELD);
        map.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        map.put("OutputSchemas", OUTPUT_SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3HudiSource, T> g) {
        return obj -> g.apply((S3HudiSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3HudiSource> {
        /**
         * <p>
         * The name of the Hudi source.
         * </p>
         * 
         * @param name
         *        The name of the Hudi source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of the Amazon S3 paths to read from.
         * </p>
         * 
         * @param paths
         *        A list of the Amazon S3 paths to read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paths(Collection<String> paths);

        /**
         * <p>
         * A list of the Amazon S3 paths to read from.
         * </p>
         * 
         * @param paths
         *        A list of the Amazon S3 paths to read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paths(String... paths);

        /**
         * <p>
         * Specifies additional connection options.
         * </p>
         * 
         * @param additionalHudiOptions
         *        Specifies additional connection options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalHudiOptions(Map<String, String> additionalHudiOptions);

        /**
         * <p>
         * Specifies additional options for the connector.
         * </p>
         * 
         * @param additionalOptions
         *        Specifies additional options for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalOptions(S3DirectSourceAdditionalOptions additionalOptions);

        /**
         * <p>
         * Specifies additional options for the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DirectSourceAdditionalOptions.Builder}
         * avoiding the need to create one manually via {@link S3DirectSourceAdditionalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DirectSourceAdditionalOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalOptions(S3DirectSourceAdditionalOptions)}.
         * 
         * @param additionalOptions
         *        a consumer that will call methods on {@link S3DirectSourceAdditionalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalOptions(S3DirectSourceAdditionalOptions)
         */
        default Builder additionalOptions(Consumer<S3DirectSourceAdditionalOptions.Builder> additionalOptions) {
            return additionalOptions(S3DirectSourceAdditionalOptions.builder().applyMutation(additionalOptions).build());
        }

        /**
         * <p>
         * Specifies the data schema for the Hudi source.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the Hudi source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(Collection<GlueSchema> outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the Hudi source.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the Hudi source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(GlueSchema... outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the Hudi source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.GlueSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSchemas(List<GlueSchema>)}.
         * 
         * @param outputSchemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSchemas(java.util.Collection<GlueSchema>)
         */
        Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> paths = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> additionalHudiOptions = DefaultSdkAutoConstructMap.getInstance();

        private S3DirectSourceAdditionalOptions additionalOptions;

        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3HudiSource model) {
            name(model.name);
            paths(model.paths);
            additionalHudiOptions(model.additionalHudiOptions);
            additionalOptions(model.additionalOptions);
            outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getPaths() {
            if (paths instanceof SdkAutoConstructList) {
                return null;
            }
            return paths;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = EnclosedInStringPropertiesCopier.copy(paths);
        }

        @Override
        public final Builder paths(Collection<String> paths) {
            this.paths = EnclosedInStringPropertiesCopier.copy(paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paths(String... paths) {
            paths(Arrays.asList(paths));
            return this;
        }

        public final Map<String, String> getAdditionalHudiOptions() {
            if (additionalHudiOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalHudiOptions;
        }

        public final void setAdditionalHudiOptions(Map<String, String> additionalHudiOptions) {
            this.additionalHudiOptions = AdditionalOptionsCopier.copy(additionalHudiOptions);
        }

        @Override
        public final Builder additionalHudiOptions(Map<String, String> additionalHudiOptions) {
            this.additionalHudiOptions = AdditionalOptionsCopier.copy(additionalHudiOptions);
            return this;
        }

        public final S3DirectSourceAdditionalOptions.Builder getAdditionalOptions() {
            return additionalOptions != null ? additionalOptions.toBuilder() : null;
        }

        public final void setAdditionalOptions(S3DirectSourceAdditionalOptions.BuilderImpl additionalOptions) {
            this.additionalOptions = additionalOptions != null ? additionalOptions.build() : null;
        }

        @Override
        public final Builder additionalOptions(S3DirectSourceAdditionalOptions additionalOptions) {
            this.additionalOptions = additionalOptions;
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema... outputSchemas) {
            outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas) {
            outputSchemas(Stream.of(outputSchemas).map(c -> GlueSchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public S3HudiSource build() {
            return new S3HudiSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
