/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties used by the source leg to process data from the source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceTableConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceTableConfig.Builder, SourceTableConfig> {
    private static final SdkField<List<String>> FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(SourceTableConfig::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FILTER_PREDICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterPredicate").getter(getter(SourceTableConfig::filterPredicate))
            .setter(setter(Builder::filterPredicate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPredicate").build()).build();

    private static final SdkField<List<String>> PRIMARY_KEY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrimaryKey")
            .getter(getter(SourceTableConfig::primaryKey))
            .setter(setter(Builder::primaryKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryKey").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECORD_UPDATE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordUpdateField").getter(getter(SourceTableConfig::recordUpdateField))
            .setter(setter(Builder::recordUpdateField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordUpdateField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD,
            FILTER_PREDICATE_FIELD, PRIMARY_KEY_FIELD, RECORD_UPDATE_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> fields;

    private final String filterPredicate;

    private final List<String> primaryKey;

    private final String recordUpdateField;

    private SourceTableConfig(BuilderImpl builder) {
        this.fields = builder.fields;
        this.filterPredicate = builder.filterPredicate;
        this.primaryKey = builder.primaryKey;
        this.recordUpdateField = builder.recordUpdateField;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of fields used for column-level filtering. Currently unsupported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return A list of fields used for column-level filtering. Currently unsupported.
     */
    public final List<String> fields() {
        return fields;
    }

    /**
     * <p>
     * A condition clause used for row-level filtering. Currently unsupported.
     * </p>
     * 
     * @return A condition clause used for row-level filtering. Currently unsupported.
     */
    public final String filterPredicate() {
        return filterPredicate;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryKey property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrimaryKey() {
        return primaryKey != null && !(primaryKey instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provide the primary key set for this table. Currently supported specifically for SAP <code>EntityOf</code>
     * entities upon request. Contact Amazon Web Services Support to make this feature available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryKey} method.
     * </p>
     * 
     * @return Provide the primary key set for this table. Currently supported specifically for SAP
     *         <code>EntityOf</code> entities upon request. Contact Amazon Web Services Support to make this feature
     *         available.
     */
    public final List<String> primaryKey() {
        return primaryKey;
    }

    /**
     * <p>
     * Incremental pull timestamp-based field. Currently unsupported.
     * </p>
     * 
     * @return Incremental pull timestamp-based field. Currently unsupported.
     */
    public final String recordUpdateField() {
        return recordUpdateField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filterPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryKey() ? primaryKey() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recordUpdateField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceTableConfig)) {
            return false;
        }
        SourceTableConfig other = (SourceTableConfig) obj;
        return hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(filterPredicate(), other.filterPredicate()) && hasPrimaryKey() == other.hasPrimaryKey()
                && Objects.equals(primaryKey(), other.primaryKey())
                && Objects.equals(recordUpdateField(), other.recordUpdateField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceTableConfig").add("Fields", hasFields() ? fields() : null)
                .add("FilterPredicate", filterPredicate()).add("PrimaryKey", hasPrimaryKey() ? primaryKey() : null)
                .add("RecordUpdateField", recordUpdateField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "FilterPredicate":
            return Optional.ofNullable(clazz.cast(filterPredicate()));
        case "PrimaryKey":
            return Optional.ofNullable(clazz.cast(primaryKey()));
        case "RecordUpdateField":
            return Optional.ofNullable(clazz.cast(recordUpdateField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Fields", FIELDS_FIELD);
        map.put("FilterPredicate", FILTER_PREDICATE_FIELD);
        map.put("PrimaryKey", PRIMARY_KEY_FIELD);
        map.put("RecordUpdateField", RECORD_UPDATE_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceTableConfig, T> g) {
        return obj -> g.apply((SourceTableConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceTableConfig> {
        /**
         * <p>
         * A list of fields used for column-level filtering. Currently unsupported.
         * </p>
         * 
         * @param fields
         *        A list of fields used for column-level filtering. Currently unsupported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<String> fields);

        /**
         * <p>
         * A list of fields used for column-level filtering. Currently unsupported.
         * </p>
         * 
         * @param fields
         *        A list of fields used for column-level filtering. Currently unsupported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(String... fields);

        /**
         * <p>
         * A condition clause used for row-level filtering. Currently unsupported.
         * </p>
         * 
         * @param filterPredicate
         *        A condition clause used for row-level filtering. Currently unsupported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPredicate(String filterPredicate);

        /**
         * <p>
         * Provide the primary key set for this table. Currently supported specifically for SAP <code>EntityOf</code>
         * entities upon request. Contact Amazon Web Services Support to make this feature available.
         * </p>
         * 
         * @param primaryKey
         *        Provide the primary key set for this table. Currently supported specifically for SAP
         *        <code>EntityOf</code> entities upon request. Contact Amazon Web Services Support to make this feature
         *        available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKey(Collection<String> primaryKey);

        /**
         * <p>
         * Provide the primary key set for this table. Currently supported specifically for SAP <code>EntityOf</code>
         * entities upon request. Contact Amazon Web Services Support to make this feature available.
         * </p>
         * 
         * @param primaryKey
         *        Provide the primary key set for this table. Currently supported specifically for SAP
         *        <code>EntityOf</code> entities upon request. Contact Amazon Web Services Support to make this feature
         *        available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKey(String... primaryKey);

        /**
         * <p>
         * Incremental pull timestamp-based field. Currently unsupported.
         * </p>
         * 
         * @param recordUpdateField
         *        Incremental pull timestamp-based field. Currently unsupported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordUpdateField(String recordUpdateField);
    }

    static final class BuilderImpl implements Builder {
        private List<String> fields = DefaultSdkAutoConstructList.getInstance();

        private String filterPredicate;

        private List<String> primaryKey = DefaultSdkAutoConstructList.getInstance();

        private String recordUpdateField;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceTableConfig model) {
            fields(model.fields);
            filterPredicate(model.filterPredicate);
            primaryKey(model.primaryKey);
            recordUpdateField(model.recordUpdateField);
        }

        public final Collection<String> getFields() {
            if (fields instanceof SdkAutoConstructList) {
                return null;
            }
            return fields;
        }

        public final void setFields(Collection<String> fields) {
            this.fields = SourceTableFieldsListCopier.copy(fields);
        }

        @Override
        public final Builder fields(Collection<String> fields) {
            this.fields = SourceTableFieldsListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(String... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        public final String getFilterPredicate() {
            return filterPredicate;
        }

        public final void setFilterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
        }

        @Override
        public final Builder filterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
            return this;
        }

        public final Collection<String> getPrimaryKey() {
            if (primaryKey instanceof SdkAutoConstructList) {
                return null;
            }
            return primaryKey;
        }

        public final void setPrimaryKey(Collection<String> primaryKey) {
            this.primaryKey = PrimaryKeyListCopier.copy(primaryKey);
        }

        @Override
        public final Builder primaryKey(Collection<String> primaryKey) {
            this.primaryKey = PrimaryKeyListCopier.copy(primaryKey);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryKey(String... primaryKey) {
            primaryKey(Arrays.asList(primaryKey));
            return this;
        }

        public final String getRecordUpdateField() {
            return recordUpdateField;
        }

        public final void setRecordUpdateField(String recordUpdateField) {
            this.recordUpdateField = recordUpdateField;
        }

        @Override
        public final Builder recordUpdateField(String recordUpdateField) {
            this.recordUpdateField = recordUpdateField;
            return this;
        }

        @Override
        public SourceTableConfig build() {
            return new SourceTableConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
