/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListUsageProfilesRequest;
import software.amazon.awssdk.services.glue.model.ListUsageProfilesResponse;
import software.amazon.awssdk.services.glue.model.UsageProfileDefinition;

public class ListUsageProfilesPublisher
implements SdkPublisher<ListUsageProfilesResponse> {
    private final GlueAsyncClient client;
    private final ListUsageProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUsageProfilesPublisher(GlueAsyncClient client, ListUsageProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUsageProfilesPublisher(GlueAsyncClient client, ListUsageProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUsageProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUsageProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UsageProfileDefinition> profiles() {
        Function<ListUsageProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.profiles() != null) {
                return response.profiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUsageProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUsageProfilesResponseFetcher
    implements AsyncPageFetcher<ListUsageProfilesResponse> {
        private ListUsageProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListUsageProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUsageProfilesResponse> nextPage(ListUsageProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListUsageProfilesPublisher.this.client.listUsageProfiles(ListUsageProfilesPublisher.this.firstRequest);
            }
            return ListUsageProfilesPublisher.this.client.listUsageProfiles((ListUsageProfilesRequest)((Object)ListUsageProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

