/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnRowFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnRowFilter> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(ColumnRowFilter.getter(ColumnRowFilter::columnName)).setter(ColumnRowFilter.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<String> ROW_FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RowFilterExpression").getter(ColumnRowFilter.getter(ColumnRowFilter::rowFilterExpression)).setter(ColumnRowFilter.setter(Builder::rowFilterExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowFilterExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, ROW_FILTER_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ColumnRowFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final String rowFilterExpression;

    private ColumnRowFilter(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.rowFilterExpression = builder.rowFilterExpression;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final String rowFilterExpression() {
        return this.rowFilterExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowFilterExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnRowFilter)) {
            return false;
        }
        ColumnRowFilter other = (ColumnRowFilter)obj;
        return Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.rowFilterExpression(), other.rowFilterExpression());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnRowFilter").add("ColumnName", (Object)this.columnName()).add("RowFilterExpression", (Object)this.rowFilterExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "RowFilterExpression": {
                return Optional.ofNullable(clazz.cast(this.rowFilterExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ColumnName", COLUMN_NAME_FIELD);
        map.put("RowFilterExpression", ROW_FILTER_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnRowFilter, T> g) {
        return obj -> g.apply((ColumnRowFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private String rowFilterExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnRowFilter model) {
            this.columnName(model.columnName);
            this.rowFilterExpression(model.rowFilterExpression);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getRowFilterExpression() {
            return this.rowFilterExpression;
        }

        public final void setRowFilterExpression(String rowFilterExpression) {
            this.rowFilterExpression = rowFilterExpression;
        }

        @Override
        public final Builder rowFilterExpression(String rowFilterExpression) {
            this.rowFilterExpression = rowFilterExpression;
            return this;
        }

        public ColumnRowFilter build() {
            return new ColumnRowFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnRowFilter> {
        public Builder columnName(String var1);

        public Builder rowFilterExpression(String var1);
    }
}

